/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.ServerConfigLookup;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.web.ha.authenticator.HASingleSignOn;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class HASSOFactory
implements SSOFactory {
    private static final String STORE_NAME = "SSOStore";
    private static BackingStore ssoEntryMetadataBackingStore = null;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerConfigLookup serverConfigLookup;
    @Inject
    private JavaEEIOUtils ioUtils;

    public GlassFishSingleSignOn createSingleSignOnValve(String virtualServerName) {
        if (this.isSsoFailoverEnabled()) {
            String persistenceType = "replication";
            return new HASingleSignOn(this.ioUtils, HASSOFactory.getSsoEntryMetadataBackingStore(persistenceType, STORE_NAME, this.habitat));
        }
        return new GlassFishSingleSignOn();
    }

    private boolean isSsoFailoverEnabled() {
        boolean webContainerAvailabilityEnabled = this.serverConfigLookup.getWebContainerAvailabilityEnabledFromConfig();
        boolean isSsoFailoverEnabled = this.serverConfigLookup.isSsoFailoverEnabledFromConfig();
        return isSsoFailoverEnabled && webContainerAvailabilityEnabled;
    }

    protected static synchronized BackingStore getSsoEntryMetadataBackingStore(String persistenceType, String storeName, Habitat habitat) {
        if (ssoEntryMetadataBackingStore == null) {
            BackingStoreFactory factory = (BackingStoreFactory)habitat.getComponent(BackingStoreFactory.class, persistenceType);
            BackingStoreConfiguration conf = new BackingStoreConfiguration();
            String clusterName = "";
            String instanceName = "";
            GMSAdapterService gmsAdapterService = (GMSAdapterService)habitat.getComponent(GMSAdapterService.class);
            if (gmsAdapterService.isGmsEnabled()) {
                clusterName = gmsAdapterService.getGMSAdapter().getClusterName();
                instanceName = gmsAdapterService.getGMSAdapter().getModule().getInstanceName();
            }
            conf.setStoreName(storeName).setClusterName(clusterName).setInstanceName(instanceName).setStoreType(persistenceType).setKeyClazz(String.class).setValueClazz(HASingleSignOnEntryMetadata.class);
            try {
                ssoEntryMetadataBackingStore = factory.createBackingStore(conf);
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return ssoEntryMetadataBackingStore;
    }
}

