/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Engine;
import org.apache.catalina.core.StandardHost;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.Ports;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.web.ConfigException;
import org.glassfish.embeddable.web.Context;
import org.glassfish.embeddable.web.HttpListener;
import org.glassfish.embeddable.web.WebListener;
import org.glassfish.embeddable.web.config.WebContainerConfig;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.web.embed.impl.EmbeddedWebArchivist;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@ContractProvided(value=org.glassfish.embeddable.web.WebContainer.class)
public class WebContainerImpl
implements org.glassfish.embeddable.web.WebContainer {
    Inhabitant<? extends Container> container;
    Inhabitant<?> embeddedInhabitant;
    @Inject
    Habitat habitat;
    @Inject
    HttpService httpService;
    private static Logger log = Logger.getLogger(WebContainerImpl.class.getName());
    @Inject
    NetworkConfig networkConfig;
    @Inject
    ServerContext serverContext;
    private WebContainerConfig config;
    private EmbeddedWebContainer embedded;
    private Engine engine = null;
    private boolean initialized = false;
    private String listenerName = "embedded-listener";
    private List<WebListener> listeners = new ArrayList<WebListener>();
    private String securityEnabled = "false";
    private WebContainer webContainer;

    private void init() {
        if (this.initialized) {
            return;
        }
        if (this.config == null) {
            this.config = new WebContainerConfig();
        }
        this.container = this.habitat.getInhabitant(Container.class, "com.sun.enterprise.web.WebContainer");
        if (this.container == null) {
            log.severe("Cannot find webcontainer implementation");
            return;
        }
        this.embeddedInhabitant = this.habitat.getInhabitantByType("com.sun.enterprise.web.EmbeddedWebContainer");
        if (this.embeddedInhabitant == null) {
            log.severe("Cannot find embedded implementation");
            return;
        }
        try {
            this.webContainer = (WebContainer)this.container.get();
            this.embedded = (EmbeddedWebContainer)((Object)this.embeddedInhabitant.get());
            if (this.webContainer == null || this.embedded == null) {
                log.severe("Cannot find webcontainer implementation");
                return;
            }
            this.engine = this.webContainer.getEngine();
            if (this.engine == null) {
                log.severe("Cannot find engine implementation");
                return;
            }
            this.initialized = true;
        }
        catch (Exception e) {
            log.severe("Init exception " + e.getMessage());
        }
    }

    private void bind(Port port, WebListener webListener, String vsId) {
        String protocol = "http";
        final int portNumber = port.getPortNumber();
        final String defaultVS = vsId;
        if (webListener == null) {
            this.listenerName = this.getListenerName();
            webListener = new HttpListener();
            webListener.setId(this.listenerName);
            webListener.setPort(portNumber);
        } else {
            this.listenerName = webListener.getId();
            protocol = webListener.getProtocol();
        }
        this.listeners.add(webListener);
        if (protocol.equals("http")) {
            this.securityEnabled = "false";
        } else if (protocol.equals("https")) {
            this.securityEnabled = "true";
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws TransactionFailure {
                    Protocol protocol = (Protocol)param.createChild(Protocol.class);
                    protocol.setName(WebContainerImpl.this.listenerName);
                    protocol.setSecurityEnabled(WebContainerImpl.this.securityEnabled);
                    param.getProtocol().add(protocol);
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setDefaultVirtualServer(defaultVS);
                    http.setFileCache((FileCache)http.createChild(FileCache.class));
                    protocol.setHttp(http);
                    return protocol;
                }
            }, (ConfigBeanProxy)this.networkConfig.getProtocols());
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws TransactionFailure {
                    NetworkListeners nls = (NetworkListeners)params[0];
                    Transports transports = (Transports)params[1];
                    NetworkListener listener = (NetworkListener)nls.createChild(NetworkListener.class);
                    listener.setName(WebContainerImpl.this.listenerName);
                    listener.setPort(Integer.toString(portNumber));
                    listener.setProtocol(WebContainerImpl.this.listenerName);
                    listener.setThreadPool("http-thread-pool");
                    if (listener.findThreadPool() == null) {
                        ThreadPool pool = (ThreadPool)nls.createChild(ThreadPool.class);
                        pool.setName(WebContainerImpl.this.listenerName);
                        listener.setThreadPool(WebContainerImpl.this.listenerName);
                    }
                    listener.setTransport("tcp");
                    if (listener.findTransport() == null) {
                        Transport transport = (Transport)transports.createChild(Transport.class);
                        transport.setName(WebContainerImpl.this.listenerName);
                        listener.setTransport(WebContainerImpl.this.listenerName);
                    }
                    nls.getNetworkListener().add(listener);
                    return listener;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.networkConfig.getNetworkListeners(), this.networkConfig.getTransports()});
            com.sun.enterprise.config.serverbeans.VirtualServer vs = this.httpService.getVirtualServerByName(this.config.getVirtualServerId());
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<com.sun.enterprise.config.serverbeans.VirtualServer>(){

                public Object run(com.sun.enterprise.config.serverbeans.VirtualServer avs) throws PropertyVetoException {
                    avs.addNetworkListener(WebContainerImpl.this.listenerName);
                    return avs;
                }
            }, (ConfigBeanProxy)vs);
        }
        catch (Exception e) {
            this.removeListener(this.listenerName);
            e.printStackTrace();
        }
    }

    private void addWebListener(WebListener webListener, String vsId) throws ConfigException, GlassFishException {
        if (!this.initialized) {
            this.init();
        }
        if (this.getWebListener(webListener.getId()) != null) {
            throw new ConfigException("Connector with name '" + webListener.getId() + "' already exsits");
        }
        this.listenerName = webListener.getId();
        try {
            Ports ports = (Ports)this.habitat.getComponent(Ports.class);
            Port port = ports.createPort(webListener.getPort());
            this.bind(port, webListener, vsId);
        }
        catch (IOException ex) {
            throw new ConfigException((Throwable)ex);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Added connector " + webListener.getId() + " port " + webListener.getPort() + " to virtual server " + vsId);
        }
    }

    private String getListenerName() {
        int i = 1;
        if (!this.existsListener(this.listenerName)) {
            return this.listenerName;
        }
        String name = "embedded-listener";
        while (this.existsListener(name)) {
            name = "embedded-listener-" + i++;
        }
        return name;
    }

    private boolean existsListener(String lName) {
        for (NetworkListener nl : this.networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!nl.getName().equals(lName)) continue;
            return true;
        }
        return false;
    }

    private void removeListener(String name) {
        String listenerName = name;
        try {
            NetworkListeners networkListeners = this.networkConfig.getNetworkListeners();
            final NetworkListener listenerToBeRemoved = this.networkConfig.getNetworkListener(listenerName);
            if (listenerToBeRemoved == null) {
                log.severe("Network Listener " + listenerName + " doesn't exist");
            } else {
                com.sun.enterprise.config.serverbeans.VirtualServer virtualServer = this.httpService.getVirtualServerByName(listenerToBeRemoved.findHttpProtocol().getHttp().getDefaultVirtualServer());
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... params) throws PropertyVetoException {
                        NetworkListeners listeners = (NetworkListeners)params[0];
                        com.sun.enterprise.config.serverbeans.VirtualServer server = (com.sun.enterprise.config.serverbeans.VirtualServer)params[1];
                        listeners.getNetworkListener().remove(listenerToBeRemoved);
                        server.removeNetworkListener(listenerToBeRemoved.getName());
                        return listenerToBeRemoved;
                    }
                }, (ConfigBeanProxy[])new ConfigBeanProxy[]{networkListeners, virtualServer});
            }
        }
        catch (TransactionFailure e) {
            log.severe("Remove listener " + name + " failed " + e.getMessage());
        }
    }

    public void setConfiguration(WebContainerConfig config) {
        if (!this.initialized) {
            this.init();
        }
        this.config = config;
        final WebContainerConfig webConfig = config;
        try {
            com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
            org.glassfish.embeddable.web.VirtualServer vs = this.getVirtualServer(config.getVirtualServerId());
            if (vs != null) {
                ((StandardHost)vs).setDefaultWebXmlLocation(config.getDefaultWebXml().getPath());
            }
            if ((vsBean = this.httpService.getVirtualServerByName(config.getVirtualServerId())) != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<com.sun.enterprise.config.serverbeans.VirtualServer>(){

                    public Object run(com.sun.enterprise.config.serverbeans.VirtualServer avs) throws PropertyVetoException, TransactionFailure {
                        avs.setId(webConfig.getVirtualServerId());
                        if (webConfig.getDocRootDir() != null) {
                            avs.setDocroot(webConfig.getDocRootDir().getPath());
                        }
                        avs.setHosts(webConfig.getHostNames());
                        avs.setNetworkListeners(webConfig.getListenerName());
                        Property property = (Property)avs.createChild(Property.class);
                        property.setName("default-web-xml");
                        property.setValue(webConfig.getDefaultWebXml().getPath());
                        avs.getProperty().add(property);
                        return avs;
                    }
                }, (ConfigBeanProxy)vsBean);
            } else {
                vs = this.createVirtualServer(config.getVirtualServerId(), config.getDocRootDir());
                this.addVirtualServer(vs);
            }
            WebListener listener = this.getWebListener(config.getListenerName());
            if (listener == null) {
                listener = this.createWebListener(config.getListenerName(), HttpListener.class);
                listener.setPort(config.getPort());
                this.addWebListener(listener, config.getVirtualServerId());
            } else if (listener.getPort() != config.getPort()) {
                listener.setPort(config.getPort());
            }
            EmbeddedWebArchivist archivist = (EmbeddedWebArchivist)((Object)this.habitat.getComponent(EmbeddedWebArchivist.class));
            archivist.setDefaultWebXml(config.getDefaultWebXml());
            this.embedded.setDirectoryListing(config.getListings());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "web"));
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "weld"));
        Sniffer security = (Sniffer)this.habitat.getComponent(Sniffer.class, "Security");
        if (security != null) {
            sniffers.add(security);
        }
        return sniffers;
    }

    public Context createContext(File docRoot) {
        return this.createContext(docRoot, null);
    }

    public Context createContext(File docRoot, String contextRoot, ClassLoader classLoader) {
        Context context = this.createContext(docRoot, null);
        try {
            for (org.glassfish.embeddable.web.VirtualServer vs : this.getVirtualServers()) {
                vs.addContext(context, contextRoot);
            }
        }
        catch (Exception ex) {
            log.severe("Couldn't add context " + context + " using " + contextRoot);
            ex.printStackTrace();
        }
        return context;
    }

    public Context createContext(File docRoot, ClassLoader classLoader) {
        if (docRoot == null) {
            log.severe("Cannot create context with docRoot " + docRoot);
            return null;
        }
        if (!this.initialized) {
            this.init();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating context '" + docRoot.getName() + "' with docBase '" + docRoot.getPath() + "'");
        }
        WebModule context = null;
        try {
            Deployer deployer = (Deployer)this.habitat.getComponent(Deployer.class);
            String appName = deployer.deploy(docRoot, new String[]{"--name", docRoot.getName()});
            if (!appName.startsWith("/")) {
                appName = "/" + appName;
            }
            WebModule ctx = null;
            for (org.glassfish.embeddable.web.VirtualServer virtualServer : this.getVirtualServers()) {
                ctx = (WebModule)((StandardHost)virtualServer).findChild(appName);
                if (!log.isLoggable(Level.INFO)) continue;
                log.info("Virtual server " + virtualServer.getID() + " deployed " + ctx.getName());
            }
            org.glassfish.embeddable.web.VirtualServer vs = this.getVirtualServer(this.config.getVirtualServerId());
            context = (WebModule)((StandardHost)vs).findChild(appName);
            if (context != null) {
                if (classLoader != null) {
                    context.setParentClassLoader(classLoader);
                } else {
                    context.setParentClassLoader(this.serverContext.getSharedClassLoader());
                }
                context.setDefaultWebXml(this.config.getDefaultWebXml().getPath());
                ((StandardHost)vs).removeChild((org.apache.catalina.Container)context);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return context;
    }

    public void addContext(Context context, String contextRoot) throws ConfigException, GlassFishException {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        for (org.glassfish.embeddable.web.VirtualServer vs : this.getVirtualServers()) {
            if (vs.getContext(contextRoot) != null) {
                throw new ConfigException("Context with contextRoot " + contextRoot + " is already registered");
            }
            vs.addContext(context, contextRoot);
        }
    }

    public void removeContext(Context context) throws ConfigException, GlassFishException {
        String contextRoot = context.getPath();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        for (org.glassfish.embeddable.web.VirtualServer vs : this.getVirtualServers()) {
            if (vs.getContext(contextRoot) == null) continue;
            vs.removeContext(context);
            if (!log.isLoggable(Level.INFO)) continue;
            log.info("Removed context with path " + contextRoot + " from virtual server " + vs.getID());
        }
    }

    public <T extends WebListener> T createWebListener(String id, Class<T> c) throws InstantiationException, IllegalAccessException {
        WebListener webListener = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating connector " + id);
        }
        try {
            webListener = (WebListener)c.newInstance();
            webListener.setId(id);
        }
        catch (Exception e) {
            log.severe("Couldn't create connector " + e.getMessage());
        }
        return (T)webListener;
    }

    public void addWebListener(WebListener webListener) throws ConfigException, GlassFishException {
        if (!this.initialized) {
            this.init();
        }
        this.addWebListener(webListener, this.config.getVirtualServerId());
    }

    public WebListener getWebListener(String id) {
        if (!this.initialized) {
            this.init();
        }
        for (WebListener listener : this.listeners) {
            if (!listener.getId().equals(id)) continue;
            return listener;
        }
        return null;
    }

    private WebListener getWebListener(int port) {
        for (WebListener listener : this.listeners) {
            if (listener.getPort() != port) continue;
            return listener;
        }
        return null;
    }

    public Collection<WebListener> getWebListeners() {
        return this.listeners;
    }

    public void removeWebListener(WebListener webListener) throws GlassFishException {
        if (!this.listeners.contains(webListener)) {
            throw new GlassFishException((Throwable)new ConfigException("Connector with name '" + webListener.getId() + "' does not exsits"));
        }
        this.listeners.remove(webListener);
        this.removeListener(webListener.getId());
    }

    private VirtualServer createVS(String id, File f, WebListener ... webListeners) {
        if (!this.initialized) {
            this.init();
        }
        ArrayList<String> names = new ArrayList<String>();
        if (webListeners != null) {
            for (WebListener listener : webListeners) {
                names.add(listener.getId());
            }
        } else {
            for (NetworkListener networkListener : this.networkConfig.getNetworkListeners().getNetworkListener()) {
                names.add(networkListener.getName());
            }
            webListeners = this.listeners.toArray(new WebListener[this.listeners.size()]);
        }
        StringBuffer networkListeners = new StringBuffer("");
        if (names.size() > 0) {
            networkListeners.append((String)names.get(0));
        }
        for (int i = 1; i < names.size(); ++i) {
            networkListeners.append(",");
            networkListeners.append((String)names.get(i));
        }
        String docRoot = null;
        if (f != null) {
            docRoot = f.getPath();
        }
        final String root = docRoot;
        final String nl = networkListeners.toString();
        final String virtualServerId = id;
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    com.sun.enterprise.config.serverbeans.VirtualServer newVirtualServer = (com.sun.enterprise.config.serverbeans.VirtualServer)param.createChild(com.sun.enterprise.config.serverbeans.VirtualServer.class);
                    newVirtualServer.setId(virtualServerId);
                    newVirtualServer.setNetworkListeners(nl);
                    Property property = (Property)newVirtualServer.createChild(Property.class);
                    property.setName("docroot");
                    property.setValue(root);
                    newVirtualServer.getProperty().add(property);
                    param.getVirtualServer().add(newVirtualServer);
                    return newVirtualServer;
                }
            }, (ConfigBeanProxy)this.httpService);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        VirtualServer vs = (VirtualServer)this.engine.findChild(virtualServerId);
        if (vs != null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Created virtual server " + id + " docroot " + docRoot + " networklisteners " + nl);
            }
            vs.setNetworkListenerNames(names.toArray(new String[names.size()]));
            vs.setWebListeners(webListeners);
            this.engine.removeChild((org.apache.catalina.Container)vs);
        } else {
            log.severe("Cannot add virtual server " + virtualServerId);
        }
        return vs;
    }

    public org.glassfish.embeddable.web.VirtualServer createVirtualServer(String id, File docRoot, WebListener ... webListeners) {
        return this.createVS(id, docRoot, webListeners);
    }

    public org.glassfish.embeddable.web.VirtualServer createVirtualServer(String id, File docRoot) {
        return this.createVirtualServer(id, docRoot, null);
    }

    public void addVirtualServer(org.glassfish.embeddable.web.VirtualServer virtualServer) throws ConfigException, GlassFishException {
        VirtualServer vs;
        if (!this.initialized) {
            this.init();
        }
        if ((vs = (VirtualServer)this.engine.findChild(virtualServer.getID())) != null) {
            throw new ConfigException("VirtualServer with id " + virtualServer.getID() + " is already registered");
        }
        String id = virtualServer.getID();
        final String networkListeners = ((StandardHost)virtualServer).getNetworkListeners();
        final String docRoot = virtualServer.getDocRoot().getPath();
        String hostNames = "${com.sun.aas.hostName}";
        if (virtualServer.getConfig() != null) {
            hostNames = virtualServer.getConfig().getHostNames();
        }
        final String hosts = hostNames;
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = this.httpService.getVirtualServerByName(id);
        try {
            this.engine.addChild((org.apache.catalina.Container)((StandardHost)virtualServer));
            for (WebListener listener : virtualServer.getWebListeners()) {
                if (this.getWebListener(listener.getId()) != null) continue;
                this.addWebListener(listener, virtualServer.getID());
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<com.sun.enterprise.config.serverbeans.VirtualServer>(){

                public Object run(com.sun.enterprise.config.serverbeans.VirtualServer param) throws PropertyVetoException, TransactionFailure {
                    param.setHosts(hosts);
                    param.setNetworkListeners(networkListeners);
                    param.setDocroot(docRoot);
                    return null;
                }
            }, (ConfigBeanProxy)vsBean);
        }
        catch (Exception ex) {
            throw new GlassFishException((Throwable)ex);
        }
        vs = (VirtualServer)this.engine.findChild(id);
        if (vs != null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Added virtual server " + vs.getName() + " with networklisteners " + networkListeners);
            }
        } else {
            log.severe("Cannot add virtual server " + id);
            throw new GlassFishException((Throwable)new Exception("Cannot add virtual server " + id));
        }
    }

    public org.glassfish.embeddable.web.VirtualServer getVirtualServer(String id) {
        if (!this.initialized) {
            this.init();
        }
        return (org.glassfish.embeddable.web.VirtualServer)this.engine.findChild(id);
    }

    public Collection<org.glassfish.embeddable.web.VirtualServer> getVirtualServers() {
        if (!this.initialized) {
            this.init();
        }
        ArrayList<org.glassfish.embeddable.web.VirtualServer> virtualServers = new ArrayList<org.glassfish.embeddable.web.VirtualServer>();
        for (org.apache.catalina.Container child : this.engine.findChildren()) {
            if (!(child instanceof org.glassfish.embeddable.web.VirtualServer)) continue;
            virtualServers.add((org.glassfish.embeddable.web.VirtualServer)child);
        }
        return virtualServers;
    }

    public void removeVirtualServer(org.glassfish.embeddable.web.VirtualServer virtualServer) throws GlassFishException {
        if (!this.initialized) {
            this.init();
        }
        this.engine.removeChild((org.apache.catalina.Container)virtualServer);
    }

    public void setLogLevel(Level level) {
        log.setLevel(level);
    }
}

