/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ManagerProperties;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.v3.services.impl.MapperUpdateListener;
import com.sun.enterprise.web.WebContainer;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.util.http.mapper.Mapper;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

public class WebConfigListener
implements ConfigListener,
MapperUpdateListener {
    @Inject
    public HttpService httpService;
    @Inject(optional=true)
    public AccessLog accessLog;
    @Inject(optional=true)
    public ManagerProperties managerProperties;
    @Inject(optional=true)
    public List<Property> property;
    @Inject(name="accessLoggingEnabled", optional=true)
    public Property accessLoggingEnabledProperty;
    @Inject(name="docroot", optional=true)
    public Property docroot;
    private WebContainer container;
    private Logger logger;
    volatile boolean received = false;

    public void setContainer(WebContainer container) {
        this.container = container;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (WebConfigListener.this.logger.isLoggable(Level.FINE)) {
                    WebConfigListener.this.logger.fine("Web container config changed " + type + " " + tClass + " " + t);
                }
                try {
                    if (t instanceof NetworkListener) {
                        if (type == Changed.TYPE.ADD) {
                            WebConfigListener.this.container.addConnector((NetworkListener)t, WebConfigListener.this.httpService, true);
                        } else if (type == Changed.TYPE.REMOVE) {
                            WebConfigListener.this.container.deleteConnector((NetworkListener)t);
                        } else if (type == Changed.TYPE.CHANGE) {
                            WebConfigListener.this.container.updateConnector((NetworkListener)t, WebConfigListener.this.httpService);
                        }
                    } else if (t instanceof VirtualServer) {
                        if (type == Changed.TYPE.ADD) {
                            WebConfigListener.this.container.createHost((VirtualServer)t, WebConfigListener.this.httpService, null);
                            WebConfigListener.this.container.loadDefaultWebModule((VirtualServer)t);
                        } else if (type == Changed.TYPE.REMOVE) {
                            WebConfigListener.this.container.deleteHost(WebConfigListener.this.httpService);
                        } else if (type == Changed.TYPE.CHANGE) {
                            WebConfigListener.this.container.updateHost((VirtualServer)t);
                        }
                    } else if (t instanceof AccessLog) {
                        WebConfigListener.this.container.updateAccessLog(WebConfigListener.this.httpService);
                    } else {
                        if (t instanceof ManagerProperties) {
                            return new NotProcessed("ManagerProperties requires restart");
                        }
                        if (t instanceof WebContainerAvailability) {
                            WebConfigListener.this.container.updateHttpService(WebConfigListener.this.httpService);
                        } else if (!(t instanceof NetworkListeners)) {
                            WebConfigListener.this.container.updateHttpService(WebConfigListener.this.httpService);
                        }
                    }
                }
                catch (LifecycleException le) {
                    WebConfigListener.this.logger.log(Level.SEVERE, "webcontainer.exceptionConfigHttpService", le);
                }
                return null;
            }
        }, (Logger)this.logger);
    }

    public void update(HttpService httpService, NetworkListener httpListener, Mapper mapper) {
        this.container.updateMapper(httpService, httpListener, mapper);
    }
}

