/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.web.ha.session.management.BaseHASession;
import org.glassfish.web.ha.session.management.CompositeMetadata;
import org.glassfish.web.ha.session.management.HASession;
import org.glassfish.web.ha.session.management.ModifiedAttributeHASession;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;
import org.glassfish.web.ha.session.management.ReplicationStore;
import org.glassfish.web.ha.session.management.SessionAttributeMetadata;

public class ReplicationAttributeStore
extends ReplicationStore {
    private static final Logger _logger = LogDomains.getLogger(ReplicationAttributeStore.class, (String)"javax.enterprise.system.container.web");

    public ReplicationAttributeStore(ServerConfigLookup serverConfigLookup, JavaEEIOUtils ioUtils) {
        super(serverConfigLookup, ioUtils);
        this.setLogLevel();
    }

    public void valveSave(Session session) throws IOException {
        HASession haSess = (HASession)session;
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doValveSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    public void save(Session session) throws IOException {
        HASession haSess = (HASession)session;
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    public void doValveSave(Session session) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>doValveSave:valid =" + ((StandardSession)session).getIsValid());
            _logger.fine("ReplicationAttributeStore>>valveSave:ssoId=" + ((HASession)session).getSsoId());
        }
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        ModifiedAttributeHASession modAttrSession = (ModifiedAttributeHASession)session;
        String userName = "";
        if (session.getPrincipal() != null) {
            userName = session.getPrincipal().getName();
            ((BaseHASession)session).setUserName(userName);
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>save: replicator: " + replicator);
        }
        CompositeMetadata compositeMetadata = this.createCompositeMetadata(modAttrSession);
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("CompositeMetadata is " + compositeMetadata + " id is " + session.getIdInternal());
            }
            replicator.save((Serializable)((Object)session.getIdInternal()), (Serializable)((Object)compositeMetadata), !((HASession)session).isPersistent());
            modAttrSession.resetAttributeState();
            this.postSaveUpdate(modAttrSession);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public void doSave(Session session) throws IOException {
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        ModifiedAttributeHASession modAttrSession = (ModifiedAttributeHASession)session;
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>doSave: replicator: " + replicator);
        }
        CompositeMetadata compositeMetadata = this.createCompositeMetadata(modAttrSession);
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("CompositeMetadata is " + compositeMetadata + " id is " + session.getIdInternal());
            }
            replicator.save((Serializable)((Object)session.getIdInternal()), (Serializable)((Object)compositeMetadata), !((HASession)session).isPersistent());
            modAttrSession.resetAttributeState();
            this.postSaveUpdate(modAttrSession);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    private BackingStore getCompositeBackingStore() {
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore backingStore = mgr.getBackingStore();
        return backingStore;
    }

    public Session load(String id) throws ClassNotFoundException, IOException {
        return this.load(id, null);
    }

    public Session load(String id, String version) throws ClassNotFoundException, IOException {
        try {
            CompositeMetadata metaData = (CompositeMetadata)((Object)this.getCompositeBackingStore().load((Serializable)((Object)id), version));
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationAttributeStore>>load:id=" + id + ", metaData=" + metaData);
            }
            Session session = this.getSession(metaData);
            this.validateAndSave(session);
            return session;
        }
        catch (BackingStoreException ex) {
            IOException ex1 = (IOException)new IOException("Error during load: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    private void validateAndSave(Session session) throws IOException {
        if (session != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationAttributeStore>>validateAndSave saving the session after loading it. Session=" + session);
            }
            ((HASession)session).setDirty(true);
            this.valveSave(session);
        }
        if (session != null) {
            ((HASession)session).setDirty(false);
            ((HASession)session).setPersistent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(CompositeMetadata metadata) throws IOException {
        long version;
        String ssoId;
        Principal pal;
        Container container;
        Session _session;
        block26: {
            if (metadata == null || metadata.getState() == null) {
                return null;
            }
            byte[] state = metadata.getState();
            _session = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            container = this.manager.getContainer();
            pal = null;
            ssoId = null;
            version = 0L;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                ssoId = metadata.getStringExtraParam();
                version = metadata.getVersion();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("loaded session from replicationstore, length = " + state.length);
                }
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null) {
                    try {
                        ois = this.ioUtils.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block26;
                try {
                    _session = this.readSession(this.manager, ois);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                IOException ex1 = (IOException)new IOException("Error during deserialization: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (IOException e) {
                throw e;
            }
        }
        String username = ((HASession)_session).getUserName();
        if (username != null && !username.equals("") && _session.getPrincipal() == null) {
            if (this._debug > 0) {
                this.debug("Username retrieved is " + username);
            }
            pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
            if (this._debug > 0) {
                this.debug("principal created using username  " + pal);
            }
            if (pal != null) {
                _session.setPrincipal(pal);
                if (this._debug > 0) {
                    this.debug("getSession principal=" + pal + " was added to session=" + _session);
                }
            }
        }
        _session.setNew(false);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>ssoId=" + ssoId);
        }
        ((HASession)_session).setVersion(version);
        ((HASession)_session).setDirty(false);
        ((ModifiedAttributeHASession)_session).clearAttributeStates();
        byte[] entriesState = metadata.getState();
        Collection entries = null;
        if (entriesState != null) {
            entries = this.deserializeStatesCollection(entriesState);
            this.loadAttributes((ModifiedAttributeHASession)_session, entries);
        }
        this.loadAttributes((ModifiedAttributeHASession)_session, metadata.getEntries());
        return _session;
    }

    private void postSaveUpdate(ModifiedAttributeHASession modAttrSession) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>postSaveUpdate");
        }
        ArrayList addedAttrs = modAttrSession.getAddedAttributes();
        ArrayList modifiedAttrs = modAttrSession.getModifiedAttributes();
        ArrayList deletedAttrs = modAttrSession.getDeletedAttributes();
        this.printAttrList("ADDED", addedAttrs);
        this.printAttrList("MODIFIED", modifiedAttrs);
        this.printAttrList("DELETED", deletedAttrs);
        this.postProcessSetAttrStates(modAttrSession, addedAttrs);
        this.postProcessSetAttrStates(modAttrSession, modifiedAttrs);
    }

    private void postProcessSetAttrStates(ModifiedAttributeHASession modAttrSession, ArrayList attrsList) {
        for (int i = 0; i < attrsList.size(); ++i) {
            String nextStateName = (String)attrsList.get(i);
            modAttrSession.setAttributeStatePersistent(nextStateName, true);
            modAttrSession.setAttributeStateDirty(nextStateName, false);
        }
    }

    private CompositeMetadata createCompositeMetadata(ModifiedAttributeHASession modAttrSession) {
        byte[] trunkState = null;
        if (modAttrSession.isNew()) {
            try {
                trunkState = this.getByteArray(modAttrSession);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>createCompositeMetadata:trunkState=" + trunkState);
        }
        ArrayList entries = new ArrayList();
        ArrayList addedAttrs = modAttrSession.getAddedAttributes();
        ArrayList modifiedAttrs = modAttrSession.getModifiedAttributes();
        ArrayList deletedAttrs = modAttrSession.getDeletedAttributes();
        this.printAttrList("ADDED", addedAttrs);
        this.printAttrList("MODIFIED", modifiedAttrs);
        this.printAttrList("DELETED", deletedAttrs);
        this.addToEntries(modAttrSession, entries, SessionAttributeMetadata.Operation.ADD, addedAttrs);
        this.addToEntries(modAttrSession, entries, SessionAttributeMetadata.Operation.UPDATE, modifiedAttrs);
        entries = this.addToEntries(modAttrSession, entries, SessionAttributeMetadata.Operation.DELETE, deletedAttrs);
        CompositeMetadata result = new CompositeMetadata(modAttrSession.getVersion(), modAttrSession.getLastAccessedTimeInternal(), modAttrSession.getMaxInactiveInterval(), entries, trunkState, null);
        return result;
    }

    private void printAttrList(String attrListType, ArrayList attrList) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("AttributeType = " + attrListType);
            String nextAttrName = null;
            for (int i = 0; i < attrList.size(); ++i) {
                nextAttrName = (String)attrList.get(i);
                _logger.fine("attribute[" + i + "]=" + nextAttrName);
            }
        }
    }

    private ArrayList addToEntries(ModifiedAttributeHASession modAttrSession, ArrayList entries, SessionAttributeMetadata.Operation op, ArrayList attrList) {
        String nextAttrName = null;
        Object nextAttrValue = null;
        byte[] nextValue = null;
        for (int i = 0; i < attrList.size(); ++i) {
            nextAttrName = (String)attrList.get(i);
            nextAttrValue = modAttrSession.getAttribute(nextAttrName);
            nextValue = null;
            try {
                nextValue = this.getByteArray(nextAttrValue);
            }
            catch (IOException ex) {
                // empty catch block
            }
            SessionAttributeMetadata nextAttrMetadata = new SessionAttributeMetadata(nextAttrName, op, nextValue);
            entries.add(nextAttrMetadata);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(Object attributeValue) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            try {
                oos = this.ioUtils.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            oos.writeObject(attributeValue);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAttributeValue(byte[] state) throws IOException, ClassNotFoundException {
        Object attributeValue;
        block18: {
            attributeValue = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null) {
                    try {
                        ois = this.ioUtils.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block18;
                try {
                    attributeValue = ois.readObject();
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "ClassNotFoundException occurred in getAttributeValue", e);
                }
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return attributeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArrayFromCollection(Collection entries) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            try {
                oos = this.ioUtils.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            int entriesSize = entries.size();
            oos.writeObject(entriesSize);
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                oos.writeObject(it.next());
            }
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAttributeValueCollection(byte[] state) throws IOException, ClassNotFoundException {
        ArrayList<Object> attributeValueList;
        block20: {
            attributeValueList = new ArrayList<Object>();
            Object attributeValue = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null) {
                    try {
                        ois = this.ioUtils.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block20;
                try {
                    Object whatIsIt = ois.readObject();
                    int entriesSize = 0;
                    if (whatIsIt instanceof Integer) {
                        entriesSize = (Integer)whatIsIt;
                    }
                    for (int i = 0; i < entriesSize; ++i) {
                        Object nextAttributeValue = ois.readObject();
                        attributeValueList.add(nextAttributeValue);
                    }
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "ClassNotFoundException occurred in getAttributeValueCollection", e);
                }
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return attributeValueList;
    }

    protected void loadAttributes(ModifiedAttributeHASession modifiedAttributeSession, Collection attributeList) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in loadAttributes -- ReplicationAttributeStore : session id=" + modifiedAttributeSession.getIdInternal());
        }
        String thisAttrName = null;
        SessionAttributeMetadata.Operation thisAttrOp = null;
        Object thisAttrVal = null;
        for (SessionAttributeMetadata nextAttrMetadata : attributeList) {
            thisAttrName = nextAttrMetadata.getAttributeName();
            thisAttrOp = nextAttrMetadata.getOperation();
            byte[] nextAttrState = nextAttrMetadata.getState();
            thisAttrVal = null;
            try {
                thisAttrVal = this.getAttributeValue(nextAttrState);
            }
            catch (ClassNotFoundException ex1) {
            }
            catch (IOException ex2) {
                // empty catch block
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Attr retrieved======" + thisAttrName);
            }
            if (thisAttrVal == null) continue;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Setting Attribute: " + thisAttrName);
            }
            modifiedAttributeSession.setAttribute(thisAttrName, thisAttrVal);
            modifiedAttributeSession.setAttributeStatePersistent(thisAttrName, false);
            modifiedAttributeSession.setAttributeStateDirty(thisAttrName, false);
        }
    }

    private byte[] serializeStatesCollection(Collection entries) {
        byte[] result = null;
        try {
            result = this.getByteArrayFromCollection(entries);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private byte[] serializeStatesCollectionPrevious(Collection entries) {
        byte[] result = null;
        try {
            result = this.getByteArray(entries);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private Collection deserializeStatesCollection(byte[] entriesState) {
        Collection result = new ArrayList();
        try {
            result = (Collection)this.getAttributeValueCollection(entriesState);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private Collection deserializeStatesCollectionPrevious(byte[] entriesState) {
        Collection result = new ArrayList();
        try {
            result = (Collection)this.getAttributeValue(entriesState);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

