/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ProcessEnvironment {
    private static Logger log = Logger.getLogger(ProcessEnvironment.class.getName());
    private ServletContext context = null;
    private String webAppRootDir = null;
    private String contextPath = null;
    protected String pathInfo = null;
    private String servletPath = null;
    protected Hashtable env = null;
    protected String command = null;
    protected boolean valid = false;
    protected int debug = 0;
    protected File workingDirectory = null;

    public ProcessEnvironment(HttpServletRequest req, ServletContext context) {
        this(req, context, 0);
    }

    public ProcessEnvironment(HttpServletRequest req, ServletContext context, int debug) {
        this.debug = debug;
        this.setupFromContext(context);
        this.setupFromRequest(req);
        this.valid = this.deriveProcessEnvironment(req);
        this.log(this.getClass().getName() + "() ctor, debug level " + debug);
    }

    protected void setupFromContext(ServletContext context) {
        this.context = context;
        this.webAppRootDir = context.getRealPath("/");
    }

    protected void setupFromRequest(HttpServletRequest req) {
        this.contextPath = req.getContextPath();
        this.pathInfo = req.getPathInfo();
        this.servletPath = req.getServletPath();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<TABLE border=2>");
        sb.append("<tr><th colspan=2 bgcolor=grey>");
        sb.append("ProcessEnvironment Info</th></tr>");
        sb.append("<tr><td>Debug Level</td><td>");
        sb.append(this.debug);
        sb.append("</td></tr>");
        sb.append("<tr><td>Validity:</td><td>");
        sb.append(this.isValid());
        sb.append("</td></tr>");
        if (this.isValid()) {
            Enumeration envk = this.env.keys();
            while (envk.hasMoreElements()) {
                String s = (String)envk.nextElement();
                sb.append("<tr><td>");
                sb.append(s);
                sb.append("</td><td>");
                sb.append(this.blanksToString((String)this.env.get(s), "[will be set to blank]"));
                sb.append("</td></tr>");
            }
        }
        sb.append("<tr><td colspan=2><HR></td></tr>");
        sb.append("<tr><td>Derived Command</td><td>");
        sb.append(this.nullsToBlanks(this.command));
        sb.append("</td></tr>");
        sb.append("<tr><td>Working Directory</td><td>");
        if (this.workingDirectory != null) {
            sb.append(this.workingDirectory.toString());
        }
        sb.append("</td></tr>");
        sb.append("</TABLE><p>end.");
        return sb.toString();
    }

    public String getCommand() {
        return this.command;
    }

    protected String setCommand(String command) {
        return command;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Hashtable getEnvironment() {
        return this.env;
    }

    public Hashtable setEnvironment(Hashtable env) {
        this.env = env;
        return this.env;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected String nullsToBlanks(String s) {
        return this.nullsToString(s, "");
    }

    protected String nullsToString(String couldBeNull, String subForNulls) {
        return couldBeNull == null ? subForNulls : couldBeNull;
    }

    protected String blanksToString(String couldBeBlank, String subForBlanks) {
        return "".equals(couldBeBlank) || couldBeBlank == null ? subForBlanks : couldBeBlank;
    }

    protected void log(String s) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(s);
        }
    }

    protected boolean deriveProcessEnvironment(HttpServletRequest req) {
        Hashtable<String, String> envp = new Hashtable<String, String>();
        this.command = this.getCommand();
        if (this.command != null) {
            this.workingDirectory = new File(this.command.substring(0, this.command.lastIndexOf(File.separator)));
            envp.put("X_TOMCAT_COMMAND_PATH", this.command);
        }
        this.env = envp;
        return true;
    }

    public String getWebAppRootDir() {
        return this.webAppRootDir;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public String getServletPath() {
        return this.servletPath;
    }
}

