/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import com.sun.enterprise.util.logging.IASLevel;
import com.sun.enterprise.web.logger.LoggerBase;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CatalinaLogger
extends LoggerBase {
    private Logger logger = null;

    public CatalinaLogger(Logger logger) {
        this.logger = logger;
    }

    protected void write(String msg, int verbosity) {
        if (this.logger == null) {
            return;
        }
        Level level = Level.INFO;
        if (verbosity == Integer.MIN_VALUE) {
            level = IASLevel.FATAL;
        } else if (verbosity == 1) {
            level = Level.SEVERE;
        } else if (verbosity == 2) {
            level = Level.WARNING;
        } else if (verbosity == 3) {
            level = Level.INFO;
        } else if (verbosity == 4) {
            level = Level.FINER;
        }
        this.logger.log(level, msg);
    }

    public void setLevel(String logLevel) {
        if ("SEVERE".equalsIgnoreCase(logLevel)) {
            this.logger.setLevel(Level.SEVERE);
        } else if ("WARNING".equalsIgnoreCase(logLevel)) {
            this.logger.setLevel(Level.WARNING);
        } else if ("INFO".equalsIgnoreCase(logLevel)) {
            this.logger.setLevel(Level.INFO);
        } else if ("CONFIG".equalsIgnoreCase(logLevel)) {
            this.logger.setLevel(Level.CONFIG);
        } else if ("FINE".equalsIgnoreCase(logLevel)) {
            this.logger.setLevel(Level.FINE);
        } else if ("FINER".equalsIgnoreCase(logLevel)) {
            this.logger.setLevel(Level.FINER);
        } else if ("FINEST".equalsIgnoreCase(logLevel)) {
            this.logger.setLevel(Level.FINEST);
        } else {
            this.logger.setLevel(Level.INFO);
        }
    }
}

