/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-network-listener")
@Scoped(value=PerLookup.class)
@I18n(value="delete.network.listener")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteNetworkListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteNetworkListener.class);
    @Param(name="networkListenerName", primary=true)
    String networkListenerName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    NetworkListener listenerToBeRemoved = null;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkListeners networkListeners = this.config.getNetworkConfig().getNetworkListeners();
        try {
            if (this.findListener(networkListeners, report)) {
                Protocol httpProtocol = this.listenerToBeRemoved.findHttpProtocol();
                VirtualServer virtualServer = this.config.getHttpService().getVirtualServerByName(httpProtocol.getHttp().getDefaultVirtualServer());
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... params) throws PropertyVetoException {
                        NetworkListeners listeners = (NetworkListeners)params[0];
                        VirtualServer server = (VirtualServer)params[1];
                        listeners.getNetworkListener().remove(DeleteNetworkListener.this.listenerToBeRemoved);
                        server.removeNetworkListener(DeleteNetworkListener.this.listenerToBeRemoved.getName());
                        return DeleteNetworkListener.this.listenerToBeRemoved;
                    }
                }, (ConfigBeanProxy[])new ConfigBeanProxy[]{networkListeners, virtualServer});
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.networkListener.fail", "Deletion of NetworkListener {0} failed", new Object[]{this.networkListenerName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean findListener(NetworkListeners networkListeners, ActionReport report) {
        for (NetworkListener listener : networkListeners.getNetworkListener()) {
            if (!listener.getName().equals(this.networkListenerName)) continue;
            this.listenerToBeRemoved = listener;
        }
        if (this.listenerToBeRemoved == null) {
            report.setMessage(localStrings.getLocalString("delete.network.listener.notexists", "{0} Network Listener doesn't exist", new Object[]{this.networkListenerName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

