/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import org.apache.catalina.Host;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.modeler.Registry;

public class MapperListener
implements NotificationListener,
NotificationFilter {
    private static Logger log = Logger.getLogger(MapperListener.class.getName());
    protected transient Mapper mapper = null;
    protected transient MBeanServer mBeanServer = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    private String domain = "*";
    private String engine = "*";
    private String networkListenerName;
    private String defaultHost;
    private ConcurrentHashMap<ObjectName, String[]> virtualServerListenerNames;
    private String myInstance;

    public MapperListener(Mapper mapper) {
        this.mapper = mapper;
        this.virtualServerListenerNames = new ConcurrentHashMap();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getNetworkListenerName() {
        return this.networkListenerName;
    }

    public void setNetworkListenerName(String networkListenerName) {
        this.networkListenerName = networkListenerName;
    }

    public void setInstanceName(String instanceName) {
        this.myInstance = instanceName;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    public void init() {
        if (this.defaultHost != null) {
            this.mapper.setDefaultHostName(this.defaultHost);
        }
        try {
            this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            String onStr = this.domain + ":type=Host,*";
            ObjectName objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerHost(oi.getObjectName());
            }
            onStr = this.domain + ":j2eeType=WebModule,*,J2EEServer=" + this.myInstance;
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerContext(oi.getObjectName());
            }
            onStr = this.domain + ":j2eeType=Servlet,*,J2EEServer=" + this.myInstance;
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerWrapper(oi.getObjectName());
            }
            onStr = "JMImplementation:type=MBeanServerDelegate";
            objectName = new ObjectName(onStr);
            this.mBeanServer.addNotificationListener(objectName, this, (NotificationFilter)this, null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error registering contexts", e);
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            String otherDomain = objectName.getDomain();
            if (this.domain != null && !this.domain.equals(otherDomain)) {
                return false;
            }
            String otherInstance = objectName.getKeyProperty("J2EEServer");
            if (this.myInstance != null && otherInstance != null && !otherInstance.equals(this.myInstance)) {
                return false;
            }
        }
        return true;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            String type;
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            String j2eeType = objectName.getKeyProperty("j2eeType");
            String engineName = null;
            if (j2eeType != null && (j2eeType.equals("WebModule") || j2eeType.equals("Servlet")) && this.mBeanServer.isRegistered(objectName)) {
                MBeanInfo info = null;
                try {
                    info = this.mBeanServer.getMBeanInfo(objectName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (info != null) {
                    boolean hasEngineNameAttribute = false;
                    MBeanAttributeInfo[] attrInfo = info.getAttributes();
                    if (attrInfo != null) {
                        for (int i = 0; i < attrInfo.length; ++i) {
                            if (!"engineName".equals(attrInfo[i].getName())) continue;
                            hasEngineNameAttribute = true;
                            break;
                        }
                    }
                    if (hasEngineNameAttribute) {
                        try {
                            engineName = (String)this.mBeanServer.getAttribute(objectName, "engineName");
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!("*".equals(this.domain) || this.domain.equals(objectName.getDomain()) || this.domain.equals(engineName) || engineName == null)) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Handle " + objectName);
            }
            if (notification.getType().equals("JMX.mbean.registered")) {
                type = objectName.getKeyProperty("type");
                if ("Host".equals(type)) {
                    try {
                        this.registerHost(objectName);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error registering Host " + objectName, e);
                    }
                }
                if (j2eeType != null) {
                    if (j2eeType.equals("WebModule")) {
                        try {
                            this.registerContext(objectName);
                        }
                        catch (Throwable t) {
                            log.log(Level.WARNING, "Error registering Context " + objectName, t);
                        }
                    } else if (j2eeType.equals("Servlet")) {
                        try {
                            this.registerWrapper(objectName);
                        }
                        catch (Throwable t) {
                            log.log(Level.WARNING, "Error registering Wrapper " + objectName, t);
                        }
                    }
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                type = objectName.getKeyProperty("type");
                if ("Host".equals(type)) {
                    try {
                        this.unregisterHost(objectName);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error unregistering Host " + objectName, e);
                    }
                }
                if (j2eeType != null) {
                    if (j2eeType.equals("WebModule")) {
                        try {
                            this.unregisterContext(objectName);
                        }
                        catch (Throwable t) {
                            log.log(Level.WARNING, "Error unregistering webapp " + objectName, t);
                        }
                    } else if (Boolean.parseBoolean(objectName.getKeyProperty("osgi")) && j2eeType.equals("Servlet")) {
                        try {
                            this.unregisterOSGiWrapper(objectName);
                        }
                        catch (Throwable t) {
                            log.log(Level.WARNING, "Error unregistering osgi wrapper " + objectName, t);
                        }
                    }
                }
            }
        }
    }

    public void registerHost(ObjectName objectName) throws Exception {
        String name = objectName.getKeyProperty("host");
        if (name != null) {
            Host host = (Host)this.mBeanServer.invoke(objectName, "findMappingObject", null, null);
            if (host == null) {
                throw new Exception("No host registered for " + objectName);
            }
            String[] nlNames = ((StandardHost)host).getNetworkListenerNames();
            boolean nameMatch = false;
            if (nlNames != null) {
                for (String nlName : nlNames) {
                    if (!nlName.equals(this.networkListenerName)) continue;
                    nameMatch = true;
                    break;
                }
            }
            if (!nameMatch) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("HTTP listener with network listener name " + this.networkListenerName + " ignoring registration of host with object " + "name " + objectName + ", because none of the " + "host's associated HTTP listeners matches " + "this network listener name");
                }
                return;
            }
            this.virtualServerListenerNames.put(objectName, nlNames);
            String[] aliases = host.findAliases();
            this.mapper.addHost(name, aliases, (Object)host);
        }
    }

    public void unregisterHost(ObjectName objectName) throws Exception {
        String name = objectName.getKeyProperty("host");
        if (name != null) {
            String[] nlNames = this.virtualServerListenerNames.get(objectName);
            boolean nameMatch = false;
            if (nlNames != null) {
                this.virtualServerListenerNames.remove(objectName);
                for (String nlName : nlNames) {
                    if (!nlName.equals(this.networkListenerName)) continue;
                    nameMatch = true;
                    break;
                }
            }
            if (!nameMatch) {
                return;
            }
        }
        this.mapper.removeHost(name);
    }

    private void registerContext(ObjectName objectName) throws Exception {
        int slash;
        StandardContext context = (StandardContext)this.mBeanServer.invoke(objectName, "findMappingObject", null, null);
        if (context == null) {
            throw new Exception("No context registered for " + objectName);
        }
        String name = objectName.getKeyProperty("name");
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain) && !this.domain.equals(targetDomain = context.getEngineName())) {
            return;
        }
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        contextName = RequestUtil.urlDecode(contextName, "UTF-8");
        if (contextName.equals("/")) {
            contextName = "";
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(sm.getString("mapperListener.registerContext", contextName));
        }
        DirContext resources = context.findStaticResources();
        String[] welcomeFiles = context.getWelcomeFiles();
        this.mapper.addContext(hostName, contextName, (Object)context, welcomeFiles, (Context)resources, context.getAlternateDocBases());
    }

    private void unregisterContext(ObjectName objectName) throws Exception {
        int slash;
        String name = objectName.getKeyProperty("name");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        contextName = RequestUtil.urlDecode(contextName, "UTF-8");
        if (contextName.equals("/")) {
            contextName = "";
        }
        MessageBytes hostMB = MessageBytes.newInstance();
        hostMB.setString(hostName);
        MessageBytes contextMB = MessageBytes.newInstance();
        contextMB.setString(contextName);
        MappingData mappingData = new MappingData();
        this.mapper.map(hostMB, contextMB, mappingData);
        if (mappingData.context instanceof StandardContext && ((StandardContext)mappingData.context).getPaused()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(sm.getString("mapperListener.unregisterContext", contextName));
        }
        this.mapper.removeContext(hostName, contextName);
    }

    private void registerWrapper(ObjectName objectName) throws Exception {
        int slash;
        StandardWrapper wrapper = (StandardWrapper)this.mBeanServer.invoke(objectName, "findMappingObject", null, null);
        if (wrapper == null) {
            throw new Exception("No wrapper registered for " + objectName);
        }
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain) && !this.domain.equals(targetDomain = wrapper.getEngineName())) {
            return;
        }
        String wrapperName = objectName.getKeyProperty("name");
        String name = objectName.getKeyProperty("WebModule");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        contextName = RequestUtil.urlDecode(contextName, "UTF-8");
        if (contextName.equals("/")) {
            contextName = "";
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(sm.getString("mapperListener.registerWrapper", (Object)wrapperName, contextName));
        }
        String[] mappings = wrapper.findMappings();
        for (int i = 0; i < mappings.length; ++i) {
            boolean jspWildCard = wrapperName.equals("jsp") && mappings[i].endsWith("/*");
            this.mapper.addWrapper(hostName, contextName, mappings[i], (Object)wrapper, jspWildCard, wrapperName, true);
        }
    }

    private void unregisterOSGiWrapper(ObjectName objectName) throws Exception {
        String mapping;
        int slash;
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain)) {
            return;
        }
        String name = objectName.getKeyProperty("WebModule");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        contextName = RequestUtil.urlDecode(contextName, "UTF-8");
        if (contextName.equals("/")) {
            contextName = "";
        }
        mapping = "/".equals(mapping = objectName.getKeyProperty("name")) ? "/*" : mapping + "/*";
        this.mapper.removeWrapper(hostName, contextName, mapping);
    }
}

