/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.util.Enumeration;
import java.util.logging.Level;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.UserDatabase;
import org.apache.catalina.util.StringManager;

public final class UserConfig
implements LifecycleListener {
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(UserConfig.class.getName());
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private String configClass = ContextConfig.class.getName();
    private String contextClass = StandardContext.class.getName();
    private int debug = 999;
    private String directoryName = "public_html";
    private String homeBase = null;
    private Host host = null;
    private String userClass = "org.apache.catalina.startup.PasswdUserDatabase";

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getHomeBase() {
        return this.homeBase;
    }

    public void setHomeBase(String homeBase) {
        this.homeBase = homeBase;
    }

    public String getUserClass() {
        return this.userClass;
    }

    public void setUserClass(String userClass) {
        this.userClass = userClass;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            this.log(sm.getString("hostConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void deploy() {
        if (this.debug >= 1) {
            this.log(sm.getString("userConfig.deploying"));
        }
        UserDatabase database = null;
        try {
            Class<?> clazz = Class.forName(this.userClass);
            database = (UserDatabase)clazz.newInstance();
            database.setUserConfig(this);
        }
        catch (Exception e) {
            this.log(sm.getString("userConfig.database"), e);
            return;
        }
        Enumeration users = database.getUsers();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            String home = database.getHome(user);
            this.deploy(user, home);
        }
    }

    private void deploy(String user, String home) {
        String contextPath = "/~" + user;
        if (this.host.findChild(contextPath) != null) {
            return;
        }
        File app = new File(home, this.directoryName);
        if (!app.exists() || !app.isDirectory()) {
            return;
        }
        this.log(sm.getString("userConfig.deploy", user));
        try {
            Class<?> clazz = Class.forName(this.contextClass);
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(app.toString());
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.configClass);
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.host.addChild(context);
        }
        catch (Exception e) {
            this.log(sm.getString("userConfig.error", user), e);
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
            if (logger != null) {
                logger.log("UserConfig[" + this.host.getName() + "]: " + message);
            } else if (log.isLoggable(Level.INFO)) {
                log.info("UserConfig[" + this.host.getName() + "]: " + message);
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.info("UserConfig[null]: " + message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
            if (logger != null) {
                logger.log("UserConfig[" + this.host.getName() + "] " + message, t, 2);
            } else {
                log.log(Level.WARNING, "UserConfig[" + this.host.getName() + "]: " + message, t);
            }
        } else {
            log.log(Level.WARNING, "UserConfig[null]: " + message, t);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(sm.getString("userConfig.start"));
        }
        this.deploy();
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(sm.getString("userConfig.stop"));
        }
    }
}

