/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;

public class FormAuthenticator
extends AuthenticatorBase {
    private static Logger log = Logger.getLogger(FormAuthenticator.class.getName());
    protected static final String info = "org.apache.catalina.authenticator.FormAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        char[] password;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        Session session = null;
        String contextPath = hreq.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        boolean loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        Principal principal = hreq.getUserPrincipal();
        if (principal != null && !loginAction) {
            String ssoId;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Already authenticated '" + principal.getName() + "'");
            }
            if ((ssoId = (String)request.getNote("org.apache.catalina.request.SSOID")) != null) {
                this.getSession(request, true);
            }
            return true;
        }
        if (!this.cache && !loginAction) {
            session = this.getSession(request, true);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Checking for reauthenticate in session " + session);
            }
            String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            char[] password2 = (char[])session.getNote("org.apache.catalina.session.PASSWORD");
            if (username != null && password2 != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Reauthenticating username '" + username + "'");
                }
                if ((principal = this.context.getRealm().authenticate(username, password2)) != null) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
                    if (!this.matchRequest(request)) {
                        this.register(request, response, principal, "FORM", username, password2);
                        return true;
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(request)) {
            session = this.getSession(request, true);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Restore request from session '" + session.getIdInternal() + "'");
            }
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.register(request, response, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (char[])session.getNote("org.apache.catalina.session.PASSWORD"));
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null) {
                this.associate(ssoId, session);
            }
            if (this.restoreRequest(request, session)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Proceed to restored request");
                }
                return true;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Restore of original request failed");
            }
            hres.sendError(400);
            return false;
        }
        MessageBytes uriMB = MessageBytes.newInstance();
        CharChunk uriCC = uriMB.getCharChunk();
        uriCC.setLimit(-1);
        response.setContext(request.getContext());
        if (!loginAction) {
            session = this.getSession(request, true);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Save request in session '" + session.getIdInternal() + "'");
            }
            this.saveRequest(request, session);
            this.forwardToLoginPage(request, response, config);
            return false;
        }
        Realm realm = this.context.getRealm();
        String username = hreq.getParameter("j_username");
        String pwd = hreq.getParameter("j_password");
        char[] cArray = password = pwd != null ? pwd.toCharArray() : null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Authenticating username '" + username + "'");
        }
        if ((principal = realm.authenticate(username, password)) == null) {
            this.forwardToErrorPage(request, response, config);
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Authentication of '" + username + "' was successful");
        }
        if (session == null) {
            session = this.getSession(request, true);
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        if (!this.cache) {
            session.setNote("org.apache.catalina.session.USERNAME", username);
            session.setNote("org.apache.catalina.session.PASSWORD", password);
        }
        if ((requestURI = this.savedRequestURL(session)) == null) {
            requestURI = hreq.getContextPath() + "/";
            this.register(request, response, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (char[])session.getNote("org.apache.catalina.session.PASSWORD"));
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null) {
                this.associate(ssoId, session);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Redirecting to original '" + requestURI + "'");
        }
        hres.sendRedirect(hres.encodeRedirectURL(requestURI));
        return false;
    }

    protected boolean matchRequest(HttpRequest request) {
        Session session = this.getSession(request, false);
        if (session == null) {
            return false;
        }
        SavedRequest sreq = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (sreq == null) {
            return false;
        }
        if (session.getNote("org.apache.catalina.authenticator.PRINCIPAL") == null) {
            return false;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String requestURI = hreq.getRequestURI();
        if (requestURI == null) {
            return false;
        }
        return requestURI.equals(sreq.getRequestURI());
    }

    protected boolean restoreRequest(HttpRequest request, Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
        if (saved == null) {
            return false;
        }
        request.clearCookies();
        Iterator<Cookie> cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie(cookies.next());
        }
        request.clearHeaders();
        Iterator<String> names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = names.next();
            Iterator<String> values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                request.addHeader(name, values.next());
            }
        }
        request.clearLocales();
        Iterator<Locale> locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale(locales.next());
        }
        request.clearParameters();
        if ("POST".equalsIgnoreCase(saved.getMethod())) {
            Iterator<String> paramNames = saved.getParameterNames();
            while (paramNames.hasNext()) {
                String paramName = paramNames.next();
                String[] paramValues = saved.getParameterValues(paramName);
                request.addParameter(paramName, paramValues);
            }
        }
        request.setMethod(saved.getMethod());
        request.setQueryString(saved.getQueryString());
        request.setRequestURI(saved.getRequestURI());
        return true;
    }

    protected void forwardToLoginPage(HttpRequest request, HttpResponse response, LoginConfig config) {
        ServletContext sc = this.context.getServletContext();
        try {
            SecurityConstraint[] secConstraints;
            Realm realm;
            String loginPage = config.getLoginPage();
            if (!request.getRequest().isSecure() && (realm = this.context.getRealm()) != null && (secConstraints = realm.findSecurityConstraints(loginPage, "GET", this.context)) != null && !realm.hasUserDataPermission(request, response, secConstraints, loginPage, "GET")) {
                return;
            }
            RequestDispatcher disp = sc.getRequestDispatcher(loginPage);
            disp.forward(request.getRequest(), response.getResponse());
            response.finishResponse();
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Unexpected error forwarding or redirecting to login page", t);
        }
    }

    protected void forwardToErrorPage(HttpRequest request, HttpResponse response, LoginConfig config) {
        ServletContext sc = this.context.getServletContext();
        try {
            SecurityConstraint[] secConstraints;
            Realm realm;
            String errorPage = config.getErrorPage();
            if (!request.getRequest().isSecure() && (realm = this.context.getRealm()) != null && (secConstraints = realm.findSecurityConstraints(errorPage, "GET", this.context)) != null && !realm.hasUserDataPermission(request, response, secConstraints, errorPage, "GET")) {
                return;
            }
            RequestDispatcher disp = sc.getRequestDispatcher(errorPage);
            disp.forward(request.getRequest(), response.getResponse());
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Unexpected error forwarding or redirecting to error page", t);
        }
    }

    protected void saveRequest(HttpRequest request, Session session) {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                saved.addCookie(cookies[i]);
            }
        }
        Enumeration names = hreq.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = hreq.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration locales = hreq.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            saved.addLocale(locale);
        }
        Map parameters = hreq.getParameterMap();
        for (Map.Entry e : parameters.entrySet()) {
            String paramName = (String)e.getKey();
            String[] paramValues = (String[])e.getValue();
            saved.addParameter(paramName, paramValues);
        }
        saved.setMethod(hreq.getMethod());
        saved.setQueryString(hreq.getQueryString());
        saved.setRequestURI(hreq.getRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            sb.append('?');
            sb.append(saved.getQueryString());
        }
        return sb.toString();
    }
}

