/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import com.sun.grizzly.tcp.InputBuffer;
import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.C2BConverter;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.HttpMessages;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;

public class JkInputStream
implements InputBuffer,
OutputBuffer {
    private static Logger log = Logger.getLogger(JkInputStream.class.getName());
    private Msg bodyMsg;
    private Msg outputMsg;
    private MsgContext mc;
    private MessageBytes bodyBuff = MessageBytes.newInstance();
    private MessageBytes tempMB = MessageBytes.newInstance();
    private boolean end_of_stream = false;
    private boolean isEmpty = true;
    private boolean isFirst = true;
    private boolean isReplay = false;
    private boolean isReadRequired = false;
    private int packetSize = 8192;

    public JkInputStream(MsgContext context, int bsize) {
        this.mc = context;
        this.packetSize = bsize < 8192 ? 8192 : bsize;
        this.bodyMsg = new MsgAjp(this.packetSize);
        this.outputMsg = new MsgAjp(this.packetSize);
    }

    public JkInputStream(MsgContext context) {
        this(context, 8192);
    }

    public void setIsReadRequired(boolean irr) {
        this.isReadRequired = irr;
    }

    public boolean isReadRequired() {
        return this.isReadRequired;
    }

    public void recycle() {
        if (this.isReadRequired && this.isFirst) {
            try {
                this.receive();
            }
            catch (IOException iex) {
                log.log(Level.FINEST, "Error consuming request body", iex);
            }
        }
        this.end_of_stream = false;
        this.isEmpty = true;
        this.isFirst = true;
        this.isReplay = false;
        this.isReadRequired = false;
        this.bodyBuff.recycle();
        this.tempMB.recycle();
    }

    public void endMessage() throws IOException {
        this.outputMsg.reset();
        this.outputMsg.appendByte(5);
        this.outputMsg.appendByte(1);
        this.mc.getSource().send(this.outputMsg, this.mc);
        this.mc.getSource().flush(this.outputMsg, this.mc);
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!res.isCommitted()) {
            res.sendHeaders();
        }
        int len = chunk.getLength();
        byte[] buf = this.outputMsg.getBuffer();
        int chunkSize = buf.length - this.outputMsg.getHeaderLength() - 4;
        int off = 0;
        while (len > 0) {
            int thisTime = len;
            if (thisTime > chunkSize) {
                thisTime = chunkSize;
            }
            len -= thisTime;
            this.outputMsg.reset();
            this.outputMsg.appendByte(3);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("doWrite " + off + " " + thisTime + " " + len);
            }
            this.outputMsg.appendBytes(chunk.getBytes(), chunk.getOffset() + off, thisTime);
            off += thisTime;
            this.mc.getSource().send(this.outputMsg, this.mc);
        }
        return 0;
    }

    public int doRead(ByteChunk responseChunk, Request req) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("doRead " + this.end_of_stream + " " + responseChunk.getOffset() + " " + responseChunk.getLength());
        }
        if (this.end_of_stream) {
            return -1;
        }
        if (this.isFirst && this.isReadRequired) {
            if (!this.receive()) {
                return 0;
            }
        } else if (this.isEmpty && !this.refillReadBuffer()) {
            return -1;
        }
        ByteChunk bc = this.bodyBuff.getByteChunk();
        responseChunk.setBytes(bc.getBuffer(), bc.getStart(), bc.getLength());
        this.isEmpty = true;
        return responseChunk.getLength();
    }

    public boolean receive() throws IOException {
        this.isFirst = false;
        this.bodyMsg.reset();
        int err = this.mc.getSource().receive(this.bodyMsg, this.mc);
        if (log.isLoggable(Level.FINEST)) {
            log.info("Receiving: getting request body chunk " + err + " " + this.bodyMsg.getLen());
        }
        if (err < 0) {
            throw new IOException();
        }
        if (this.bodyMsg.getLen() == 0) {
            return false;
        }
        int blen = this.bodyMsg.peekInt();
        if (blen == 0) {
            return false;
        }
        if (log.isLoggable(Level.FINEST)) {
            this.bodyMsg.dump("Body buffer");
        }
        this.bodyMsg.getBytes(this.bodyBuff);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Data:\n" + this.bodyBuff);
        }
        this.isEmpty = false;
        return true;
    }

    private boolean refillReadBuffer() throws IOException {
        if (this.isReplay) {
            this.end_of_stream = true;
        }
        if (this.end_of_stream) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("refillReadBuffer: end of stream ");
            }
            return false;
        }
        this.bodyMsg.reset();
        this.bodyMsg.appendByte(6);
        this.bodyMsg.appendInt(this.packetSize - 4 - 2);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("refillReadBuffer " + Thread.currentThread());
        }
        this.mc.getSource().send(this.bodyMsg, this.mc);
        this.mc.getSource().flush(this.bodyMsg, this.mc);
        boolean moreData = this.receive();
        if (!moreData) {
            this.end_of_stream = true;
        }
        return moreData;
    }

    public void appendHead(Response res) throws IOException {
        long contentLength;
        String contentLanguage;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("COMMIT sending headers " + res + " " + res.getMimeHeaders());
        }
        C2BConverter c2b = this.mc.getConverter();
        this.outputMsg.reset();
        this.outputMsg.appendByte(4);
        this.outputMsg.appendInt(res.getStatus());
        String message = null;
        if (res.isAllowCustomReasonPhrase()) {
            message = res.getMessage();
        }
        message = message == null ? HttpMessages.getMessage((int)res.getStatus()) : message.replace('\n', ' ').replace('\r', ' ');
        this.tempMB.setString(message);
        c2b.convert(this.tempMB);
        this.outputMsg.appendBytes(this.tempMB);
        MimeHeaders headers = res.getMimeHeaders();
        String contentType = res.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = res.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = res.getContentLengthLong()) >= 0L) {
            headers.setValue("Content-Length").setLong(contentLength);
        }
        int numHeaders = headers.size();
        this.outputMsg.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            MessageBytes hN = headers.getName(i);
            c2b.convert(hN);
            this.outputMsg.appendBytes(hN);
            MessageBytes hV = headers.getValue(i);
            c2b.convert(hV);
            this.outputMsg.appendBytes(hV);
        }
        this.mc.getSource().send(this.outputMsg, this.mc);
    }

    public void setReplay(ByteChunk replay) {
        this.isFirst = false;
        this.isEmpty = false;
        this.isReplay = true;
        this.bodyBuff.setBytes(replay.getBytes(), replay.getStart(), replay.getLength());
    }

    static {
        try {
            Class.forName("com.sun.grizzly.util.http.HttpMessages");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

