/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.security;

import org.apache.felix.eventadmin.impl.security.PermissionsUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventAdminSecurityDecorator
implements EventAdmin {
    private final Bundle m_bundle;
    private final EventAdmin m_admin;

    public EventAdminSecurityDecorator(Bundle bundle, EventAdmin admin) {
        this.checkNull(bundle, "Bundle");
        this.checkNull(admin, "Admin");
        this.m_bundle = bundle;
        this.m_admin = admin;
    }

    public void postEvent(Event event) {
        this.checkPermission(event.getTopic());
        this.m_admin.postEvent(event);
    }

    public void sendEvent(Event event) {
        this.checkPermission(event.getTopic());
        this.m_admin.sendEvent(event);
    }

    public int hashCode() {
        return this.m_admin.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof EventAdminSecurityDecorator) {
            return this.m_admin.equals(((EventAdminSecurityDecorator)o).m_admin);
        }
        return this.m_admin.equals(o);
    }

    private void checkPermission(String topic) {
        if (!this.m_bundle.hasPermission(PermissionsUtil.createPublishPermission(topic))) {
            throw new SecurityException("Bundle[" + this.m_bundle + "] has no PUBLISH permission for topic [" + topic + "]");
        }
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }
}

