/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;

public class SingleSignOnEntry {
    private static final Logger log = Logger.getLogger(SingleSignOnEntry.class.getName());
    protected String id = null;
    protected String authType = null;
    protected Principal principal = null;
    protected Set<Session> sessions = new HashSet<Session>();
    protected String username = null;
    protected String realmName = null;
    protected long lastAccessTime;
    protected AtomicLong version = null;

    public SingleSignOnEntry(String id, long ver, Principal principal, String authType, String username, String realmName) {
        this.id = id;
        this.version = new AtomicLong(ver);
        this.principal = principal;
        this.authType = authType;
        this.username = username;
        this.realmName = realmName;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        boolean result = this.sessions.add(session);
        if (result) {
            session.addSessionListener(sso);
        }
        return true;
    }

    public synchronized void removeSession(Session session) {
        this.sessions.remove(session);
    }

    public synchronized boolean isEmpty() {
        return this.sessions.size() == 0;
    }

    public synchronized void expireSessions() {
        for (Session session : this.sessions) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(" Invalidating session " + session);
            }
            if (!session.getIsValid()) continue;
            session.expire();
        }
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version.get();
    }

    public String getAuthType() {
        return this.authType;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long incrementAndGetVersion() {
        return this.version.incrementAndGet();
    }
}

