/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CatalinaProperties {
    private static Logger log = Logger.getLogger(CatalinaProperties.class.getName());
    private static Properties properties = null;

    public static String getProperty(String name) {
        return properties.getProperty(name);
    }

    public static String getProperty(String name, String defaultValue) {
        return properties.getProperty(name, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        InputStream is = null;
        Throwable error = null;
        try {
            String configUrl = CatalinaProperties.getConfigUrl();
            if (configUrl != null) {
                is = new URL(configUrl).openStream();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is == null) {
            try {
                File home = new File(CatalinaProperties.getCatalinaHome());
                File conf = new File(home, "conf");
                File properties = new File(conf, "catalina.properties");
                is = new FileInputStream(properties);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = CatalinaProperties.class.getResourceAsStream("/org/apache/catalina/startup/catalina.properties");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                properties = new Properties();
                properties.load(is);
            }
            catch (Throwable t) {
                error = t;
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable t2) {}
            }
        }
        if (is == null || error != null) {
            log.log(Level.WARNING, "Failed to load catalina.properties", error);
            properties = new Properties();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = properties.getProperty(name);
            if (value == null) continue;
            System.setProperty(name, value);
        }
    }

    private static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    private static String getConfigUrl() {
        return System.getProperty("catalina.config");
    }

    static {
        CatalinaProperties.loadProperties();
    }
}

