/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class SingleSignOn
extends ValveBase
implements SessionListener {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(SingleSignOn.class.getName());
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected static final String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected Map<String, SingleSignOnEntry> cache = new HashMap<String, SingleSignOnEntry>();

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        if (this.debug >= 1) {
            this.log("Started");
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log("Stopped");
        }
        super.stop();
    }

    public void sessionEvent(SessionEvent event) {
        String ssoId;
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.debug >= 1) {
            this.log("Process session destroyed on " + session);
        }
        if ((ssoId = session.getSsoId()) == null) {
            return;
        }
        this.deregister(ssoId, session);
    }

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        request.removeNote("org.apache.catalina.request.SSOVersion");
        if (this.debug >= 1) {
            this.log("Process request for '" + hreq.getRequestURI() + "'");
        }
        if (hreq.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                this.log(" Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 2;
        }
        if (this.debug >= 1) {
            this.log(" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie versionCookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if ("JSESSIONIDSSO".equals(cookies[i].getName())) {
                cookie = cookies[i];
            } else if ("JSESSIONIDSSOVERSION".equals(cookies[i].getName())) {
                versionCookie = cookies[i];
            }
            if (cookie != null && versionCookie != null) break;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(" SSO cookie is not present");
            }
            return 1;
        }
        if (this.debug >= 1) {
            this.log(" Checking for cached principal for " + cookie.getValue());
        }
        long version = 0L;
        if (this.isVersioningSupported() && versionCookie != null) {
            version = Long.parseLong(versionCookie.getValue());
        }
        if ((entry = this.lookup(cookie.getValue(), version)) != null) {
            if (this.debug >= 1) {
                this.log(" Found cached principal '" + entry.getPrincipal().getName() + "' with auth type '" + entry.getAuthType() + "'");
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            if (this.isVersioningSupported()) {
                long ver = entry.incrementAndGetVersion();
                request.setNote("org.apache.catalina.request.SSOVersion", ver);
            }
            ((HttpRequest)request).setAuthType(entry.getAuthType());
            ((HttpRequest)request).setUserPrincipal(entry.getPrincipal());
        } else {
            if (this.debug >= 1) {
                this.log(" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
        }
        return 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SingleSignOn[");
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void associate(String ssoId, long ssoVersion, Session session) {
        SingleSignOnEntry sso;
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log("Associate sso id " + ssoId + " with session " + session);
        }
        if ((sso = this.lookup(ssoId, ssoVersion)) != null) {
            session.setSsoId(ssoId);
            session.setSsoVersion(ssoVersion);
            sso.addSession(this, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso == null) {
            return;
        }
        session.setSsoId(null);
        session.setSsoVersion(0L);
        sso.removeSession(session);
        if (sso.isEmpty()) {
            Map<String, SingleSignOnEntry> map = this.cache;
            synchronized (map) {
                this.cache.remove(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, char[] password, String realmName) {
        if (this.debug >= 1) {
            this.log("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'");
        }
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(ssoId, 0L, principal, authType, username, realmName));
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.info(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable t) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.toString() + ": " + message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            return this.cache.get(ssoId);
        }
    }

    protected SingleSignOnEntry lookup(String ssoId, long ssoVersion) {
        return this.lookup(ssoId);
    }

    public boolean isVersioningSupported() {
        return false;
    }
}

