/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.accesslog;

import java.nio.CharBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.catalina.Request;
import org.apache.catalina.Response;

public abstract class AccessLogFormatter {
    static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    protected static final String SPACE = " ";
    protected volatile ThreadLocal<SimpleDateFormat> dayFormatter = null;
    protected volatile ThreadLocal<SimpleDateFormat> monthFormatter = null;
    protected volatile ThreadLocal<SimpleDateFormat> yearFormatter = null;
    protected volatile ThreadLocal<SimpleDateFormat> timeFormatter = null;
    protected String timeZone = null;
    protected TimeZone tz = TimeZone.getDefault();
    protected boolean needTimeTaken;
    private Date currentDate = null;

    public AccessLogFormatter() {
        this.timeZone = this.calculateTimeZoneOffset(this.tz.getRawOffset());
        this.currentDate = new Date(System.currentTimeMillis());
    }

    public abstract void appendLogEntry(Request var1, Response var2, CharBuffer var3);

    protected synchronized Date getDate() {
        long systime = System.currentTimeMillis();
        if (systime - this.currentDate.getTime() > 5000L) {
            this.currentDate = new Date(systime);
        }
        return this.currentDate;
    }

    protected String calculateTimeZoneOffset(long offset) {
        StringBuilder sb = new StringBuilder();
        if (offset < 0L) {
            sb.append("-");
            offset = -offset;
        } else {
            sb.append("+");
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            sb.append("0");
        }
        sb.append(hourOffset);
        if (minuteOffset < 10L) {
            sb.append("0");
        }
        sb.append(minuteOffset);
        return sb.toString();
    }

    protected String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            index = 0;
        }
        return months[index];
    }

    public boolean needTimeTaken() {
        return this.needTimeTaken;
    }
}

