/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;

public abstract class UpdateSensitiveLOBLocatorInputStream
extends InputStream {
    private BufferedInputStream is = null;
    protected Connection con = null;
    private Lob lob = null;
    private long updateCount;
    protected long currentPos;
    protected long length;

    protected UpdateSensitiveLOBLocatorInputStream(Connection connection, Lob lob, InputStream inputStream) throws SqlException {
        lob.checkForLocatorValidity();
        this.is = new BufferedInputStream(inputStream);
        this.currentPos = 1L;
        this.con = connection;
        this.lob = lob;
        this.updateCount = lob.getUpdateCount();
        this.length = -1L;
    }

    protected UpdateSensitiveLOBLocatorInputStream(Connection connection, Lob lob, InputStream inputStream, long l, long l2) throws SqlException {
        this(connection, lob, inputStream);
        this.currentPos = l;
        this.length = l2;
    }

    public int read() throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n = this.is.read();
        if (n == -1) {
            return n;
        }
        ++this.currentPos;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n3 = this.is.read(byArray, n, n2);
        if (n3 == -1) {
            return n3;
        }
        this.currentPos += (long)n3;
        return n3;
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    private void identifyAndReplaceObseleteStream() throws IOException {
        long l = this.lob.getUpdateCount();
        if (this.updateCount != l) {
            try {
                this.is = new BufferedInputStream(this.reCreateStream());
            }
            catch (SqlException sqlException) {
                IOException iOException = new IOException();
                iOException.initCause(sqlException);
                throw iOException;
            }
        } else {
            return;
        }
        this.updateCount = l;
    }

    protected abstract InputStream reCreateStream() throws SqlException;
}

