/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.util.StringUtil;

public final class SQLBoolean
extends DataType
implements BooleanDataValue {
    static final int BOOLEAN_LENGTH = 1;
    private static final SQLBoolean BOOLEAN_TRUE = new SQLBoolean(true);
    private static final SQLBoolean BOOLEAN_FALSE = new SQLBoolean(false);
    static final SQLBoolean UNKNOWN = new SQLBoolean();
    private static final int BASE_MEMORY_USAGE;
    private boolean value;
    private boolean isnull;
    private boolean immutable;

    public boolean isNull() {
        return this.isnull;
    }

    public boolean getBoolean() {
        return this.value;
    }

    private static int makeInt(boolean bl) {
        return bl ? 1 : 0;
    }

    public byte getByte() {
        return (byte)SQLBoolean.makeInt(this.value);
    }

    public short getShort() {
        return (short)SQLBoolean.makeInt(this.value);
    }

    public int getInt() {
        return SQLBoolean.makeInt(this.value);
    }

    public long getLong() {
        return SQLBoolean.makeInt(this.value);
    }

    public float getFloat() {
        return SQLBoolean.makeInt(this.value);
    }

    public double getDouble() {
        return SQLBoolean.makeInt(this.value);
    }

    public int typeToBigDecimal() {
        return -5;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Boolean(this.value);
    }

    public int getLength() {
        return 1;
    }

    public String getTypeName() {
        return "BOOLEAN";
    }

    public DataValueDescriptor recycle() {
        if (this.immutable) {
            return new SQLBoolean();
        }
        return super.recycle();
    }

    public int getTypeFormatId() {
        return 77;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.value);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readBoolean();
        this.isnull = false;
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.value = arrayInputStream.readBoolean();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = false;
        this.isnull = true;
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return 1;
            }
            if (!bl2) {
                return -1;
            }
            return 0;
        }
        boolean bl3 = false;
        boolean bl4 = this.getBoolean();
        if (bl4 == (bl3 = dataValueDescriptor.getBoolean())) {
            return 0;
        }
        if (bl4 && !bl3) {
            return 1;
        }
        return -1;
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLBoolean(this.value, this.isnull);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLBoolean();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getBoolean(n);
        this.isnull = bl && resultSet.wasNull();
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, -7);
            return;
        }
        preparedStatement.setBoolean(n, this.value);
    }

    public SQLBoolean() {
        this.isnull = true;
    }

    public SQLBoolean(boolean bl) {
        this.value = bl;
    }

    public SQLBoolean(Boolean bl) {
        this.isnull = bl == null;
        if (!this.isnull) {
            this.value = bl;
        }
    }

    private SQLBoolean(boolean bl, boolean bl2) {
        this.value = bl;
        this.isnull = bl2;
    }

    public void setValue(boolean bl) {
        this.value = bl;
        this.isnull = false;
    }

    public void setValue(Boolean bl) {
        if (bl == null) {
            this.value = false;
            this.isnull = true;
        } else {
            this.value = bl;
            this.isnull = false;
        }
    }

    public void setValue(byte by) {
        this.value = by != 0;
        this.isnull = false;
    }

    public void setValue(short s) {
        this.value = s != 0;
        this.isnull = false;
    }

    public void setValue(int n) {
        this.value = n != 0;
        this.isnull = false;
    }

    public void setValue(long l) {
        this.value = l != 0L;
        this.isnull = false;
    }

    public void setValue(float f) {
        this.value = f != 0.0f;
        this.isnull = false;
    }

    public void setValue(double d) {
        this.value = d != 0.0;
        this.isnull = false;
    }

    public void setBigDecimal(Number number) throws StandardException {
        if (number == null) {
            this.value = false;
            this.isnull = true;
        } else {
            DataValueDescriptor dataValueDescriptor = NumberDataType.ZERO_DECIMAL.getNewNull();
            dataValueDescriptor.setBigDecimal(number);
            this.value = NumberDataType.ZERO_DECIMAL.compare(dataValueDescriptor) != 0;
            this.isnull = false;
        }
    }

    public void setValue(byte[] byArray) {
        if (byArray != null) {
            this.isnull = false;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == 0) continue;
                this.value = true;
                return;
            }
        } else {
            this.isnull = true;
        }
        this.value = false;
    }

    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = false;
            this.isnull = true;
        } else {
            String string2 = StringUtil.SQLToUpperCase(string.trim());
            if (string2.equals("TRUE")) {
                this.value = true;
            } else if (string2.equals("FALSE")) {
                this.value = false;
            } else {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    private void setValueCore(Number number) {
        if (number == null) {
            this.isnull = true;
            this.value = false;
        } else {
            this.value = number.intValue() != 0;
            this.isnull = false;
        }
    }

    void setObject(Object object) {
        this.setValue((Boolean)object);
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getBoolean());
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getBoolean() == dataValueDescriptor2.getBoolean());
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getBoolean() != dataValueDescriptor2.getBoolean());
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.getBoolean();
        boolean bl2 = dataValueDescriptor2.getBoolean();
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, !bl && bl2);
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.getBoolean();
        boolean bl2 = dataValueDescriptor2.getBoolean();
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl && !bl2);
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.getBoolean();
        boolean bl2 = dataValueDescriptor2.getBoolean();
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, !bl || bl2);
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.getBoolean();
        boolean bl2 = dataValueDescriptor2.getBoolean();
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl || !bl2);
    }

    public BooleanDataValue and(BooleanDataValue booleanDataValue) {
        if (this.equals(false) || booleanDataValue.equals(false)) {
            return BOOLEAN_FALSE;
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, (DataValueDescriptor)booleanDataValue, this.getBoolean() && booleanDataValue.getBoolean());
    }

    public BooleanDataValue or(BooleanDataValue booleanDataValue) {
        if (this.equals(true) || booleanDataValue.equals(true)) {
            return BOOLEAN_TRUE;
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, (DataValueDescriptor)booleanDataValue, this.getBoolean() || booleanDataValue.getBoolean());
    }

    public BooleanDataValue is(BooleanDataValue booleanDataValue) {
        if (this.equals(true) && booleanDataValue.equals(true)) {
            return BOOLEAN_TRUE;
        }
        if (this.equals(false) && booleanDataValue.equals(false)) {
            return BOOLEAN_TRUE;
        }
        if (this.isNull() && booleanDataValue.isNull()) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public BooleanDataValue isNot(BooleanDataValue booleanDataValue) {
        BooleanDataValue booleanDataValue2 = this.is(booleanDataValue);
        if (booleanDataValue2.equals(true)) {
            return BOOLEAN_FALSE;
        }
        return BOOLEAN_TRUE;
    }

    public BooleanDataValue throwExceptionIfFalse(String string, String string2, String string3) throws StandardException {
        if (!this.isNull() && !this.value) {
            throw StandardException.newException(string, (Object)string2, (Object)string3);
        }
        return this;
    }

    public int typePrecedence() {
        return 130;
    }

    public static SQLBoolean truthValue(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2, boolean bl) {
        if (dataValueDescriptor.isNull() || dataValueDescriptor2.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        if (bl) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean truthValue(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2, Boolean bl) {
        if (dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() || bl == null) {
            return SQLBoolean.unknownTruthValue();
        }
        if (bl == Boolean.TRUE) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean truthValue(boolean bl) {
        if (bl) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean unknownTruthValue() {
        return UNKNOWN;
    }

    public static SQLBoolean falseTruthValue() {
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean trueTruthValue() {
        return BOOLEAN_TRUE;
    }

    public boolean equals(boolean bl) {
        if (this.isNull()) {
            return false;
        }
        return this.value == bl;
    }

    public BooleanDataValue getImmutable() {
        if (this.isNull()) {
            return UNKNOWN;
        }
        return this.value ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        if (this.isNull()) {
            return -1;
        }
        return this.value ? 1 : 0;
    }

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    static {
        SQLBoolean.BOOLEAN_TRUE.immutable = true;
        SQLBoolean.BOOLEAN_FALSE.immutable = true;
        SQLBoolean.UNKNOWN.immutable = true;
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLBoolean.class);
    }
}

