/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.component;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCFullyManagedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCManagedComponentProvider;
import com.sun.jersey.server.impl.component.ResourceFactory;
import com.sun.jersey.server.spi.component.ResourceComponentInjector;
import com.sun.jersey.server.spi.component.ResourceComponentProvider;
import com.sun.jersey.server.spi.component.ResourceComponentProviderFactory;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoCResourceFactory
extends ResourceFactory {
    private final List<IoCComponentProviderFactory> factories;

    public IoCResourceFactory(ResourceConfig config, InjectableProviderContext ipc, List<IoCComponentProviderFactory> factories) {
        super(config, ipc);
        this.factories = factories;
    }

    @Override
    public ResourceComponentProvider getComponentProvider(Class c) {
        IoCComponentProviderFactory f;
        IoCComponentProvider icp = null;
        Iterator<IoCComponentProviderFactory> i$ = this.factories.iterator();
        while (i$.hasNext() && (icp = (f = i$.next()).getComponentProvider(c)) == null) {
        }
        return icp == null ? super.getComponentProvider(c) : this.wrap(c, icp);
    }

    private ResourceComponentProvider wrap(Class c, IoCComponentProvider icp) {
        if (icp instanceof IoCManagedComponentProvider) {
            IoCManagedComponentProvider imcp = (IoCManagedComponentProvider)icp;
            if (imcp.getScope() == ComponentScope.PerRequest) {
                return new PerRequestWrapper(this.getInjectableProviderContext(), imcp);
            }
            if (imcp.getScope() == ComponentScope.Singleton) {
                return new SingletonWrapper(this.getInjectableProviderContext(), imcp);
            }
            return new UndefinedWrapper(this.getInjectableProviderContext(), imcp);
        }
        if (icp instanceof IoCFullyManagedComponentProvider) {
            IoCFullyManagedComponentProvider ifmcp = (IoCFullyManagedComponentProvider)icp;
            return new FullyManagedWrapper(ifmcp);
        }
        ResourceComponentProviderFactory rcpf = this.getComponentProviderFactory(c);
        return rcpf.getComponentProvider(icp, c);
    }

    private static class FullyManagedWrapper
    implements ResourceComponentProvider {
        private final IoCFullyManagedComponentProvider ifmcp;

        FullyManagedWrapper(IoCFullyManagedComponentProvider ifmcp) {
            this.ifmcp = ifmcp;
        }

        public void init(AbstractResource abstractResource) {
        }

        public Object getInstance(HttpContext hc) {
            return this.ifmcp.getInstance();
        }

        public Object getInstance() {
            throw new IllegalStateException();
        }

        public void destroy() {
        }
    }

    private static class PerRequestWrapper
    implements ResourceComponentProvider {
        private final InjectableProviderContext ipc;
        private final IoCManagedComponentProvider imcp;
        private ResourceComponentInjector rci;

        PerRequestWrapper(InjectableProviderContext ipc, IoCManagedComponentProvider imcp) {
            this.ipc = ipc;
            this.imcp = imcp;
        }

        public void init(AbstractResource abstractResource) {
            this.rci = new ResourceComponentInjector(this.ipc, ComponentScope.PerRequest, abstractResource);
        }

        public Object getInstance(HttpContext hc) {
            Object o = this.imcp.getInstance();
            this.rci.inject(hc, this.imcp.getInjectableInstance(o));
            return o;
        }

        public Object getInstance() {
            throw new IllegalStateException();
        }

        public void destroy() {
        }
    }

    private static class SingletonWrapper
    implements ResourceComponentProvider {
        private final InjectableProviderContext ipc;
        private final IoCManagedComponentProvider imcp;
        private Object o;

        SingletonWrapper(InjectableProviderContext ipc, IoCManagedComponentProvider imcp) {
            this.ipc = ipc;
            this.imcp = imcp;
        }

        public void init(AbstractResource abstractResource) {
            ResourceComponentInjector rci = new ResourceComponentInjector(this.ipc, ComponentScope.Singleton, abstractResource);
            this.o = this.imcp.getInstance();
            rci.inject(null, this.imcp.getInjectableInstance(this.o));
        }

        public Object getInstance(HttpContext hc) {
            return this.o;
        }

        public Object getInstance() {
            throw new IllegalStateException();
        }

        public void destroy() {
        }
    }

    private static class UndefinedWrapper
    implements ResourceComponentProvider {
        private final InjectableProviderContext ipc;
        private final IoCManagedComponentProvider imcp;
        private ResourceComponentInjector rci;

        UndefinedWrapper(InjectableProviderContext ipc, IoCManagedComponentProvider imcp) {
            this.ipc = ipc;
            this.imcp = imcp;
        }

        public void init(AbstractResource abstractResource) {
            this.rci = new ResourceComponentInjector(this.ipc, ComponentScope.Undefined, abstractResource);
        }

        public Object getInstance(HttpContext hc) {
            Object o = this.imcp.getInstance();
            this.rci.inject(hc, this.imcp.getInjectableInstance(o));
            return o;
        }

        public Object getInstance() {
            throw new IllegalStateException();
        }

        public void destroy() {
        }
    }
}

