/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.component;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.core.spi.component.ComponentConstructor;
import com.sun.jersey.core.spi.component.ComponentInjector;
import com.sun.jersey.server.impl.resource.PerRequestFactory;
import com.sun.jersey.server.spi.component.ResourceComponentProvider;
import com.sun.jersey.server.spi.component.ResourceComponentProviderFactory;
import com.sun.jersey.server.spi.component.ResourceComponentProviderFactoryClass;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFactory {
    private final ResourceConfig config;
    private final InjectableProviderContext ipc;
    private final Map<Class, ResourceComponentProviderFactory> factories;

    public ResourceFactory(ResourceConfig config, InjectableProviderContext ipc) {
        this.config = config;
        this.ipc = ipc;
        this.factories = new HashMap<Class, ResourceComponentProviderFactory>();
    }

    public InjectableProviderContext getInjectableProviderContext() {
        return this.ipc;
    }

    public ResourceComponentProvider getComponentProvider(Class c) {
        return (ResourceComponentProvider)this.getComponentProviderFactory(c).getComponentProvider(c);
    }

    protected ResourceComponentProviderFactory getComponentProviderFactory(Class c) {
        ResourceComponentProviderFactory rcpf;
        Annotation[] annotations;
        Class providerFactoryClass = null;
        for (Annotation a : annotations = c.getAnnotations()) {
            Class<? extends Annotation> annotationClass = a.annotationType();
            ResourceComponentProviderFactoryClass rf = annotationClass.getAnnotation(ResourceComponentProviderFactoryClass.class);
            if (rf != null && providerFactoryClass == null) {
                providerFactoryClass = rf.value();
                continue;
            }
            if (rf == null || providerFactoryClass == null) continue;
            throw new ContainerException(c.toString() + " has multiple ResourceComponentProviderClass annotations");
        }
        if (providerFactoryClass == null) {
            Object v = this.config.getProperties().get("com.sun.jersey.config.property.DefaultResourceComponentProviderFactoryClass");
            if (v == null) {
                providerFactoryClass = PerRequestFactory.class;
            } else if (v instanceof String) {
                try {
                    providerFactoryClass = this.getSubclass(ReflectionHelper.classForNameWithException((String)v));
                }
                catch (ClassNotFoundException ex) {
                    throw new ContainerException(ex);
                }
            } else if (v instanceof Class) {
                providerFactoryClass = this.getSubclass((Class)v);
            } else {
                throw new IllegalArgumentException("Property value for com.sun.jersey.config.property.DefaultResourceComponentProviderFactoryClass of type Class or String");
            }
        }
        if ((rcpf = this.factories.get(providerFactoryClass)) == null) {
            rcpf = this.getInstance(providerFactoryClass);
            this.factories.put(providerFactoryClass, rcpf);
        }
        return rcpf;
    }

    private Class<? extends ResourceComponentProviderFactory> getSubclass(Class<?> c) {
        if (ResourceComponentProviderFactory.class.isAssignableFrom(c)) {
            return c.asSubclass(ResourceComponentProviderFactory.class);
        }
        throw new IllegalArgumentException("Property value for com.sun.jersey.config.property.DefaultResourceComponentProviderFactoryClass of type " + c + " not of a subclass of " + ResourceComponentProviderFactory.class);
    }

    private ResourceComponentProviderFactory getInstance(Class<? extends ResourceComponentProviderFactory> providerFactoryClass) {
        try {
            ComponentInjector<? extends ResourceComponentProviderFactory> ci = new ComponentInjector<ResourceComponentProviderFactory>(this.ipc, providerFactoryClass);
            ComponentConstructor<? extends ResourceComponentProviderFactory> cc = new ComponentConstructor<ResourceComponentProviderFactory>(this.ipc, providerFactoryClass, ci);
            return cc.getInstance();
        }
        catch (Exception ex) {
            throw new ContainerException("Unable to create resource component provider", ex);
        }
    }
}

