/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.spi.monitoring.glassfish;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.jersey.server.impl.uri.rules.ResourceClassRule;
import com.sun.jersey.server.impl.uri.rules.ResourceObjectRule;
import com.sun.jersey.server.impl.uri.rules.SubLocatorRule;
import com.sun.jersey.server.spi.monitoring.glassfish.ApplicationStatsProvider;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.AbstractRuleEvent;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.DummyRuleEvent;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.ResourceClassRuleEvent;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.ResourceObjectRuleEvent;
import com.sun.jersey.server.spi.monitoring.glassfish.ruleevents.SubLocatorRuleEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.Habitat;

@AMXMetadata(type="jersey-global-mon", group="monitoring")
@ManagedObject
public class GlobalStatsProvider {
    private Set<String> applications;
    private Map<String, ApplicationStatsProvider> applicationStatsProviders;
    private static GlobalStatsProvider INSTANCE = null;
    private boolean registered = false;
    private ThreadLocal<List<AbstractRuleEvent>> ruleEvents = new ThreadLocal<List<AbstractRuleEvent>>(){

        @Override
        protected List<AbstractRuleEvent> initialValue() {
            return new ArrayList<AbstractRuleEvent>();
        }
    };
    private ThreadLocal<ApplicationStatsProvider> currentApplicationStatProvider = new ThreadLocal();

    private GlobalStatsProvider() {
        this.applications = new HashSet<String>();
        this.applicationStatsProviders = new HashMap<String, ApplicationStatsProvider>();
    }

    public static synchronized GlobalStatsProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GlobalStatsProvider();
        }
        return INSTANCE;
    }

    public synchronized void register() {
        if (!this.registered) {
            StatsProviderManager.register((String)"jersey", (PluginPoint)PluginPoint.SERVER, (String)"/jersey/global", (Object)this);
            Logger.getLogger("Jersey-Monitoring").log(Level.INFO, "GlobalStatsProvider registered");
            this.registered = true;
        }
    }

    @ManagedAttribute(id="applicationlist")
    public Set<String> getApplications() {
        return this.applications;
    }

    @Reset
    public void reset() {
        this.applications = new HashSet<String>();
    }

    @ProbeListener(value="glassfish:jersey:server:requestStart")
    public void requestStart(@ProbeParam(value="requestUri") URI requestUri) {
        ApplicationStatsProvider applicationStatsProvider;
        String applicationName = this.getApplicationName(requestUri.getPath());
        this.applications.add(applicationName);
        if (!this.applicationStatsProviders.containsKey(applicationName)) {
            applicationStatsProvider = new ApplicationStatsProvider();
            this.applicationStatsProviders.put(applicationName, applicationStatsProvider);
            StatsProviderManager.register((String)"jersey", (PluginPoint)PluginPoint.SERVER, (String)("applications/" + applicationName + "/jersey/resources"), (Object)applicationStatsProvider);
            Logger.getLogger("Jersey-Monitoring").log(Level.INFO, "ApplicationStatsProvider for application \"" + applicationName + "\" registered");
        } else {
            applicationStatsProvider = this.applicationStatsProviders.get(applicationName);
        }
        this.currentApplicationStatProvider.set(applicationStatsProvider);
    }

    private String getApplicationName(String path) {
        Habitat habitat = Globals.getDefaultHabitat();
        Domain domain = (Domain)habitat.getInhabitantByType(Domain.class).get();
        List applicationList = domain.getApplications().getApplications();
        for (Application app : applicationList) {
            if (!path.startsWith(app.getContextRoot() + "/") && !path.equals(app.getContextRoot())) continue;
            return app.getName();
        }
        return null;
    }

    @ProbeListener(value="glassfish:jersey:server:ruleAccept")
    public void ruleAccept(@ProbeParam(value="ruleName") String ruleName, @ProbeParam(value="path") CharSequence path, @ProbeParam(value="clazz") Object clazz) {
        AbstractRuleEvent ruleEvent = ruleName.equals(ResourceClassRule.class.getSimpleName()) ? new ResourceClassRuleEvent(ruleName, path, clazz, this.ruleEvents.get()) : (ruleName.equals(SubLocatorRule.class.getSimpleName()) ? new SubLocatorRuleEvent(ruleName, path, clazz, this.ruleEvents.get()) : (ruleName.equals(ResourceObjectRule.class.getSimpleName()) ? new ResourceObjectRuleEvent(ruleName, path, clazz, this.ruleEvents.get()) : new DummyRuleEvent(ruleName, path, clazz)));
        this.ruleEvents.get().add(ruleEvent);
    }

    @ProbeListener(value="glassfish:jersey:server:requestEnd")
    public void requestEnd() {
        for (AbstractRuleEvent ruleEvent : this.ruleEvents.get()) {
            ruleEvent.process(this.currentApplicationStatProvider.get());
        }
        this.ruleEvents.get().clear();
    }
}

