/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.modelapi.validation;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.model.AbstractField;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceConstructor;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSetterMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.api.model.AbstractSubResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.api.model.Parameterized;
import com.sun.jersey.api.model.ResourceModelIssue;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.impl.modelapi.validation.AbstractModelValidator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicValidator
extends AbstractModelValidator {
    private static final Set<Class> ParamAnnotationSET = BasicValidator.createParamAnnotationSet();

    @Override
    public void visitAbstractResource(AbstractResource resource) {
        if (resource.isRootResource() && (null == resource.getPath() || null == resource.getPath().getValue())) {
            this.issueList.add(new ResourceModelIssue(resource, ImplMessages.ERROR_RES_URI_PATH_INVALID(resource.getResourceClass(), resource.getPath()), true));
        }
        if (resource.isRootResource() && resource.getConstructors().isEmpty()) {
            this.issueList.add(new ResourceModelIssue(resource, ImplMessages.ROOT_RES_NO_PUBLIC_CTOR(resource.getResourceClass()), true));
        }
        HashMap<UriTemplate, String> srlUriTemplates = new HashMap<UriTemplate, String>();
        HashMap<UriTemplate, String> srlUriTemplatesWithSlash = new HashMap<UriTemplate, String>();
        for (AbstractSubResourceLocator srl : resource.getSubResourceLocators()) {
            UriTemplate srlUriTemplateWithSlash;
            UriTemplate srlUriTemplate = new UriTemplate(srl.getPath().getValue());
            UriTemplate uriTemplate = srlUriTemplateWithSlash = srlUriTemplate.endsWithSlash() ? srlUriTemplate : new UriTemplate(srl.getPath().getValue() + '/');
            if (srlUriTemplates.containsKey(srlUriTemplate)) {
                this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_SRLS(resource.getResourceClass(), srlUriTemplate.getTemplate(), srlUriTemplates.get(srlUriTemplate)), true));
                continue;
            }
            if (srlUriTemplatesWithSlash.containsKey(srlUriTemplateWithSlash)) {
                this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_SRLS(resource.getResourceClass(), srlUriTemplate.getTemplate(), srlUriTemplatesWithSlash.get(srlUriTemplate)), true));
            } else {
                srlUriTemplatesWithSlash.put(srlUriTemplateWithSlash, srlUriTemplate.getTemplate());
            }
            srlUriTemplates.put(srlUriTemplate, srlUriTemplate.getTemplate());
        }
        this.findOutMTAmbiguities(resource, resource.getResourceMethods(), new ResourceMethodAmbiguityErrMsgGenerator<AbstractResourceMethod>(){

            @Override
            void generateInErrMsg(AbstractResource resource, AbstractResourceMethod arm1, AbstractResourceMethod arm2, MediaType mt) {
                BasicValidator.this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_RMS_IN(resource.getResourceClass(), arm1.getHttpMethod(), mt, arm1.getMethod().getName(), arm2.getMethod().getName(), arm1.getSupportedInputTypes(), arm2.getSupportedInputTypes()), false));
            }

            @Override
            void generateOutErrMsg(AbstractResource resource, AbstractResourceMethod arm1, AbstractResourceMethod arm2, MediaType mt) {
                BasicValidator.this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_RMS_OUT(resource.getResourceClass(), arm1.getHttpMethod(), mt, arm1.getMethod().getName(), arm2.getMethod().getName(), arm1.getSupportedOutputTypes(), arm2.getSupportedOutputTypes()), true));
            }
        });
        this.findOutMTAmbiguities(resource, resource.getSubResourceMethods(), new ResourceMethodAmbiguityErrMsgGenerator<AbstractSubResourceMethod>(){

            boolean isConflictingPaths(String path1, String path2) {
                UriTemplate t1 = new UriTemplate(path1);
                UriTemplate t2 = new UriTemplate(path2);
                if (t1.equals(t2)) {
                    return true;
                }
                if (t1.endsWithSlash()) {
                    return !t2.endsWithSlash() && t1.equals(new UriTemplate(path2 + "/"));
                }
                return t2.endsWithSlash() && t2.equals(new UriTemplate(path1 + "/"));
            }

            @Override
            void generateInErrMsg(AbstractResource resource, AbstractSubResourceMethod arm1, AbstractSubResourceMethod arm2, MediaType mt) {
                if (this.isConflictingPaths(arm1.getPath().getValue(), arm2.getPath().getValue())) {
                    BasicValidator.this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_SRMS_IN(resource.getResourceClass(), arm1.getHttpMethod(), arm1.getPath().getValue(), mt, arm1.getMethod().getName(), arm2.getMethod().getName(), arm1.getSupportedInputTypes(), arm2.getSupportedInputTypes()), false));
                }
            }

            @Override
            void generateOutErrMsg(AbstractResource resource, AbstractSubResourceMethod arm1, AbstractSubResourceMethod arm2, MediaType mt) {
                if (this.isConflictingPaths(arm1.getPath().getValue(), arm2.getPath().getValue())) {
                    BasicValidator.this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_SRMS_OUT(resource.getResourceClass(), arm1.getHttpMethod(), arm1.getPath().getValue(), mt, arm1.getMethod().getName(), arm2.getMethod().getName(), arm1.getSupportedOutputTypes(), arm2.getSupportedOutputTypes()), true));
                }
            }
        });
        this.checkNonPublicMethods(resource);
    }

    private <T extends AbstractResourceMethod> void findOutMTAmbiguities(AbstractResource resource, List<T> methods, ResourceMethodAmbiguityErrMsgGenerator generator) {
        for (int i = 0; i < methods.size(); ++i) {
            AbstractResourceMethod arm1 = (AbstractResourceMethod)methods.get(i);
            for (int j = i + 1; j < methods.size(); ++j) {
                AbstractResourceMethod arm2 = (AbstractResourceMethod)methods.get(j);
                if (!arm1.getHttpMethod().equalsIgnoreCase(arm2.getHttpMethod())) continue;
                for (MediaType mt1 : arm1.getSupportedInputTypes()) {
                    for (MediaType mt2 : arm2.getSupportedInputTypes()) {
                        if (!mt1.isCompatible(mt2) || mt1.isWildcardType() != mt2.isWildcardType() || mt1.isWildcardSubtype() != mt2.isWildcardSubtype()) continue;
                        for (MediaType outmt1 : arm1.getSupportedOutputTypes()) {
                            for (MediaType outmt2 : arm2.getSupportedOutputTypes()) {
                                if (!outmt1.isCompatible(outmt2) || outmt1.isWildcardType() != outmt2.isWildcardType() || outmt1.isWildcardSubtype() != outmt2.isWildcardSubtype()) continue;
                                if (!"GET".equalsIgnoreCase(arm1.getHttpMethod()) && !"HEAD".equalsIgnoreCase(arm1.getHttpMethod())) {
                                    generator.generateInErrMsg(resource, arm1, arm2, mt1);
                                }
                                generator.generateOutErrMsg(resource, arm1, arm2, outmt1);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visitAbstractResourceConstructor(AbstractResourceConstructor constructor) {
    }

    @Override
    public void visitAbstractField(AbstractField field) {
        Field f = field.getField();
        this.checkParameter(field.getParameters().get(0), f, f.toGenericString(), f.getName());
    }

    @Override
    public void visitAbstractSetterMethod(AbstractSetterMethod setterMethod) {
        Method m = setterMethod.getMethod();
        this.checkParameter(setterMethod.getParameters().get(0), m, m.toGenericString(), "1");
    }

    @Override
    public void visitAbstractResourceMethod(AbstractResourceMethod method) {
        Type t;
        this.checkParameters(method, method.getMethod());
        if (!this.isRequestResponseMethod(method) && "GET".equals(method.getHttpMethod()) && Void.TYPE == method.getMethod().getReturnType()) {
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.ERROR_GET_RETURNS_VOID(method.getMethod()), false));
        }
        if (!this.isRequestResponseMethod(method) && "GET".equals(method.getHttpMethod())) {
            for (Parameter p : method.getParameters()) {
                if (Parameter.Source.ENTITY != p.getSource()) continue;
                this.issueList.add(new ResourceModelIssue(method, ImplMessages.ERROR_GET_CONSUMES_ENTITY(method.getMethod()), true));
            }
        }
        LinkedList<String> httpAnnotList = new LinkedList<String>();
        for (Annotation a : method.getMethod().getDeclaredAnnotations()) {
            if (null != a.annotationType().getAnnotation(HttpMethod.class)) {
                httpAnnotList.add(((Object)a).toString());
                continue;
            }
            if (a.annotationType() != Path.class || method instanceof AbstractSubResourceMethod) continue;
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.SUB_RES_METHOD_TREATED_AS_RES_METHOD(method.getMethod(), ((Path)a).value()), false));
        }
        if (httpAnnotList.size() > 1) {
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.MULTIPLE_HTTP_METHOD_DESIGNATORS(method.getMethod(), ((Object)httpAnnotList).toString()), true));
        }
        if (!this.isConcreteType(t = method.getGenericReturnType())) {
            this.issueList.add(new ResourceModelIssue(method.getMethod(), "Return type " + t + " of method " + method.getMethod().toGenericString() + " is not resolvable to a concrete type", false));
        }
    }

    @Override
    public void visitAbstractSubResourceMethod(AbstractSubResourceMethod method) {
        this.visitAbstractResourceMethod(method);
        if (null == method.getPath() || null == method.getPath().getValue() || method.getPath().getValue().length() == 0) {
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.ERROR_SUBRES_METHOD_URI_PATH_INVALID(method.getMethod(), method.getPath()), true));
        }
    }

    @Override
    public void visitAbstractSubResourceLocator(AbstractSubResourceLocator locator) {
        this.checkParameters(locator, locator.getMethod());
        if (Void.TYPE == locator.getMethod().getReturnType()) {
            this.issueList.add(new ResourceModelIssue(locator, ImplMessages.ERROR_SUBRES_LOC_RETURNS_VOID(locator.getMethod()), true));
        }
        if (null == locator.getPath() || null == locator.getPath().getValue() || locator.getPath().getValue().length() == 0) {
            this.issueList.add(new ResourceModelIssue(locator, ImplMessages.ERROR_SUBRES_LOC_URI_PATH_INVALID(locator.getMethod(), locator.getPath()), true));
        }
        for (Parameter parameter : locator.getParameters()) {
            if (Parameter.Source.ENTITY != parameter.getSource()) continue;
            this.issueList.add(new ResourceModelIssue(locator, ImplMessages.ERROR_SUBRES_LOC_HAS_ENTITY_PARAM(locator.getMethod()), true));
        }
    }

    private static Set<Class> createParamAnnotationSet() {
        HashSet<Class> set = new HashSet<Class>(6);
        set.add(Context.class);
        set.add(HeaderParam.class);
        set.add(CookieParam.class);
        set.add(MatrixParam.class);
        set.add(QueryParam.class);
        set.add(PathParam.class);
        return Collections.unmodifiableSet(set);
    }

    private void checkParameter(Parameter p, Object source, String nameForLogging, String paramNameForLogging) {
        Type t;
        int annotCount = 0;
        for (Annotation a : p.getAnnotations()) {
            if (!ParamAnnotationSET.contains(a.annotationType()) || ++annotCount <= 1) continue;
            this.issueList.add(new ResourceModelIssue(source, ImplMessages.AMBIGUOUS_PARAMETER(nameForLogging, paramNameForLogging), false));
            break;
        }
        if (!this.isConcreteType(t = p.getParameterType())) {
            this.issueList.add(new ResourceModelIssue(source, "Parameter " + paramNameForLogging + " of type " + t + " from " + nameForLogging + " is not resolvable to a concrete type", false));
        }
    }

    private boolean isConcreteType(Type t) {
        if (t instanceof ParameterizedType) {
            return this.isConcreteParameterizedType((ParameterizedType)t);
        }
        return t instanceof Class;
    }

    private boolean isConcreteParameterizedType(ParameterizedType pt) {
        boolean isConcrete = true;
        for (Type t : pt.getActualTypeArguments()) {
            isConcrete &= this.isConcreteType(t);
        }
        return isConcrete;
    }

    private void checkParameters(Parameterized pl, Method m) {
        int paramCount = 0;
        for (Parameter p : pl.getParameters()) {
            this.checkParameter(p, m, m.toGenericString(), Integer.toString(++paramCount));
        }
    }

    private List<Method> getDeclaredMethods(final Class _c) {
        final ArrayList<Method> ml = new ArrayList<Method>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            Class c;
            {
                this.c = _c;
            }

            @Override
            public Object run() {
                while (this.c != Object.class && this.c != null) {
                    for (Method m : this.c.getDeclaredMethods()) {
                        ml.add(m);
                    }
                    this.c = this.c.getSuperclass();
                }
                return null;
            }
        });
        return ml;
    }

    private void checkNonPublicMethods(AbstractResource ar) {
        MethodList declaredMethods = new MethodList(this.getDeclaredMethods(ar.getResourceClass()));
        for (AnnotatedMethod m : declaredMethods.hasMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class).isNotPublic()) {
            this.issueList.add(new ResourceModelIssue(ar, ImplMessages.NON_PUB_RES_METHOD(m.getMethod().toGenericString()), false));
        }
        for (AnnotatedMethod m : declaredMethods.hasMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class).isNotPublic()) {
            this.issueList.add(new ResourceModelIssue(ar, ImplMessages.NON_PUB_SUB_RES_METHOD(m.getMethod().toGenericString()), false));
        }
        for (AnnotatedMethod m : declaredMethods.hasNotMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class).isNotPublic()) {
            this.issueList.add(new ResourceModelIssue(ar, ImplMessages.NON_PUB_SUB_RES_LOC(m.getMethod().toGenericString()), false));
        }
    }

    private boolean isRequestResponseMethod(AbstractResourceMethod method) {
        return method.getMethod().getParameterTypes().length == 2 && HttpRequestContext.class == method.getMethod().getParameterTypes()[0] && HttpResponseContext.class == method.getMethod().getParameterTypes()[1];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ResourceMethodAmbiguityErrMsgGenerator<T extends AbstractResourceMethod> {
        private ResourceMethodAmbiguityErrMsgGenerator() {
        }

        abstract void generateInErrMsg(AbstractResource var1, T var2, T var3, MediaType var4);

        abstract void generateOutErrMsg(AbstractResource var1, T var2, T var3, MediaType var4);
    }
}

