/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.JsonSerializable;
import org.codehaus.jackson.map.JsonSerializableWithType;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.ext.OptionalHandlerFactory;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.map.ser.ArraySerializers;
import org.codehaus.jackson.map.ser.ContainerSerializers;
import org.codehaus.jackson.map.ser.EnumMapSerializer;
import org.codehaus.jackson.map.ser.EnumSerializer;
import org.codehaus.jackson.map.ser.JdkSerializers;
import org.codehaus.jackson.map.ser.JsonValueSerializer;
import org.codehaus.jackson.map.ser.MapSerializer;
import org.codehaus.jackson.map.ser.NullSerializer;
import org.codehaus.jackson.map.ser.StdSerializers;
import org.codehaus.jackson.map.ser.ToStringSerializer;
import org.codehaus.jackson.map.ser.impl.IndexedStringListSerializer;
import org.codehaus.jackson.map.ser.impl.ObjectArraySerializer;
import org.codehaus.jackson.map.ser.impl.StringCollectionSerializer;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.map.util.EnumValues;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.util.TokenBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicSerializerFactory
extends SerializerFactory {
    protected static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy = new HashMap();
    static final JsonSerializer<?> MARKER_INDEXED_LIST = new SerializerMarker();
    static final JsonSerializer<?> MARKER_COLLECTION = new SerializerMarker();
    static final JsonSerializer<?> MARKER_OBJECT_ARRAY = new SerializerMarker();
    static final JsonSerializer<?> MARKER_STRING_ARRAY = new SerializerMarker();
    static final JsonSerializer<?> MARKER_OBJECT_MAP = new SerializerMarker();
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;

    protected BasicSerializerFactory() {
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializationConfig config, JavaType type, BeanProperty property) {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type);
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (ser == null && (ser = this.findSerializerByLookup(type, config, beanDesc, property)) == null && (ser = this.findSerializerByPrimaryType(type, config, beanDesc, property)) == null) {
            ser = this.findSerializerByAddonType(config, type, beanDesc, property);
        }
        JsonSerializer<Object> s2 = ser;
        return s2;
    }

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig config, JavaType baseType, BeanProperty property) {
        BasicBeanDescription bean = (BasicBeanDescription)config.introspectClassAnnotations(baseType.getRawClass());
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, config, ai);
        }
        return b == null ? null : b.buildTypeSerializer(baseType, subtypes, property);
    }

    public final JsonSerializer<?> getNullSerializer() {
        return NullSerializer.instance;
    }

    public final JsonSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc, BeanProperty property) {
        Class<JsonSerializer<?>> serClass;
        String clsName = type.getRawClass().getName();
        JsonSerializer<?> ser = _concrete.get(clsName);
        if (ser == null && (serClass = _concreteLazy.get(clsName)) != null) {
            try {
                ser = serClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + serClass.getName() + "): " + e.getMessage(), e);
            }
        }
        if (ser != null) {
            JavaType elemType;
            if (ser == MARKER_OBJECT_MAP) {
                return this.buildMapSerializer(config, type, beanDesc, property);
            }
            if (ser == MARKER_OBJECT_ARRAY) {
                return this.buildObjectArraySerializer(config, type, beanDesc, property);
            }
            if (ser == MARKER_STRING_ARRAY) {
                return new ArraySerializers.StringArraySerializer(property);
            }
            if (ser == MARKER_INDEXED_LIST) {
                elemType = type.getContentType();
                if (elemType.getRawClass() == String.class) {
                    return new IndexedStringListSerializer(property);
                }
                return this.buildIndexedListSerializer(config, type, beanDesc, property);
            }
            if (ser == MARKER_COLLECTION) {
                elemType = type.getContentType();
                if (elemType.getRawClass() == String.class) {
                    return new StringCollectionSerializer(property);
                }
                return this.buildCollectionSerializer(config, type, beanDesc, property);
            }
        } else {
            ser = this.optionalHandlers.findSerializer(config, type, beanDesc, property);
        }
        return ser;
    }

    public final JsonSerializer<?> findSerializerByPrimaryType(JavaType type, SerializationConfig config, BasicBeanDescription beanDesc, BeanProperty property) {
        Class cls = type.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(cls)) {
            if (JsonSerializableWithType.class.isAssignableFrom(cls)) {
                return StdSerializers.SerializableWithTypeSerializer.instance;
            }
            return StdSerializers.SerializableSerializer.instance;
        }
        if (Map.class.isAssignableFrom(cls)) {
            if (EnumMap.class.isAssignableFrom(cls)) {
                return this.buildEnumMapSerializer(config, type, beanDesc, property);
            }
            return this.buildMapSerializer(config, type, beanDesc, property);
        }
        if (Object[].class.isAssignableFrom(cls)) {
            return this.buildObjectArraySerializer(config, type, beanDesc, property);
        }
        if (List.class.isAssignableFrom(cls)) {
            if (cls == List.class || cls == AbstractList.class || RandomAccess.class.isAssignableFrom(cls)) {
                return this.buildIndexedListSerializer(config, type, beanDesc, property);
            }
            return this.buildCollectionSerializer(config, type, beanDesc, property);
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValueMethod();
        if (valueMethod != null) {
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, valueMethod, property);
            return new JsonValueSerializer(valueMethod.getAnnotated(), ser, property);
        }
        if (Number.class.isAssignableFrom(cls)) {
            return StdSerializers.NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(cls)) {
            Class enumClass = cls;
            return EnumSerializer.construct(enumClass, config, beanDesc);
        }
        if (Calendar.class.isAssignableFrom(cls)) {
            return StdSerializers.CalendarSerializer.instance;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return StdSerializers.UtilDateSerializer.instance;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            if (EnumSet.class.isAssignableFrom(cls)) {
                return this.buildEnumSetSerializer(config, type, beanDesc, property);
            }
            return this.buildCollectionSerializer(config, type, beanDesc, property);
        }
        return null;
    }

    public final JsonSerializer<?> findSerializerByAddonType(SerializationConfig config, JavaType javaType, BasicBeanDescription beanDesc, BeanProperty property) {
        Class type = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(type)) {
            return this.buildIteratorSerializer(config, javaType, beanDesc, property);
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return this.buildIterableSerializer(config, javaType, beanDesc, property);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializationConfig config, Annotated a, BeanProperty property) {
        Object serDef = config.getAnnotationIntrospector().findSerializer(a, property);
        if (serDef != null) {
            if (serDef instanceof JsonSerializer) {
                return (JsonSerializer)serDef;
            }
            if (!(serDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned value of type " + serDef.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            Class cls = (Class)serDef;
            if (!JsonSerializer.class.isAssignableFrom(cls)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + cls.getName() + "; expected Class<JsonSerializer>");
            }
            return (JsonSerializer)ClassUtil.createInstance(cls, config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS));
        }
        return null;
    }

    protected JsonSerializer<?> buildMapSerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        JavaType valueType = type.getContentType();
        TypeSerializer vts = this.createTypeSerializer(config, valueType, property);
        boolean staticTyping = this.usesStaticTyping(config, beanDesc, vts);
        return MapSerializer.construct(intr.findPropertiesToIgnore(beanDesc.getClassInfo()), type, staticTyping, vts, property);
    }

    protected JsonSerializer<?> buildEnumMapSerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) {
        JavaType keyType = type.getKeyType();
        JavaType valueType = type.getContentType();
        EnumValues enums = null;
        if (keyType.isEnumType()) {
            Class enumClass = keyType.getRawClass();
            enums = EnumValues.construct(enumClass, config.getAnnotationIntrospector());
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType, property);
        return new EnumMapSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), enums, vts, property);
    }

    protected JsonSerializer<?> buildObjectArraySerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) {
        JavaType valueType = type.getContentType();
        TypeSerializer vts = this.createTypeSerializer(config, valueType, property);
        return new ObjectArraySerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts, property);
    }

    protected JsonSerializer<?> buildIndexedListSerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) {
        JavaType valueType = type.getContentType();
        TypeSerializer vts = this.createTypeSerializer(config, valueType, property);
        return ContainerSerializers.indexedListSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts, property);
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) {
        JavaType valueType = type.getContentType();
        TypeSerializer vts = this.createTypeSerializer(config, valueType, property);
        return ContainerSerializers.collectionSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts, property);
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.type(Object.class);
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType, property);
        return ContainerSerializers.iteratorSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts, property);
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.type(Object.class);
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType, property);
        return ContainerSerializers.iterableSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts, property);
    }

    protected JsonSerializer<?> buildEnumSetSerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) {
        JavaType enumType = type.getContentType();
        if (!enumType.isEnumType()) {
            enumType = null;
        }
        return ContainerSerializers.enumSetSerializer(enumType, property);
    }

    protected boolean usesStaticTyping(SerializationConfig config, BasicBeanDescription beanDesc, TypeSerializer typeSer) {
        if (typeSer != null) {
            return false;
        }
        JsonSerialize.Typing t = config.getAnnotationIntrospector().findSerializationTyping(beanDesc.getClassInfo());
        if (t != null) {
            return t == JsonSerialize.Typing.STATIC;
        }
        return config.isEnabled(SerializationConfig.Feature.USE_STATIC_TYPING);
    }

    static {
        _concrete.put(String.class.getName(), new StdSerializers.StringSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), sls);
        _concrete.put(StringBuilder.class.getName(), sls);
        _concrete.put(Character.class.getName(), sls);
        _concrete.put(Character.TYPE.getName(), sls);
        _concrete.put(Boolean.TYPE.getName(), new StdSerializers.BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new StdSerializers.BooleanSerializer(false));
        StdSerializers.IntegerSerializer intS = new StdSerializers.IntegerSerializer();
        _concrete.put(Integer.class.getName(), intS);
        _concrete.put(Integer.TYPE.getName(), intS);
        _concrete.put(Long.class.getName(), StdSerializers.LongSerializer.instance);
        _concrete.put(Long.TYPE.getName(), StdSerializers.LongSerializer.instance);
        _concrete.put(Byte.class.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Byte.TYPE.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Short.class.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Short.TYPE.getName(), StdSerializers.IntLikeSerializer.instance);
        _concrete.put(Float.class.getName(), StdSerializers.FloatSerializer.instance);
        _concrete.put(Float.TYPE.getName(), StdSerializers.FloatSerializer.instance);
        _concrete.put(Double.class.getName(), StdSerializers.DoubleSerializer.instance);
        _concrete.put(Double.TYPE.getName(), StdSerializers.DoubleSerializer.instance);
        StdSerializers.NumberSerializer ns = new StdSerializers.NumberSerializer();
        _concrete.put(BigInteger.class.getName(), ns);
        _concrete.put(BigDecimal.class.getName(), ns);
        _concrete.put(Calendar.class.getName(), StdSerializers.CalendarSerializer.instance);
        _concrete.put(Date.class.getName(), StdSerializers.UtilDateSerializer.instance);
        _concrete.put(java.sql.Date.class.getName(), new StdSerializers.SqlDateSerializer());
        _concrete.put(Time.class.getName(), new StdSerializers.SqlTimeSerializer());
        _concrete.put(Timestamp.class.getName(), StdSerializers.UtilDateSerializer.instance);
        _concrete.put(boolean[].class.getName(), new ArraySerializers.BooleanArraySerializer());
        _concrete.put(byte[].class.getName(), new ArraySerializers.ByteArraySerializer());
        _concrete.put(char[].class.getName(), new ArraySerializers.CharArraySerializer());
        _concrete.put(short[].class.getName(), new ArraySerializers.ShortArraySerializer());
        _concrete.put(int[].class.getName(), new ArraySerializers.IntArraySerializer());
        _concrete.put(long[].class.getName(), new ArraySerializers.LongArraySerializer());
        _concrete.put(float[].class.getName(), new ArraySerializers.FloatArraySerializer());
        _concrete.put(double[].class.getName(), new ArraySerializers.DoubleArraySerializer());
        _concrete.put(Object[].class.getName(), MARKER_OBJECT_ARRAY);
        _concrete.put(String[].class.getName(), MARKER_STRING_ARRAY);
        _concrete.put(ArrayList.class.getName(), MARKER_INDEXED_LIST);
        _concrete.put(Vector.class.getName(), MARKER_INDEXED_LIST);
        _concrete.put(LinkedList.class.getName(), MARKER_COLLECTION);
        _concrete.put(HashMap.class.getName(), MARKER_OBJECT_MAP);
        _concrete.put(Hashtable.class.getName(), MARKER_OBJECT_MAP);
        _concrete.put(LinkedHashMap.class.getName(), MARKER_OBJECT_MAP);
        _concrete.put(TreeMap.class.getName(), MARKER_OBJECT_MAP);
        _concrete.put(Properties.class.getName(), MARKER_OBJECT_MAP);
        _concrete.put(HashSet.class.getName(), MARKER_COLLECTION);
        _concrete.put(LinkedHashSet.class.getName(), MARKER_COLLECTION);
        _concrete.put(TreeSet.class.getName(), MARKER_COLLECTION);
        for (Map.Entry<Class<?>, Object> en : new JdkSerializers().provide()) {
            Object value = en.getValue();
            if (value instanceof JsonSerializer) {
                _concrete.put(en.getKey().getName(), (JsonSerializer)value);
                continue;
            }
            if (value instanceof Class) {
                Class cls = (Class)value;
                _concreteLazy.put(en.getKey().getName(), cls);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + en.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), StdSerializers.TokenBufferSerializer.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SerializerMarker
    extends JsonSerializer<Object> {
        private SerializerMarker() {
        }

        @Override
        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) {
        }
    }
}

