/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.soap;

import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP11Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP12Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPBinding;
import org.jvnet.wom.impl.extension.Messages;
import org.jvnet.wom.impl.extension.wsdl11.AbstractWSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPOperationImpl;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPOperationExtensionHandler
extends AbstractWSDLExtensionHandler {
    private final QName[] names = new QName[]{SOAP11Constants.SOAPOPERATION_NAME, SOAP12Constants.SOAPOPERATION_NAME};
    private SOAPOperationImpl operation;
    private final ContentHandler contentHandler = new SOAPOperationCH();

    public SOAPOperationExtensionHandler(ErrorHandler errorHandler, EntityResolver entityResolver) {
        super(errorHandler, entityResolver);
    }

    @Override
    protected QName[] getExtensionNames() {
        return this.names;
    }

    @Override
    public Collection<WSDLExtension> getExtensions() {
        return Collections.singleton(this.operation);
    }

    @Override
    public ContentHandler getContentHandlerFor(String nsUri, String localName) {
        if (this.canHandle(nsUri, localName)) {
            return this.contentHandler;
        }
        return null;
    }

    private class SOAPOperationCH
    extends AbstractWSDLExtensionHandler.WSDLExtensibilityContentHandler {
        private SOAPOperationCH() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!SOAPOperationExtensionHandler.this.canHandle(uri, localName)) {
                return;
            }
            String soapAction = atts.getValue("soapAction");
            soapAction = XmlUtil.fixNull(soapAction);
            String soapActionRequiredAtt = XmlUtil.fixNull(atts.getValue("soapActionRequired"));
            boolean soapActionRequired = soapActionRequiredAtt.equals("true") || soapActionRequiredAtt.equals("1");
            soapAction = XmlUtil.fixNull(soapAction);
            String styleattr = XmlUtil.fixNull(atts.getValue("style"));
            SOAPBinding.Style style = null;
            if (styleattr.equals("rpc")) {
                style = SOAPBinding.Style.Rpc;
            } else if (styleattr.equals("document")) {
                style = SOAPBinding.Style.Document;
            } else if (styleattr.length() > 0) {
                SOAPOperationExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("invalid.attr", "style", styleattr, "document or rpc"), this.locator));
            }
            SOAPOperationExtensionHandler.this.operation = new SOAPOperationImpl(new QName(uri, localName));
            SOAPOperationExtensionHandler.this.operation.setSoapAction(soapAction);
            SOAPOperationExtensionHandler.this.operation.setStyle(style);
            SOAPOperationExtensionHandler.this.operation.setSOAPActionRequired(soapActionRequired);
        }
    }
}

