/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.ejb.api.EjbEndpointFacade;
import org.glassfish.server.ServerEnvironmentImpl;
import org.glassfish.webservices.Ejb3MessageDispatcher;
import org.glassfish.webservices.EjbInvokerImpl;
import org.glassfish.webservices.EjbMessageDispatcher;
import org.glassfish.webservices.InstanceResolverImpl;
import org.glassfish.webservices.JAXWSContainer;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.WsUtil;

public class EjbRuntimeEndpointInfo {
    protected Logger logger = LogDomains.getLogger(this.getClass(), (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();
    protected final WebServiceEndpoint endpoint;
    protected final EjbEndpointFacade container;
    protected final Object webServiceEndpointServant;
    private ComponentInvocation inv;
    private ServletAdapter adapter = null;
    private ServletAdapterList adapterList = null;
    private WebServiceContextImpl wsCtxt = null;
    private boolean handlersConfigured = false;
    protected EjbMessageDispatcher messageDispatcher = null;

    public EjbRuntimeEndpointInfo(WebServiceEndpoint webServiceEndpoint, EjbEndpointFacade ejbContainer, Object servant) {
        this.endpoint = webServiceEndpoint;
        this.container = ejbContainer;
        this.webServiceEndpointServant = servant;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getEndpointAddressUri() {
        return this.endpoint.getEndpointAddressUri();
    }

    public WebServiceContext getWebServiceContext() {
        return this.wsCtxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object prepareInvocation(boolean doPreInvoke) throws Exception {
        if (doPreInvoke) {
            this.inv = this.container.startInvocation();
        }
        if (!this.handlersConfigured && doPreInvoke) {
            EjbRuntimeEndpointInfo ejbRuntimeEndpointInfo = this;
            synchronized (ejbRuntimeEndpointInfo) {
                if (!this.handlersConfigured) {
                    try {
                        String urlPattern;
                        WsUtil wsu = new WsUtil();
                        String implClassName = this.endpoint.getEjbComponentImpl().getEjbClassName();
                        Class<?> clazz = this.container.getEndpointClassLoader().loadClass(implClassName);
                        String givenBinding = this.endpoint.getProtocolBinding();
                        SDDocumentSource primaryWsdl = null;
                        Collection docs = null;
                        if (this.endpoint.getWebService().hasWsdlFile()) {
                            WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                            ServerEnvironmentImpl servEnv = wscImpl.getServerEnvironmentImpl();
                            String deployedDir = servEnv.getApplicationRepositoryPath().getAbsolutePath();
                            File pkgedWsdl = null;
                            pkgedWsdl = deployedDir != null ? (this.endpoint.getBundleDescriptor().getApplication().isVirtual() ? new File(deployedDir + File.separator + this.endpoint.getWebService().getWsdlFileUri()) : new File(deployedDir + File.separator + this.endpoint.getBundleDescriptor().getModuleDescriptor().getArchiveUri().replaceAll("\\.", "_") + File.separator + this.endpoint.getWebService().getWsdlFileUri())) : new File(this.endpoint.getWebService().getWsdlFileUrl().getFile());
                            if (pkgedWsdl.exists()) {
                                primaryWsdl = SDDocumentSource.create((URL)pkgedWsdl.toURL());
                                docs = wsu.getWsdlsAndSchemas(pkgedWsdl);
                            }
                        }
                        JAXWSContainer container = new JAXWSContainer(null, this.endpoint);
                        URL catalogURL = null;
                        File catalogFile = new File(this.endpoint.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
                        if (catalogFile.exists()) {
                            catalogURL = catalogFile.toURL();
                        }
                        boolean mtomEnabled = wsu.getMtom(this.endpoint);
                        WSBinding binding = null;
                        if (mtomEnabled) {
                            MTOMFeature mtom = new MTOMFeature(true);
                            binding = BindingID.parse((String)givenBinding).createBinding(new WebServiceFeature[]{mtom});
                        } else {
                            binding = BindingID.parse((String)givenBinding).createBinding();
                        }
                        wsu.configureJAXWSServiceHandlers(this.endpoint, this.endpoint.getProtocolBinding(), binding);
                        Invoker inv = new InstanceResolverImpl(clazz).createInvoker();
                        WSEndpoint wsep = WSEndpoint.create(clazz, (boolean)false, (Invoker)new EjbInvokerImpl(clazz, inv, this.webServiceEndpointServant, this.wsCtxt), (QName)this.endpoint.getServiceName(), (QName)this.endpoint.getWsdlPort(), (Container)container, (WSBinding)binding, (SDDocumentSource)primaryWsdl, (Collection)docs, (URL)catalogURL);
                        String uri = this.endpoint.getEndpointAddressUri();
                        String string = urlPattern = uri.startsWith("/") ? uri : "/" + uri;
                        if (this.adapterList == null) {
                            this.adapterList = new ServletAdapterList();
                        }
                        this.adapter = (ServletAdapter)this.adapterList.createAdapter(this.endpoint.getName(), urlPattern, wsep);
                        this.handlersConfigured = true;
                    }
                    catch (Throwable t) {
                        this.logger.severe("Cannot initialize endpoint " + this.endpoint.getName() + " : error is : " + t.getMessage());
                        t.printStackTrace();
                        this.adapter = null;
                    }
                }
            }
        }
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRuntimeInfo(ServletAdapterList list) throws Exception {
        try {
            this.adapterList = list;
            this.prepareInvocation(true);
        }
        finally {
            this.releaseImplementor();
        }
    }

    public void releaseImplementor() {
        this.container.endInvocation(this.inv);
    }

    public EjbMessageDispatcher getMessageDispatcher() {
        if (this.messageDispatcher == null) {
            this.messageDispatcher = new Ejb3MessageDispatcher();
        }
        return this.messageDispatcher;
    }

    public EjbEndpointFacade getContainer() {
        return this.container;
    }
}

