/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.WebServerInfo;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.xml.bind.api.JAXBRIContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.WebServiceProvider;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.webservices.Import;
import org.glassfish.webservices.WebServicesApplication;
import org.glassfish.webservices.WebServicesContainer;
import org.glassfish.webservices.WsUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebServicesDeployer
implements Deployer<WebServicesContainer, WebServicesApplication> {
    protected Logger logger = LogDomains.getLogger(this.getClass(), (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();
    @Inject
    ServerEnvironment env;
    @Inject
    RequestDispatcher dispatcher;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServicesDeployer.class);

    protected String getModuleType() {
        return "webservices";
    }

    protected void cleanArtifacts(DeploymentContext deploymentContext) throws DeploymentException {
    }

    public boolean prepare(DeploymentContext dc) {
        return true;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        Application app = (Application)dc.getModuleMetaData(Application.class);
        Set bundles = app.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            WebServicesDescriptor wsDesc = bundle.getWebServices();
            for (WebService ws : wsDesc.getWebServices()) {
                File wsdlFile;
                String wsdlFileUri;
                File classesDir;
                File moduleDir = dc.getSourceDir();
                File wsdlDir = dc.getScratchDir("xml");
                wsdlDir.mkdir();
                File stubsDir = dc.getScratchDir("ejb");
                stubsDir.mkdir();
                String webinfLibDir = null;
                if (XModuleType.WAR.equals((Object)bundle.getModuleType())) {
                    classesDir = new File(moduleDir, "WEB-INF" + File.separator + "classes");
                    webinfLibDir = moduleDir.getAbsolutePath() + File.separator + "WEB-INF" + File.separator + "lib";
                } else {
                    if (!XModuleType.EJB.equals((Object)bundle.getModuleType())) continue;
                    classesDir = moduleDir;
                }
                wsdlDir = new File(wsdlDir, bundle.getWsdlDir().replaceAll("/", "\\" + File.separator));
                try {
                    this.checkCatalog(bundle, ws, moduleDir);
                }
                catch (DeploymentException e) {
                    this.logger.log(Level.SEVERE, "Error in resolving the catalog");
                }
                if (ws.hasWsdlFile()) {
                    if (ws.getWsdlFileUri().startsWith("http")) {
                        try {
                            this.downloadWsdlsAndSchemas(new URL(ws.getWsdlFileUri()), wsdlDir);
                        }
                        catch (Exception e) {
                            throw new DeploymentException(e.toString(), (Throwable)e);
                        }
                        wsdlFileUri = ws.getWsdlFileUri().substring(ws.getWsdlFileUri().lastIndexOf("/") + 1);
                        wsdlFile = new File(wsdlDir, wsdlFileUri);
                    } else {
                        wsdlFileUri = ws.getWsdlFileUri();
                        wsdlFile = wsdlFileUri.startsWith("/") ? new File(wsdlFileUri) : new File(moduleDir, wsdlFileUri);
                        if (!wsdlFile.exists()) {
                            String errorMessage = this.format(this.rb.getString("wsdl.notfound"), ws.getWsdlFileUri(), bundle.getModuleDescriptor().getArchiveUri());
                            this.logger.severe(errorMessage);
                            throw new DeploymentException(errorMessage);
                        }
                    }
                } else {
                    wsdlFileUri = JAXBRIContext.mangleNameToClassName((String)ws.getName()) + ".wsdl";
                    wsdlDir.mkdirs();
                    wsdlFile = new File(wsdlDir, wsdlFileUri);
                }
                for (WebServiceEndpoint endpoint : ws.getEndpoints()) {
                    Class<?> implClass;
                    boolean jaxwsEndPtFound = false;
                    boolean jaxrpcEndPtFound = false;
                    String implClassName = endpoint.implementedByEjbComponent() ? endpoint.getEjbComponentImpl().getEjbClassName() : endpoint.getWebComponentImpl().getWebComponentImplementation();
                    try {
                        implClass = dc.getClassLoader().loadClass(implClassName);
                    }
                    catch (Exception e) {
                        throw new DeploymentException(this.format(this.rb.getString("impl.notfound"), ws.getName(), implClassName, bundle.getModuleDescriptor().getArchiveUri()));
                    }
                    if (implClass == null) continue;
                    if (implClass.getAnnotation(WebServiceProvider.class) != null) {
                        if (jaxrpcEndPtFound) {
                            throw new DeploymentException(this.format(this.rb.getString("jaxws-jaxrpc.error"), ws.getName()));
                        }
                        jaxwsEndPtFound = true;
                        continue;
                    }
                    if (implClass.getAnnotation(javax.jws.WebService.class) != null) {
                        if (jaxrpcEndPtFound) {
                            throw new DeploymentException(this.format(this.rb.getString("jaxws-jaxrpc.error"), ws.getName()));
                        }
                        jaxwsEndPtFound = true;
                        QName servicename = endpoint.getServiceName();
                        Thread.currentThread().setContextClassLoader(dc.getClassLoader());
                        continue;
                    }
                    if (jaxwsEndPtFound) {
                        throw new DeploymentException(this.format(this.rb.getString("jaxws-jaxrpc.error"), ws.getName()));
                    }
                    jaxrpcEndPtFound = true;
                    ws.getWebServicesDescriptor().setSpecVersion("1.1");
                }
            }
        }
    }

    public Object loadMetaData(Class type, DeploymentContext dc) {
        try {
            dc.getScratchDir("ejb").mkdirs();
            Application app = (Application)dc.getModuleMetaData(Application.class);
            if (app == null) {
                this.logger.severe(this.format(this.rb.getString("failed.loading.dd"), "foo", "bar"));
                return false;
            }
            if (!(app.getStandaloneBundleDescriptor() instanceof WebBundleDescriptor) || app.getStandaloneBundleDescriptor().getSpecVersion().equals("2.5") && app.getStandaloneBundleDescriptor().hasWebServices()) {
                this.generateArtifacts(dc);
                this.doWebServicesDeployment(app, dc);
            }
            return new Boolean(true);
        }
        catch (Exception ex) {
            RuntimeException re = new RuntimeException(ex.getMessage());
            re.initCause(ex);
            throw re;
        }
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    private void downloadWsdlsAndSchemas(URL httpUrl, File wsdlDir) throws Exception {
        wsdlDir.mkdirs();
        String fileName = httpUrl.toString().substring(httpUrl.toString().lastIndexOf("/") + 1);
        File toFile = new File(wsdlDir.getAbsolutePath() + File.separator + fileName);
        this.downloadFile(httpUrl, toFile);
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaIncludes = new HashSet();
        this.parseRelativeImports(httpUrl, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        String urlWithoutFileName = httpUrl.toString().substring(0, httpUrl.toString().lastIndexOf("/"));
        for (Import next : schemaRelativeImports) {
            String location = next.getLocation();
            if ((location = location.replaceAll("/", "\\" + File.separator)).lastIndexOf(File.separator) != -1) {
                File newDir = new File(wsdlDir.getAbsolutePath() + File.separator + location.substring(0, location.lastIndexOf(File.separator)));
                newDir.mkdirs();
            }
            this.downloadFile(new URL(urlWithoutFileName + "/" + next.getLocation()), new File(wsdlDir.getAbsolutePath() + File.separator + location));
        }
        for (Import next : wsdlRelativeImports) {
            String newWsdlLocation = next.getLocation();
            File newWsdlDir = (newWsdlLocation = newWsdlLocation.replaceAll("/", "\\" + File.separator)).lastIndexOf(File.separator) != -1 ? new File(wsdlDir.getAbsolutePath() + File.separator + newWsdlLocation.substring(0, newWsdlLocation.lastIndexOf(File.separator))) : wsdlDir;
            this.downloadWsdlsAndSchemas(new URL(urlWithoutFileName + "/" + next.getLocation()), newWsdlDir);
        }
    }

    private void checkCatalog(BundleDescriptor bundle, WebService ws, File moduleDir) throws DeploymentException {
        File catalogFile = new File(moduleDir, bundle.getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
        if (!catalogFile.exists()) {
            return;
        }
        this.resolveCatalog(catalogFile, ws.getWsdlFileUri(), ws);
    }

    public URL resolveCatalog(File catalogFile, String wsdlFile, WebService ws) throws DeploymentException {
        try {
            URL retVal = null;
            EntityResolver resolver = XmlUtil.createEntityResolver((URL)catalogFile.toURL());
            InputSource source = resolver.resolveEntity(null, wsdlFile);
            if (source != null) {
                String mappedEntry = source.getSystemId();
                if (mappedEntry.startsWith("file:")) {
                    File f = new File(mappedEntry.substring(mappedEntry.indexOf(":") + 1));
                    if (!f.exists()) {
                        throw new DeploymentException(this.format(this.rb.getString("catalog.resolver.error"), mappedEntry));
                    }
                    retVal = f.toURI().toURL();
                    if (ws != null) {
                        ws.setWsdlFileUri(f.getAbsolutePath());
                        ws.setWsdlFileUrl(retVal);
                    }
                } else if (mappedEntry.startsWith("http")) {
                    retVal = new URL(mappedEntry);
                    if (ws != null) {
                        ws.setWsdlFileUrl(retVal);
                    }
                }
            }
            return retVal;
        }
        catch (Throwable t) {
            throw new DeploymentException(this.format(this.rb.getString("catalog.error"), t.getMessage(), catalogFile.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(URL httpUrl, File toFile) throws Exception {
        InputStream is = null;
        OutputStream os = null;
        try {
            int readCount;
            if (!toFile.createNewFile()) {
                throw new Exception(localStrings.getLocalString("filecreation.error", "Unable to create new File", new Object[]{toFile.getAbsolutePath()}));
            }
            is = httpUrl.openStream();
            os = new FileOutputStream(toFile, true);
            byte[] buffer = new byte[10240];
            while ((readCount = is.read(buffer, 0, 10240)) != -1) {
                ((FileOutputStream)os).write(buffer, 0, readCount);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.flush();
                ((FileOutputStream)os).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseRelativeImports(URL wsdlFileUrl, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        InputStream is = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = wsdlFileUrl.openStream();
            Document document = builder.parse(is);
            this.procesSchemaImports(document, schemaRelativeImports);
            this.procesWsdlImports(document, wsdlRelativeImports);
            this.procesSchemaIncludes(document, schemaIncludes);
            this.procesWsdlIncludes(document, wsdlIncludes);
        }
        catch (SAXParseException spe) {
            this.logger.severe(this.format(this.rb.getString("parsing.error"), "" + spe.getLineNumber(), spe.getSystemId()));
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (Exception sxe) {
            this.logger.severe(this.format(this.rb.getString("wsdl.parsing.error"), sxe.getMessage()));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException io) {
                this.logger.fine(io.getMessage());
            }
        }
    }

    private void procesSchemaImports(Document document, Collection schemaImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaImports = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        this.addImportsAndIncludes(schemaImports, schemaImportCollection, "namespace", "schemaLocation");
    }

    private void procesWsdlImports(Document document, Collection wsdlImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlImports = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        this.addImportsAndIncludes(wsdlImports, wsdlImportCollection, "namespace", "location");
    }

    private void procesSchemaIncludes(Document document, Collection schemaIncludeCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaIncludes = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        this.addImportsAndIncludes(schemaIncludes, schemaIncludeCollection, null, "schemaLocation");
    }

    private void procesWsdlIncludes(Document document, Collection wsdlIncludesCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlIncludes = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "include");
        this.addImportsAndIncludes(wsdlIncludes, wsdlIncludesCollection, null, "location");
    }

    private void addImportsAndIncludes(NodeList list, Collection result, String namespace, String location) throws SAXException, ParserConfigurationException, IOException {
        for (int i = 0; i < list.getLength(); ++i) {
            String givenLocation = null;
            Node element = list.item(i);
            NamedNodeMap attrs = element.getAttributes();
            Node n = attrs.getNamedItem(location);
            if (n != null) {
                givenLocation = n.getNodeValue();
            }
            if (givenLocation == null || givenLocation != null && givenLocation.startsWith("http")) continue;
            Import imp = new Import();
            imp.setLocation(givenLocation);
            if (namespace != null && (n = attrs.getNamedItem(namespace)) != null) {
                imp.setNamespace(n.getNodeValue());
            }
            result.add(imp);
        }
    }

    public void doWebServicesDeployment(Application app, DeploymentContext dc) throws Exception {
        HashSet webBundles = new HashSet();
        HashSet webServices = new HashSet();
        webBundles.addAll(app.getWebBundleDescriptors());
        webServices.addAll(app.getWebServiceDescriptors());
        if (dc.getAppProps().get("context-root") != null && app.isVirtual()) {
            String contextRoot = (String)dc.getAppProps().get("context-root");
            ((WebBundleDescriptor)webBundles.iterator().next()).setContextRoot(contextRoot);
        }
        Iterator iter = webBundles.iterator();
        while (iter.hasNext()) {
            this.doWebServiceDeployment((WebBundleDescriptor)iter.next());
        }
        iter = webServices.iterator();
        while (iter.hasNext()) {
            WsUtil wsUtil = new WsUtil();
            WebService next = (WebService)iter.next();
            if (next.getWsdlFileUrl() == null && next.getMappingFileUri() == null) {
                for (WebServiceEndpoint wsep : next.getEndpoints()) {
                    wsep.composeFinalWsdlUrl(wsUtil.getWebServerInfo().getWebServerRootURL(wsep.isSecure()));
                }
                continue;
            }
            URL clientPublishLocation = next.getClientPublishUrl();
            URL url = next.getWsdlFileUrl();
            File genXmlDir = dc.getScratchDir("xml");
        }
    }

    public void doWebServiceDeployment(WebBundleDescriptor web) throws DeploymentException, MalformedURLException {
        Collection endpoints = web.getWebServices().getEndpoints();
        for (WebServiceEndpoint nextEndpoint : endpoints) {
            WebComponentDescriptor webComp = nextEndpoint.getWebComponentImpl();
            if (!nextEndpoint.hasServletImplClass()) {
                throw new DeploymentException(this.format(this.rb.getString("enterprise.deployment.backend.cannot_find_servlet"), nextEndpoint.getEndpointName()));
            }
            String containerServlet = "org.glassfish.webservices.JAXWSServlet";
            webComp.setWebComponentImplementation(containerServlet);
            WebServerInfo wsi = new WsUtil().getWebServerInfo();
            URL rootURL = wsi.getWebServerRootURL(nextEndpoint.isSecure());
            URL actualAddress = nextEndpoint.composeEndpointAddress(rootURL);
            this.logger.info(this.format(this.rb.getString("enterprise.deployment.endpoint.registration"), nextEndpoint.getEndpointName(), actualAddress.toString()));
        }
    }

    private String format(String key, String ... values) {
        return MessageFormat.format(key, values);
    }

    public static void moveFile(String sourceFile, String destFile) throws IOException {
        FileUtils.copy((String)sourceFile, (String)destFile);
        new File(sourceFile).delete();
    }

    public void unload(WebServicesApplication container, DeploymentContext context) {
    }

    public void clean(DeploymentContext context) {
    }

    public WebServicesApplication load(WebServicesContainer container, DeploymentContext context) {
        return new WebServicesApplication(context, this.env, this.dispatcher);
    }
}

