/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.runtime.AbstractResponseHandler;
import com.sun.xml.ws.rx.mc.runtime.MakeConnectionSenderTask;
import com.sun.xml.ws.rx.mc.runtime.OneWayMepHandler;
import com.sun.xml.ws.rx.mc.runtime.RequestResponseMepHandler;
import com.sun.xml.ws.rx.mc.runtime.spi.ProtocolMessageHandler;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.ScheduledTaskManager;
import com.sun.xml.ws.rx.util.TimestampedCollection;
import java.util.UUID;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;

public class McClientTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(McClientTube.class);
    private final RxConfiguration configuration;
    private final Unmarshaller unmarshaller;
    private final Header wsmcAnnonymousReplyToHeader;
    private final Header wsmcAnnonymousFaultToHeader;
    private final Communicator communicator;
    private final ScheduledTaskManager scheduler;
    private final TimestampedCollection<String, Fiber> suspendedFiberStorage;
    private final MakeConnectionSenderTask mcSenderTask;
    private final WSEndpointReference wsmcAnonymousEndpointReference;

    McClientTube(RxConfiguration configuration, Tube tubelineHead, EndpointAddress endpointAddress) throws RxRuntimeException {
        super(tubelineHead);
        this.configuration = configuration;
        this.unmarshaller = configuration.getMcVersion().getUnmarshaller(configuration.getAddressingVersion());
        this.communicator = new Communicator("McClientTubeCommunicator", endpointAddress, tubelineHead, null, configuration.getAddressingVersion(), configuration.getSoapVersion(), configuration.getMcVersion().getJaxbContext(configuration.getAddressingVersion()));
        String wsmcAnonymousAddress = configuration.getMcVersion().getWsmcAnonymousAddress(UUID.randomUUID().toString());
        this.wsmcAnonymousEndpointReference = new WSEndpointReference(wsmcAnonymousAddress, configuration.getAddressingVersion());
        this.wsmcAnnonymousReplyToHeader = this.wsmcAnonymousEndpointReference.createHeader(configuration.getAddressingVersion().replyToTag);
        this.wsmcAnnonymousFaultToHeader = this.wsmcAnonymousEndpointReference.createHeader(configuration.getAddressingVersion().faultToTag);
        this.suspendedFiberStorage = new TimestampedCollection();
        this.mcSenderTask = new MakeConnectionSenderTask(this.communicator, this.suspendedFiberStorage, wsmcAnonymousAddress, this.wsmcAnnonymousReplyToHeader, this.wsmcAnnonymousFaultToHeader, configuration);
        this.scheduler = new ScheduledTaskManager();
        this.scheduler.startTask(this.mcSenderTask, 2000L, 500L);
    }

    McClientTube(McClientTube original, TubeCloner cloner) {
        super(original, cloner);
        this.configuration = original.configuration;
        this.unmarshaller = this.configuration.getMcVersion().getUnmarshaller(this.configuration.getAddressingVersion());
        this.wsmcAnnonymousReplyToHeader = original.wsmcAnnonymousReplyToHeader;
        this.wsmcAnnonymousFaultToHeader = original.wsmcAnnonymousFaultToHeader;
        this.communicator = original.communicator;
        this.suspendedFiberStorage = original.suspendedFiberStorage;
        this.scheduler = original.scheduler;
        this.mcSenderTask = original.mcSenderTask;
        this.wsmcAnonymousEndpointReference = original.wsmcAnonymousEndpointReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTubeImpl copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            McClientTube mcClientTube = new McClientTube(this, cloner);
            return mcClientTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    public NextAction processRequest(Packet request) {
        Message message = request.getMessage();
        if (!message.hasHeaders()) {
            throw LOGGER.logSevereException(new RxRuntimeException("Required WS-Addressing headers not found: No SOAP headers present on a client request message."));
        }
        if (this.needToSetWsmcAnnonymousHeaders(request)) {
            McClientTube.setMcAnnonymousHeaders(message.getHeaders(), this.configuration.getAddressingVersion(), this.wsmcAnnonymousReplyToHeader, this.wsmcAnnonymousFaultToHeader);
            String correlationId = message.getID(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion());
            AbstractResponseHandler responseHandler = request.expectReply != null && request.expectReply != false ? new RequestResponseMepHandler(this.configuration, this.mcSenderTask, this.suspendedFiberStorage, correlationId) : new OneWayMepHandler(this.configuration, this.mcSenderTask, this.suspendedFiberStorage, correlationId);
            this.suspendedFiberStorage.register(correlationId, Fiber.current());
            this.communicator.sendAsync(request, responseHandler);
            return super.doSuspend();
        }
        return super.processRequest(request);
    }

    public NextAction processResponse(Packet response) {
        return super.processResponse(response);
    }

    public NextAction processException(Throwable t) {
        return super.processException(t);
    }

    public void preDestroy() {
        this.scheduler.stopAll();
        super.preDestroy();
    }

    public final WSEndpointReference getWsmcAnonymousEndpointReference() {
        return this.wsmcAnonymousEndpointReference;
    }

    public final void registerProtocolResponseHandler(ProtocolMessageHandler handler) {
        this.mcSenderTask.register(handler);
    }

    private boolean needToSetWsmcAnnonymousHeaders(Packet request) {
        Header replyToHeader = request.getMessage().getHeaders().get(this.configuration.getAddressingVersion().replyToTag, false);
        if (replyToHeader != null) {
            try {
                return replyToHeader.readAsEPR(this.configuration.getAddressingVersion()).isAnonymous();
            }
            catch (XMLStreamException ex) {
                throw LOGGER.logSevereException(new RxRuntimeException("Error unmarshalling content of WS-A ReplyTo header", ex));
            }
        }
        return this.isBooleanFlagSet(request, RxConfiguration.ACK_REQUESTED_HEADER_SET);
    }

    static void setMcAnnonymousHeaders(HeaderList headers, AddressingVersion av, Header wsmcReplyToHeader, Header wsmcFaultToHeader) {
        headers.remove(av.replyToTag);
        headers.add(wsmcReplyToHeader);
        if (headers.remove(av.faultToTag) != null) {
            headers.add(wsmcFaultToHeader);
        }
    }

    private Boolean isBooleanFlagSet(Packet packet, Object flag) {
        Boolean value = (Boolean)Boolean.class.cast(packet.invocationProperties.get(flag));
        return value != null && value != false;
    }
}

