/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import javax.xml.namespace.QName;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.impl.WSDLFaultImpl;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.jvnet.wom.impl.parser.handler.Messages;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Fault
extends AbstractHandler {
    private WSDLContentHandlerEx runtime;
    private String expectedNS;
    private WSDLFaultImpl fault;

    public Fault(AbstractHandler parent, WSDLEventSource source, WSDLContentHandlerEx runtime, int cookie, String expectedNamespace) {
        super(source, parent, cookie);
        this.runtime = runtime;
        this.expectedNS = expectedNamespace;
    }

    protected Fault(WSDLEventSource source, AbstractHandler parent, int parentCookie) {
        super(source, parent, parentCookie);
    }

    protected WSDLContentHandlerEx getRuntime() {
        return this.runtime;
    }

    protected void onChildCompleted(Object result, int cookie, boolean needAttCheck) throws SAXException {
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("fault")) {
            this.runtime.onEnterElementConsumed(uri, localName, qname, atts);
            Attributes test = this.runtime.getCurrentAttributes();
            this.processAttributes(test);
        } else {
            super.enterElement(uri, localName, qname, atts);
        }
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("fault")) {
            this.endProcessingExtentionElement(this.fault);
            this.revertToParentFromLeaveElement(this.fault, this._cookie, uri, localName, qname);
            this.fault.setDocumentation(this.getWSDLDocumentation());
        }
    }

    private void processAttributes(Attributes test) throws SAXException {
        int[] validattrs = new int[test.getLength()];
        String name = XmlUtil.fixNull(test.getValue("name"));
        int index = test.getIndex("name");
        if (index >= 0) {
            validattrs[index] = 1;
        }
        if (name.equals("")) {
            this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.missingName", "wsdl:fault", name), this.runtime.getLocator()));
        }
        this.fault = new WSDLFaultImpl(this.runtime.getLocator(), new QName(this.runtime.currentWSDL.getName().getNamespaceURI(), name), this.runtime.document);
        index = test.getIndex("message");
        if (index >= 0) {
            validattrs[index] = 1;
            String qname = test.getValue(index);
            String uri = this.runtime.resolveNamespacePrefix(XmlUtil.getPrefix(qname));
            String localname = XmlUtil.getLocalPart(qname);
            QName messageName = new QName(uri, localname);
            if (uri == null || localname == null) {
                this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.invalidMessageDescriptor", qname, name), this.runtime.getLocator()));
            }
            this.fault.setMessage(messageName);
        }
        this.validateAttribute(this.runtime.getErrorHandler(), test, validattrs);
    }
}

