/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import java.math.BigInteger;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;

public class IssuerNameAndSerialCertSelector
implements CertSelector {
    private final BigInteger serialNumber;
    private final String issuerName;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public IssuerNameAndSerialCertSelector(BigInteger serialNum, String issuer) {
        this.serialNumber = serialNum;
        this.issuerName = issuer;
    }

    public boolean match(Certificate cert) {
        return cert instanceof X509Certificate && this.matchesIssuerSerialAndName(this.serialNumber, this.issuerName, (X509Certificate)cert);
    }

    public Object clone() {
        return new IssuerNameAndSerialCertSelector(this.serialNumber, this.issuerName);
    }

    private boolean matchesIssuerSerialAndName(BigInteger serialNumberMatch, String issuerNameMatch, X509Certificate x509Cert) {
        BigInteger serialNumber = x509Cert.getSerialNumber();
        String issuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
        return serialNumber.equals(serialNumberMatch) && issuerName.equals(issuerNameMatch);
    }
}

