/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.typelib;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.glassfish.gmbal.generic.Algorithms;
import org.glassfish.gmbal.generic.Display;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.generic.UnaryFunction;
import org.glassfish.gmbal.typelib.DeclarationFactory;
import org.glassfish.gmbal.typelib.EvaluatedArrayType;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;

public class TypeEvaluator {
    private static boolean DEBUG = false;
    private static boolean DEBUG_EVALUATE = false;
    private static final DprintUtil dputil = DEBUG || DEBUG_EVALUATE ? new DprintUtil(TypeEvaluator.class) : null;
    private static Map<EvalMapKey, EvaluatedClassDeclaration> evalClassMap = new HashMap<EvalMapKey, EvaluatedClassDeclaration>();
    private static List<EvaluatedType> emptyETList = new ArrayList<EvaluatedType>(0);

    private static EvaluatedClassDeclaration getECD(Class cls) {
        return DeclarationFactory.ecdecl(1, cls.getName(), cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapPut(EvaluatedClassDeclaration ecd, Class cls) {
        if (DEBUG) {
            dputil.enter("mapPut", "ecd", ecd, "cls", cls);
        }
        try {
            EvalMapKey key = new EvalMapKey(cls, emptyETList);
            evalClassMap.put(key, ecd);
        }
        finally {
            if (DEBUG) {
                dputil.exit();
            }
        }
    }

    public static void dumpEvalClassMap() {
        System.out.println("TypeEvaluator: dumping eval class map");
        int numSystem = 0;
        int total = 0;
        for (Map.Entry<EvalMapKey, EvaluatedClassDeclaration> entry : evalClassMap.entrySet()) {
            System.out.println("\tKey:" + entry.getKey() + "=>");
            System.out.println("\t\t" + entry.getValue());
            String name = ((Class)entry.getKey().first()).getName();
            if (!name.startsWith("org.glassfish.gmbal")) {
                ++numSystem;
            }
            ++total;
        }
        System.out.printf("\nEvalClassMap contains %d entries, %d of which are system classes\n", total, numSystem);
    }

    public static synchronized EvaluatedType getEvaluatedType(Class cls) {
        TypeEvaluationVisitor visitor = new TypeEvaluationVisitor();
        EvaluatedType etype = visitor.evaluateType(cls);
        return etype;
    }

    static {
        try {
            Class[] classes = new Class[]{Void.TYPE, Integer.class, Byte.class, Character.class, Short.class, Boolean.class, Float.class, Double.class, Long.class, BigDecimal.class, BigInteger.class, Date.class, ObjectName.class, Class.class, Number.class};
            Class<Object> objectClass = Object.class;
            Class<String> stringClass = String.class;
            Class<Void> voidClass = Void.class;
            Method toStringMethod = objectClass.getDeclaredMethod("toString", new Class[0]);
            EvaluatedClassDeclaration objectECD = TypeEvaluator.getECD(objectClass);
            EvaluatedClassDeclaration voidECD = TypeEvaluator.getECD(voidClass);
            EvaluatedClassDeclaration stringECD = TypeEvaluator.getECD(stringClass);
            EvaluatedMethodDeclaration toStringEMD = DeclarationFactory.emdecl(objectECD, 1, stringECD, "toString", emptyETList, toStringMethod);
            List<EvaluatedMethodDeclaration> toStringList = Algorithms.list(toStringEMD);
            List<EvaluatedClassDeclaration> objectList = Algorithms.list(objectECD);
            voidECD.inheritance(objectList);
            voidECD.freeze();
            objectECD.methods(toStringList);
            objectECD.freeze();
            stringECD.inheritance(objectList);
            stringECD.freeze();
            TypeEvaluator.mapPut(voidECD, voidClass);
            TypeEvaluator.mapPut(objectECD, objectClass);
            TypeEvaluator.mapPut(stringECD, stringClass);
            for (Class cls : classes) {
                EvaluatedClassDeclaration ecd = TypeEvaluator.getECD(cls);
                ecd.inheritance(objectList);
                ecd.freeze();
                TypeEvaluator.mapPut(ecd, cls);
            }
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EvalMapKey
    extends Pair<Class<?>, List<EvaluatedType>> {
        public static EvalMapKey OBJECT_KEY = new EvalMapKey(Object.class, (List<EvaluatedType>)new ArrayList<EvaluatedType>(0));

        public EvalMapKey(Class<?> cls, List<EvaluatedType> decls) {
            super(cls, decls);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeEvaluationVisitor {
        private final Display<String, EvaluatedType> display = new Display();
        private final Map<Class<?>, EvaluatedClassDeclaration> partialDefinitions = new HashMap();

        public EvaluatedType evaluateType(Object type) {
            if (DEBUG || DEBUG_EVALUATE) {
                dputil.enter("evaluateType", "type=", type);
            }
            try {
                if (type == null) {
                    EvaluatedType evaluatedType = null;
                    return evaluatedType;
                }
                if (type instanceof Class) {
                    Class cls = (Class)type;
                    EvaluatedType evaluatedType = this.visitClassDeclaration(cls);
                    return evaluatedType;
                }
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    EvaluatedType evaluatedType = this.visitParameterizedType(pt);
                    return evaluatedType;
                }
                if (type instanceof TypeVariable) {
                    TypeVariable tvar = (TypeVariable)type;
                    EvaluatedType evaluatedType = this.visitTypeVariable(tvar);
                    return evaluatedType;
                }
                if (type instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)type;
                    EvaluatedType evaluatedType = this.visitGenericArrayType(gat);
                    return evaluatedType;
                }
                if (type instanceof WildcardType) {
                    WildcardType wt = (WildcardType)type;
                    EvaluatedType evaluatedType = this.visitWildcardType(wt);
                    return evaluatedType;
                }
                if (type instanceof Method) {
                    throw new IllegalArgumentException("evaluateType should not be called with a Method (" + type + ")");
                }
                throw new IllegalArgumentException("Unknown type???" + type);
            }
            finally {
                if (DEBUG || DEBUG_EVALUATE) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitClassDeclaration(Class decl) {
            if (DEBUG) {
                dputil.enter("visitClassDeclaration", "decl=", decl);
            }
            try {
                if (decl.isArray()) {
                    if (DEBUG) {
                        dputil.info("decl is an array");
                    }
                    EvaluatedArrayType evaluatedArrayType = DeclarationFactory.egat(this.evaluateType(decl.getComponentType()));
                    return evaluatedArrayType;
                }
                EvaluatedType result = this.partialDefinitions.get(decl);
                if (result == null) {
                    EvaluatedClassDeclaration newDecl = DeclarationFactory.ecdecl(decl.getModifiers(), decl.getName(), decl);
                    this.partialDefinitions.put(decl, newDecl);
                    try {
                        OrderedResult<String, EvaluatedType> bindings = this.getBindings(decl);
                        result = this.getCorrectDeclaration(bindings, decl, newDecl);
                    }
                    finally {
                        this.partialDefinitions.remove(decl);
                    }
                } else if (DEBUG) {
                    dputil.info("found result=" + result);
                }
                EvaluatedType evaluatedType = result;
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitParameterizedType(ParameterizedType pt) {
            if (DEBUG) {
                dputil.enter("visitParameterizedType", "pt=", pt);
            }
            Class decl = (Class)pt.getRawType();
            try {
                EvaluatedType result = this.partialDefinitions.get(decl);
                if (result == null) {
                    EvaluatedClassDeclaration newDecl = DeclarationFactory.ecdecl(decl.getModifiers(), decl.getName(), decl);
                    this.partialDefinitions.put(decl, newDecl);
                    try {
                        OrderedResult<String, EvaluatedType> bindings = this.getBindings(pt);
                        result = this.getCorrectDeclaration(bindings, decl, newDecl);
                    }
                    finally {
                        this.partialDefinitions.remove(decl);
                    }
                }
                EvaluatedType evaluatedType = result;
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedMethodDeclaration visitMethodDeclaration(EvaluatedClassDeclaration cdecl, Method mdecl) {
            if (DEBUG) {
                dputil.enter("visitMethodDeclaration", "cdecl=", cdecl, "mdecl=", mdecl);
            }
            try {
                List<EvaluatedType> eptypes = Algorithms.map(Arrays.asList(mdecl.getGenericParameterTypes()), new UnaryFunction<Type, EvaluatedType>(){

                    @Override
                    public EvaluatedType evaluate(Type type) {
                        return TypeEvaluationVisitor.this.evaluateType(type);
                    }
                });
                if (DEBUG) {
                    dputil.info("eptypes=" + eptypes);
                }
                if (mdecl.getName().equals("getThing") && DEBUG) {
                    dputil.info("processing getThing method from test");
                }
                EvaluatedMethodDeclaration result = DeclarationFactory.emdecl(cdecl, mdecl.getModifiers(), this.evaluateType(mdecl.getGenericReturnType()), mdecl.getName(), eptypes, mdecl);
                if (DEBUG) {
                    dputil.info("result=" + result);
                }
                EvaluatedMethodDeclaration evaluatedMethodDeclaration = result;
                return evaluatedMethodDeclaration;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitTypeVariable(TypeVariable tvar) {
            if (DEBUG) {
                dputil.enter("visitTypeVariable", new Object[0]);
            }
            try {
                EvaluatedType evaluatedType = this.lookup(tvar);
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitGenericArrayType(GenericArrayType at) {
            if (DEBUG) {
                dputil.enter("visitTypeVariable", new Object[0]);
            }
            try {
                EvaluatedArrayType evaluatedArrayType = DeclarationFactory.egat(this.evaluateType(at.getGenericComponentType()));
                return evaluatedArrayType;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitWildcardType(WildcardType wt) {
            if (DEBUG) {
                dputil.enter("visitTypeVariable", new Object[0]);
            }
            try {
                EvaluatedType result;
                List<Type> ub = Arrays.asList(wt.getUpperBounds());
                if (ub.size() > 0) {
                    if (ub.size() > 1) {
                        throw new UnsupportedOperationException("Not supported");
                    }
                    result = this.evaluateType(ub.get(0));
                } else {
                    result = EvaluatedType.EOBJECT;
                }
                EvaluatedClassDeclaration evaluatedClassDeclaration = result;
                return evaluatedClassDeclaration;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType lookup(TypeVariable tvar) {
            if (DEBUG) {
                dputil.enter("lookup", "tvar=", tvar);
            }
            try {
                EvaluatedType result = this.display.lookup(tvar.getName());
                if (result == null) {
                    Type[] bounds;
                    if (DEBUG) {
                        dputil.info("tvar not found in display");
                    }
                    if ((bounds = tvar.getBounds()).length > 0) {
                        if (bounds.length > 1) {
                            throw new UnsupportedOperationException("Not supported");
                        }
                        result = this.evaluateType(bounds[0]);
                    } else {
                        result = EvaluatedType.EOBJECT;
                    }
                }
                if (DEBUG) {
                    dputil.info("result=" + result);
                }
                EvaluatedType evaluatedType = result;
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType getCorrectDeclaration(OrderedResult<String, EvaluatedType> bindings, Class decl, EvaluatedClassDeclaration newDecl) {
            if (DEBUG) {
                dputil.enter("getCorrectDeclaration", "decl=", decl);
            }
            try {
                EvaluatedType result;
                List<EvaluatedType> blist = bindings.getList();
                EvalMapKey key = new EvalMapKey(decl, blist);
                if (blist.size() > 0) {
                    newDecl.instantiations(blist);
                }
                if ((result = (EvaluatedType)evalClassMap.get(key)) == null) {
                    if (DEBUG) {
                        dputil.info("No result in evalClassMap");
                    }
                    evalClassMap.put(key, newDecl);
                    this.processClass(newDecl, bindings.getMap(), decl);
                    result = newDecl;
                } else if (DEBUG) {
                    dputil.info("Found result in evalClassMap", "result=", result);
                }
                EvaluatedType evaluatedType = result;
                return evaluatedType;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processClass(final EvaluatedClassDeclaration newDecl, Map<String, EvaluatedType> bindings, Class decl) {
            if (DEBUG) {
                dputil.enter("processClass", "bindings=", bindings, "decl=", decl);
            }
            this.display.enterScope();
            this.display.bind(bindings);
            try {
                List<EvaluatedClassDeclaration> inheritance = Algorithms.map(this.getInheritance(decl), new UnaryFunction<Type, EvaluatedClassDeclaration>(){

                    @Override
                    public EvaluatedClassDeclaration evaluate(Type pt) {
                        return (EvaluatedClassDeclaration)TypeEvaluationVisitor.this.evaluateType(pt);
                    }
                });
                if (DEBUG) {
                    dputil.info("inheritance=" + inheritance);
                }
                newDecl.inheritance(inheritance);
                if (DEBUG) {
                    dputil.info("newDecl=" + newDecl);
                }
                List<EvaluatedMethodDeclaration> newMethods = Algorithms.map(Arrays.asList(decl.getDeclaredMethods()), new UnaryFunction<Method, EvaluatedMethodDeclaration>(){

                    @Override
                    public EvaluatedMethodDeclaration evaluate(Method md) {
                        return TypeEvaluationVisitor.this.visitMethodDeclaration(newDecl, md);
                    }
                });
                newDecl.methods(newMethods);
                newDecl.freeze();
            }
            finally {
                this.display.exitScope();
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Type> getInheritance(Class cls) {
            if (DEBUG) {
                dputil.enter("getInheritance", "cls=", cls);
            }
            try {
                ArrayList<Type> result = new ArrayList<Type>(0);
                result.add(cls.getGenericSuperclass());
                result.addAll(Arrays.asList(cls.getGenericInterfaces()));
                if (DEBUG) {
                    dputil.info("result=" + result);
                }
                ArrayList<Type> arrayList = result;
                return arrayList;
            }
            finally {
                if (DEBUG) {
                    dputil.exit();
                }
            }
        }

        private OrderedResult<String, EvaluatedType> getBindings(Class decl) {
            OrderedResult<String, EvaluatedType> result = new OrderedResult<String, EvaluatedType>();
            for (TypeVariable tv : decl.getTypeParameters()) {
                EvaluatedType res = this.lookup(tv);
                result.add(tv.getName(), res);
            }
            return result;
        }

        private OrderedResult<String, EvaluatedType> getBindings(ParameterizedType pt) {
            OrderedResult<String, EvaluatedType> result = new OrderedResult<String, EvaluatedType>();
            Iterator<Type> types = Arrays.asList(pt.getActualTypeArguments()).iterator();
            Iterator tvars = Arrays.asList(((Class)pt.getRawType()).getTypeParameters()).iterator();
            while (types.hasNext() && tvars.hasNext()) {
                Type type = types.next();
                TypeVariable tvar = tvars.next();
                result.add(tvar.getName(), this.evaluateType(type));
            }
            if (types.hasNext() != tvars.hasNext()) {
                throw new IllegalArgumentException("Type list and TypeVariable list are not the same length");
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class OrderedResult<K, V> {
            private List<V> list = new ArrayList<V>(0);
            private Map<K, V> map = new HashMap();

            public List<V> getList() {
                return this.list;
            }

            public Map<K, V> getMap() {
                return this.map;
            }

            public void add(K key, V value) {
                this.list.add(value);
                this.map.put(key, value);
            }
        }
    }
}

