/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.grizzly.tcp.Adapter;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.webservices.EjbWSAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServicesApplication
implements ApplicationContainer {
    private Collection<String> contextRoots;
    private Adapter adapter;
    private final RequestDispatcher dispatcher;
    private final ServerEnvironment serverEnvironment;
    private DeploymentContext deploymentCtx;
    protected Logger logger = LogDomains.getLogger(this.getClass(), (String)"javax.enterprise.webservices");

    public WebServicesApplication(DeploymentContext context, ServerEnvironment env, RequestDispatcher dispatcherString) {
        this.deploymentCtx = context;
        this.dispatcher = dispatcherString;
        this.serverEnvironment = env;
        this.contextRoots = this.getContextRoots();
        this.adapter = new EjbWSAdapter();
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        try {
            Application app = (Application)this.deploymentCtx.getModuleMetaData(Application.class);
            if (!this.isJAXWSbasedApp(app)) {
                Iterator<String> iter = this.contextRoots.iterator();
                String contextRoot = null;
                while (iter.hasNext()) {
                    contextRoot = iter.next();
                    this.dispatcher.registerEndpoint(contextRoot, this.adapter, (ApplicationContainer)this);
                }
            }
        }
        catch (EndpointRegistrationException e) {
            this.logger.log(Level.SEVERE, "Error in registering the endpoint", e);
        }
        return true;
    }

    private Collection<String> getContextRoots() {
        this.contextRoots = new ArrayList<String>();
        Application app = (Application)this.deploymentCtx.getModuleMetaData(Application.class);
        if (!this.isJAXWSbasedApp(app)) {
            Set bundles = app.getBundleDescriptors();
            for (BundleDescriptor bundle : bundles) {
                WebServicesDescriptor wsDesc = bundle.getWebServices();
                for (WebService ws : wsDesc.getWebServices()) {
                    for (WebServiceEndpoint endpoint : ws.getEndpoints()) {
                        this.contextRoots.add(endpoint.getEndpointAddressUri());
                    }
                }
            }
        }
        return this.contextRoots;
    }

    public boolean stop(ApplicationContext stopContext) {
        try {
            Iterator<String> iter = this.contextRoots.iterator();
            String contextRoot = null;
            while (iter.hasNext()) {
                contextRoot = iter.next();
                this.dispatcher.unregisterEndpoint(contextRoot);
            }
        }
        catch (EndpointRegistrationException e) {
            this.logger.log(Level.SEVERE, "Error in unregistering the endpoint", e);
            return false;
        }
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() throws Exception {
        return false;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    private boolean isJAXWSbasedApp(Application app) {
        return app.getStandaloneBundleDescriptor() instanceof WebBundleDescriptor && (!app.getStandaloneBundleDescriptor().getSpecVersion().equals("2.5") || !app.getStandaloneBundleDescriptor().hasWebServices());
    }
}

