/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.security.jmac.provider.PacketMapMessageInfo;
import com.sun.enterprise.security.jmac.provider.PacketMessageInfo;
import com.sun.enterprise.security.jmac.provider.config.PipeHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthContext;
import javax.xml.ws.WebServiceException;

public class CommonServerSecurityTube
extends AbstractFilterTubeImpl {
    protected static final Logger _logger = LogDomains.getLogger(CommonServerSecurityTube.class, (String)"javax.enterprise.system.core.security");
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CommonServerSecurityTube.class);
    private final boolean isHttpBinding;
    private PipeHelper helper;
    private ServerAuthContext sAC = null;
    private PacketMessageInfo info = null;
    private Subject serverSubject = null;

    public CommonServerSecurityTube(Map props, Tube next, boolean isHttpBinding) {
        super(next);
        props.put("SECURITY_PIPE", this);
        this.helper = new PipeHelper("SOAP", props, null);
        this.isHttpBinding = isHttpBinding;
    }

    protected CommonServerSecurityTube(CommonServerSecurityTube that, TubeCloner cloner) {
        super((AbstractFilterTubeImpl)that, cloner);
        this.helper = that.helper;
        this.isHttpBinding = that.isHttpBinding;
    }

    public void preDestroy() {
        this.helper.disable();
        this.next.preDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NextAction processRequest(Packet request) {
        try {
            if (this.isHttpBinding) {
                return this.doInvoke(this.next, request);
            }
            AuthStatus status = AuthStatus.SUCCESS;
            this.info = new PacketMapMessageInfo(request, new Packet());
            this.serverSubject = (Subject)request.invocationProperties.get("SERVER_SUBJECT");
            this.sAC = this.helper.getServerAuthContext(this.info, this.serverSubject);
            Subject clientSubject = CommonServerSecurityTube.getClientSubject(request);
            try {
                if (this.sAC != null) {
                    status = this.sAC.validateRequest((MessageInfo)this.info, clientSubject, this.serverSubject);
                }
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "ws.error_validate_request", e);
                WebServiceException wse = new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantValidateRequest", "Cannot validate request for {0}", new Object[]{this.helper.getModelName()}), (Throwable)e);
                status = AuthStatus.SEND_FAILURE;
                Packet ret = this.helper.getFaultResponse(this.info.getRequestPacket(), this.info.getResponsePacket(), (Throwable)wse);
                NextAction nextAction = this.doReturnWith(ret);
                return nextAction;
            }
            finally {
                Packet validatedRequest = this.info.getRequestPacket();
                this.helper.auditInvocation(validatedRequest, status);
            }
            Packet response = null;
            if (status == AuthStatus.SUCCESS) {
                Packet validatedRequest;
                boolean authorized = false;
                try {
                    this.helper.authorize(validatedRequest);
                    authorized = true;
                }
                catch (Exception e) {
                    response = this.helper.getFaultResponse(validatedRequest, this.info.getResponsePacket(), e);
                    return this.doReturnWith(response);
                }
                if (!authorized) {
                    response = this.helper.getFaultResponse(validatedRequest, this.info.getResponsePacket(), new Exception("Client Not Authorized"));
                    return this.doReturnWith(response);
                }
                if (System.getSecurityManager() == null) {
                    try {
                        return this.doInvoke(this.next, validatedRequest);
                    }
                    catch (Exception e) {
                        if (e instanceof AuthException) {
                            _logger.log(Level.SEVERE, "ws.error_next_pipe", e);
                        }
                        response = this.helper.getFaultResponse(validatedRequest, this.info.getResponsePacket(), e);
                        return this.doReturnWith(response);
                    }
                }
                try {
                    final Tube next = this.next;
                    return (NextAction)Subject.doAsPrivileged(clientSubject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return CommonServerSecurityTube.this.doInvoke(next, validatedRequest);
                        }
                    }, null);
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    if (cause instanceof AuthException) {
                        _logger.log(Level.SEVERE, "ws.error_next_pipe", cause);
                    }
                    response = this.helper.getFaultResponse(validatedRequest, this.info.getResponsePacket(), cause);
                    return this.doReturnWith(response);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "ws.status_validate_request", status);
            }
            response = this.info.getResponsePacket();
            return this.doReturnWith(response);
        }
        catch (Throwable t2) {
            if (t2 instanceof WebServiceException) return this.doThrow((Throwable)t2);
            WebServiceException t2 = new WebServiceException(t2);
            return this.doThrow((Throwable)t2);
        }
    }

    public NextAction processResponse(Packet response) {
        try {
            if (response == null || response.getMessage() == null) {
                return this.doReturnWith(response);
            }
            Packet resp = response;
            if (this.sAC != null && response.getMessage() != null) {
                this.info.setResponsePacket(response);
                resp = this.processResponse(this.info, this.sAC, this.serverSubject);
            }
            return this.doReturnWith(resp);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow((Throwable)t2);
        }
    }

    private Packet processResponse(PacketMessageInfo info, ServerAuthContext sAC, Subject serverSubject) throws Exception {
        AuthStatus status;
        try {
            status = sAC.secureResponse((MessageInfo)info, serverSubject);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "ws.error_secure_response", e);
                }
            } else {
                _logger.log(Level.SEVERE, "ws.error_secure_response", e);
            }
            return this.helper.makeFaultResponse(info.getResponsePacket(), e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ws.status_secure_response", status);
        }
        return info.getResponsePacket();
    }

    private static Subject getClientSubject(Packet p) {
        Subject s = null;
        if (p != null) {
            s = (Subject)p.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (s == null) {
            s = PipeHelper.getClientSubject();
            if (p != null) {
                p.invocationProperties.put("CLIENT_SUBJECT", s);
            }
        }
        return s;
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new CommonServerSecurityTube(this, cloner);
    }
}

