/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.ConnectionCacheFactory;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.InboundConnectionCache;
import com.sun.xml.ws.transport.tcp.io.Connection;
import com.sun.xml.ws.transport.tcp.io.DataInOutUtils;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.ServerConnectionSession;
import com.sun.xml.ws.transport.tcp.server.TCPMessageListener;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.ChannelSettings;
import com.sun.xml.ws.transport.tcp.util.ConnectionManagementSettings;
import com.sun.xml.ws.transport.tcp.util.ConnectionSession;
import com.sun.xml.ws.transport.tcp.util.SessionCloseListener;
import com.sun.xml.ws.transport.tcp.util.Version;
import com.sun.xml.ws.transport.tcp.util.VersionController;
import com.sun.xml.ws.transport.tcp.util.WSTCPError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IncomeMessageProcessor
implements SessionCloseListener {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    private final TCPMessageListener listener;
    private final Properties properties;
    private volatile InboundConnectionCache<ServerConnectionSession> connectionCache;
    private static Map<Integer, IncomeMessageProcessor> portMessageProcessors = new HashMap<Integer, IncomeMessageProcessor>(1);
    private final Map<SocketChannel, ServerConnectionSession> connectionSessionMap = new WeakHashMap<SocketChannel, ServerConnectionSession>();

    public static IncomeMessageProcessor registerListener(int port, @NotNull TCPMessageListener listener, @NotNull Properties properties) {
        IncomeMessageProcessor processor = new IncomeMessageProcessor(listener, properties);
        portMessageProcessors.put(port, processor);
        return processor;
    }

    public static void releaseListener(int port) {
        portMessageProcessors.remove(port);
    }

    @Nullable
    public static IncomeMessageProcessor getMessageProcessorForPort(int port) {
        return portMessageProcessors.get(port);
    }

    private IncomeMessageProcessor(@NotNull TCPMessageListener listener) {
        this(listener, null);
    }

    private IncomeMessageProcessor(@NotNull TCPMessageListener listener, @Nullable Properties properties) {
        this.listener = listener;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(@NotNull ByteBuffer messageBuffer, @NotNull SocketChannel socketChannel) throws IOException {
        ServerConnectionSession connectionSession;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1080_INCOME_MSG_PROC_ENTER(Connection.getHost(socketChannel), Connection.getPort(socketChannel)));
        }
        if (this.connectionCache == null) {
            this.setupInboundConnectionCache();
        }
        if ((connectionSession = this.getConnectionSession(socketChannel)) == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1081_INCOME_MSG_CREATE_NEW_SESSION());
            }
            if ((connectionSession = this.createConnectionSession(socketChannel, messageBuffer)) != null) {
                this.connectionCache.requestReceived(connectionSession);
                this.connectionCache.responseSent(connectionSession);
                this.offerConnectionSession(connectionSession);
            } else {
                logger.log(Level.WARNING, MessagesMessages.WSTCP_0006_VERSION_MISMATCH());
            }
            return;
        }
        Connection connection = connectionSession.getConnection();
        connection.setInputStreamByteBuffer(messageBuffer);
        this.connectionCache.requestReceived(connectionSession);
        try {
            do {
                connection.prepareForReading();
                int channelId = connection.getChannelId();
                ChannelContext channelContext = connectionSession.findWSServiceContextByChannelId(channelId);
                if (channelContext != null) {
                    this.listener.onMessage(channelContext);
                    continue;
                }
                ChannelContext fakeChannelContext = this.createFakeChannelContext(channelId, connectionSession);
                this.listener.onError(fakeChannelContext, WSTCPError.createNonCriticalError(1, MessagesMessages.WSTCP_0026_UNKNOWN_CHANNEL_ID(channelId)));
            } while (messageBuffer.hasRemaining());
        }
        finally {
            this.offerConnectionSession(connectionSession);
            this.connectionCache.responseSent(connectionSession);
        }
    }

    @Nullable
    private ServerConnectionSession getConnectionSession(@NotNull SocketChannel socketChannel) {
        ServerConnectionSession connectionSession = this.connectionSessionMap.get(socketChannel);
        if (connectionSession == null) {
            return null;
        }
        connectionSession.getConnection().setSocketChannel(socketChannel);
        return connectionSession;
    }

    private void offerConnectionSession(@NotNull ServerConnectionSession connectionSession) {
        this.connectionSessionMap.put(connectionSession.getConnection().getSocketChannel(), connectionSession);
        connectionSession.getConnection().setSocketChannel(null);
    }

    private void removeConnectionSessionBySocketChannel(@NotNull SocketChannel socketChannel) {
        this.connectionSessionMap.remove(socketChannel);
    }

    @Nullable
    private ServerConnectionSession createConnectionSession(@NotNull SocketChannel socketChannel, @NotNull ByteBuffer messageBuffer) throws IOException {
        Connection connection = new Connection(socketChannel);
        connection.setInputStreamByteBuffer(messageBuffer);
        if (!this.checkMagicAndVersionCompatibility(connection)) {
            connection.close();
            return null;
        }
        return new ServerConnectionSession(connection, (SessionCloseListener<ServerConnectionSession>)this);
    }

    private boolean checkMagicAndVersionCompatibility(@NotNull Connection connection) throws IOException {
        logger.log(Level.FINE, MessagesMessages.WSTCP_1082_INCOME_MSG_VERSION_CHECK_ENTER());
        connection.setDirectMode(true);
        InputStream inputStream = connection.openInputStream();
        byte[] magicBuf = new byte["vnd.sun.ws.tcp".length()];
        DataInOutUtils.readFully(inputStream, magicBuf);
        String magic = new String(magicBuf, "US-ASCII");
        if (!"vnd.sun.ws.tcp".equals(magic)) {
            logger.log(Level.WARNING, MessagesMessages.WSTCP_0020_WRONG_MAGIC(magic));
            return false;
        }
        int[] versionInfo = new int[4];
        DataInOutUtils.readInts4(inputStream, versionInfo, 4);
        Version clientFramingVersion = new Version(versionInfo[0], versionInfo[1]);
        Version clientConnectionManagementVersion = new Version(versionInfo[2], versionInfo[3]);
        VersionController versionController = VersionController.getInstance();
        boolean isSupported = versionController.isVersionSupported(clientFramingVersion, clientConnectionManagementVersion);
        OutputStream outputStream = connection.openOutputStream();
        Version framingVersion = isSupported ? clientFramingVersion : versionController.getClosestSupportedFramingVersion(clientFramingVersion);
        Version connectionManagementVersion = isSupported ? clientConnectionManagementVersion : versionController.getClosestSupportedConnectionManagementVersion(clientConnectionManagementVersion);
        DataInOutUtils.writeInts4(outputStream, framingVersion.getMajor(), framingVersion.getMinor(), connectionManagementVersion.getMajor(), connectionManagementVersion.getMinor());
        connection.flush();
        connection.setDirectMode(false);
        logger.log(Level.FINE, MessagesMessages.WSTCP_1083_INCOME_MSG_VERSION_CHECK_RESULT(clientFramingVersion, clientConnectionManagementVersion, framingVersion, connectionManagementVersion, isSupported));
        return isSupported;
    }

    public void notifyClosed(@NotNull SocketChannel socketChannel) {
        if (this.connectionCache != null) {
            this.connectionCache.close(this.getConnectionSession(socketChannel));
        }
    }

    public void notifySessionClose(@NotNull ConnectionSession connectionSession) {
        this.removeConnectionSessionBySocketChannel(connectionSession.getConnection().getSocketChannel());
    }

    private synchronized void setupInboundConnectionCache() {
        if (this.connectionCache == null) {
            ConnectionManagementSettings settings = ConnectionManagementSettings.getSettingsHolder().getServerSettings();
            int highWatermark = settings.getHighWatermark();
            int numberToReclaim = settings.getNumberToReclaim();
            this.connectionCache = ConnectionCacheFactory.makeBlockingInboundConnectionCache("SOAP/TCP server side cache", highWatermark, numberToReclaim, logger);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1084_INCOME_MSG_SERVER_SIDE_CONNECTION_CACHE(highWatermark, numberToReclaim));
            }
        }
    }

    private ChannelContext createFakeChannelContext(int channelId, @NotNull ConnectionSession connectionSession) {
        return new ChannelContext(connectionSession, new ChannelSettings(Collections.<String>emptyList(), Collections.<String>emptyList(), channelId, null, null));
    }
}

