/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server.tomcat;

import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.tomcat.WSTCPTomcatRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;

public abstract class WSTCPTomcatProtocolHandlerBase
implements ProtocolHandler,
Runnable {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    private Map<String, Object> atts = new HashMap<String, Object>();
    private Adapter adapter;
    protected int port;
    protected int redirectHttpPort = 8080;
    protected int readThreadsCount;
    protected int maxWorkerThreadsCount = -1;
    protected int minWorkerThreadsCount = -1;

    public void setAttribute(String string2, Object object) {
        this.atts.put(string2, object);
    }

    public Object getAttribute(String string2) {
        return this.atts.get(string2);
    }

    public Iterator getAttributeNames() {
        return this.atts.keySet().iterator();
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void init() throws Exception {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, MessagesMessages.WSTCP_1170_INIT_SOAPTCP(this.port));
        }
        WSTCPTomcatRegistry.setInstance(new WSTCPTomcatRegistry(this.port));
    }

    public void start() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1171_START_SOAPTCP_LISTENER());
        }
        new Thread(this).start();
    }

    public void resume() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1173_RESUME_SOAPTCP_LISTENER());
        }
        this.start();
    }

    public void pause() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1172_PAUSE_SOAPTCP_LISTENER());
        }
        WSTCPTomcatRegistry.setInstance(new WSTCPTomcatRegistry(-1));
        this.destroy();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
    }

    public int getReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setMaxWorkerThreadsCount(int maxWorkerThreadsCount) {
        this.maxWorkerThreadsCount = maxWorkerThreadsCount;
    }

    public int getMaxWorkerThreadsCount() {
        return this.maxWorkerThreadsCount;
    }

    public void setMinWorkerThreadsCount(int minWorkerThreadsCount) {
        this.minWorkerThreadsCount = minWorkerThreadsCount;
    }

    public int getMinWorkerThreadsCount() {
        return this.minWorkerThreadsCount;
    }

    public void setRedirectHttpPort(int redirectHttpPort) {
        this.redirectHttpPort = redirectHttpPort;
    }

    public int getRedirectHttpPort() {
        return this.redirectHttpPort;
    }

    public String toString() {
        return MessagesMessages.WSTCP_1174_TOMCAT_SOAPTCP_LISTENER(this.port);
    }
}

