/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv;

import com.sun.xml.ws.api.security.secconv.client.SCTokenConfiguration;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.secconv.WSSCElementFactory;
import com.sun.xml.ws.security.secconv.WSSCVersion;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.impl.SecurityContextTokenInfoImpl;
import com.sun.xml.ws.security.secconv.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedTokenCancelled;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSSCClientContract {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.secconv", "com.sun.xml.ws.security.secconv.logging.LogStrings");
    private static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.getDefault());
    private static final int DEFAULT_KEY_SIZE = 256;
    private WSSCVersion wsscVer = WSSCVersion.WSSC_10;
    private WSTrustVersion wsTrustVer = WSTrustVersion.WS_TRUST_10;

    public void handleRSTR(RequestSecurityToken rst, RequestSecurityTokenResponse rstr, IssuedTokenContext context) throws WSSecureConversationException {
        RequestedTokenCancelled cancelled;
        RequestedSecurityToken securityToken;
        if (!context.getSecurityPolicy().isEmpty()) {
            SCTokenConfiguration sctConfig = (SCTokenConfiguration)context.getSecurityPolicy().get(0);
            this.wsscVer = WSSCVersion.getInstance(sctConfig.getProtocol());
        }
        if (this.wsscVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
            this.wsTrustVer = WSTrustVersion.WS_TRUST_13;
        }
        if (rst.getRequestType().toString().equals(this.wsTrustVer.getIssueRequestTypeURI())) {
            securityToken = rstr.getRequestedSecurityToken();
            RequestedAttachedReference attachedRef = rstr.getRequestedAttachedReference();
            RequestedUnattachedReference unattachedRef = rstr.getRequestedUnattachedReference();
            RequestedProofToken proofToken = rstr.getRequestedProofToken();
            byte[] key = this.getKey(rstr, proofToken, rst);
            if (key != null) {
                context.setProofKey(key);
            }
            this.setLifetime(rstr, context);
            if (securityToken == null && proofToken == null) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0002_NULL_TOKEN());
                throw new WSSecureConversationException(LogStringsMessages.WSSC_0002_NULL_TOKEN());
            }
            if (securityToken != null) {
                context.setSecurityToken(securityToken.getToken());
            }
            if (attachedRef != null) {
                context.setAttachedSecurityTokenReference(attachedRef.getSTR());
            }
            if (unattachedRef != null) {
                context.setUnAttachedSecurityTokenReference(unattachedRef.getSTR());
            }
        }
        if (rst.getRequestType().toString().equals(this.wsTrustVer.getRenewRequestTypeURI())) {
            securityToken = rstr.getRequestedSecurityToken();
            RequestedProofToken proofToken = rstr.getRequestedProofToken();
            byte[] key = this.getKey(rstr, proofToken, rst);
            this.setLifetime(rstr, context);
            if (securityToken != null) {
                context.setSecurityToken(securityToken.getToken());
            }
            SecurityContextTokenInfo sctInfo = null;
            sctInfo = context.getSecurityContextTokenInfo() == null ? new SecurityContextTokenInfoImpl() : context.getSecurityContextTokenInfo();
            sctInfo.setIdentifier(((SecurityContextToken)context.getSecurityToken()).getIdentifier().toString());
            sctInfo.setInstance(((SecurityContextToken)context.getSecurityToken()).getInstance());
            sctInfo.setExternalId(((SecurityContextToken)context.getSecurityToken()).getWsuId());
            if (key != null) {
                sctInfo.addInstance(((SecurityContextToken)context.getSecurityToken()).getInstance(), key);
            }
            context.setSecurityContextTokenInfo(sctInfo);
        } else if (rst.getRequestType().toString().equals(this.wsTrustVer.getCancelRequestTypeURI()) && (cancelled = rstr.getRequestedTokenCancelled()) != null) {
            context.setProofKey(null);
        }
    }

    public void handleRSTRC(RequestSecurityToken rst, RequestSecurityTokenResponseCollection rstrc, IssuedTokenContext context) throws WSSecureConversationException {
        List<RequestSecurityTokenResponse> rstrList = rstrc.getRequestSecurityTokenResponses();
        for (RequestSecurityTokenResponse rstr : rstrList) {
            this.handleRSTR(rst, rstr, context);
        }
    }

    private byte[] getKey(RequestSecurityTokenResponse rstr, RequestedProofToken proofToken, RequestSecurityToken rst) throws UnsupportedOperationException, WSSecureConversationException, WSSecureConversationException, UnsupportedOperationException {
        byte[] key = null;
        if (proofToken != null) {
            String proofTokenType = proofToken.getProofTokenType();
            if ("ComputedKey".equals(proofTokenType)) {
                key = this.computeKey(rstr, proofToken, rst);
            } else {
                if ("SecurityTokenReference".equals(proofTokenType)) {
                    throw new UnsupportedOperationException("To Do");
                }
                if ("EncryptedKey".equals(proofTokenType)) {
                    throw new UnsupportedOperationException("To Do");
                }
                if ("BinarySecret".equals(proofTokenType)) {
                    BinarySecret binarySecret = proofToken.getBinarySecret();
                    key = binarySecret.getRawValue();
                } else {
                    log.log(Level.SEVERE, LogStringsMessages.WSSC_0003_INVALID_PROOFTOKEN(proofTokenType));
                    throw new WSSecureConversationException(LogStringsMessages.WSSC_0003_INVALID_PROOFTOKEN(proofTokenType));
                }
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLifetime(RequestSecurityTokenResponse rstr, IssuedTokenContext context) throws WSSecureConversationException {
        try {
            Lifetime lifetime = rstr.getLifetime();
            AttributedDateTime created = lifetime.getCreated();
            AttributedDateTime expires = lifetime.getExpires();
            SimpleDateFormat simpleDateFormat = calendarFormatter;
            synchronized (simpleDateFormat) {
                Date dateCreated = calendarFormatter.parse(created.getValue());
                Date dateExpires = calendarFormatter.parse(expires.getValue());
                context.setCreationTime(dateCreated);
                context.setExpirationTime(dateExpires);
            }
        }
        catch (ParseException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0004_PARSE_EXCEPTION(), ex);
            throw new WSSecureConversationException(LogStringsMessages.WSSC_0004_PARSE_EXCEPTION(), ex);
        }
    }

    private byte[] computeKey(RequestSecurityTokenResponse rstr, RequestedProofToken proofToken, RequestSecurityToken rst) throws WSSecureConversationException, UnsupportedOperationException {
        URI computedKey = proofToken.getComputedKey();
        Entropy clientEntropy = rst.getEntropy();
        Entropy serverEntropy = rstr.getEntropy();
        BinarySecret clientBS = clientEntropy.getBinarySecret();
        BinarySecret serverBS = serverEntropy.getBinarySecret();
        byte[] clientEntr = null;
        byte[] serverEntr = null;
        if (clientBS != null) {
            clientEntr = clientBS.getRawValue();
        }
        if (serverBS != null) {
            serverEntr = serverBS.getRawValue();
        }
        byte[] key = null;
        int keySize = (int)rstr.getKeySize();
        if (keySize == 0) {
            keySize = (int)rst.getKeySize();
        }
        if (keySize == 0) {
            keySize = 256;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0005_COMPUTED_KEYSIZE(keySize, 256));
        }
        if (computedKey.toString().equals(this.wsTrustVer.getCKPSHA1algorithmURI())) {
            try {
                key = SecurityUtil.P_SHA1(clientEntr, serverEntr, keySize / 8);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0006_UNABLETOEXTRACT_KEY(), ex);
                throw new WSSecureConversationException(LogStringsMessages.WSSC_0006_UNABLETOEXTRACT_KEY(), ex);
            }
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0026_UNSUPPORTED_COMPUTED_KEY(computedKey));
            throw new WSSecureConversationException(LogStringsMessages.WSSC_0026_UNSUPPORTED_COMPUTED_KEY_E(computedKey));
        }
        return key;
    }

    public RequestSecurityTokenResponse handleRSTRForNegotiatedExchange(RequestSecurityToken rst, RequestSecurityTokenResponse rstr, IssuedTokenContext context) throws WSSecureConversationException {
        return null;
    }

    public RequestSecurityTokenResponse createRSTRForClientInitiatedIssuedTokenContext(AppliesTo scopes, IssuedTokenContext context) throws WSSecureConversationException {
        WSSCElementFactory eleFac = WSSCElementFactory.newInstance();
        byte[] secret = WSTrustUtil.generateRandomSecret(256);
        BinarySecret binarySecret = eleFac.createBinarySecret(secret, this.wsTrustVer.getSymmetricKeyTypeURI());
        RequestedProofToken proofToken = eleFac.createRequestedProofToken();
        proofToken.setProofTokenType("BinarySecret");
        proofToken.setBinarySecret(binarySecret);
        SecurityContextToken token = WSTrustUtil.createSecurityContextToken(eleFac);
        RequestedSecurityToken rst = eleFac.createRequestedSecurityToken(token);
        RequestSecurityTokenResponse rstr = eleFac.createRSTR();
        rstr.setAppliesTo(scopes);
        rstr.setRequestedSecurityToken(rst);
        rstr.setRequestedProofToken(proofToken);
        context.setSecurityToken(token);
        context.setProofKey(secret);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0007_CREATED_RSTR(rstr.toString()));
        }
        return rstr;
    }

    public boolean containsChallenge(RequestSecurityTokenResponse rstr) {
        return false;
    }

    public URI getComputedKeyAlgorithmFromProofToken(RequestSecurityTokenResponse rstr) {
        return null;
    }
}

