/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.jaxws;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.sun.xml.messaging.saaj.soap.ExpressMessage;
import com.sun.xml.messaging.saaj.soap.MessageImpl;
import com.sun.xml.ws.spi.runtime.InternalSoapEncoder;
import com.sun.xml.ws.spi.runtime.MtomCallback;
import com.sun.xml.ws.spi.runtime.SOAPMessageContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JAXWSMessage {
    private static final String TAG_ENVELOPE = "Envelope";
    private static final String TAG_HEADER = "Header";
    private static final String TAG_BODY = "Body";
    private static final String TAG_FAULT = "Fault";
    public static final String FAST_INFOSET_TYPE_SOAP11 = "application/fastinfoset";
    public static final String FAST_INFOSET_TYPE_SOAP12 = "application/soap+fastinfoset";
    public static final String XOP_SOAP11_XML_TYPE_VALUE = "application/xop+xml;type=\"text/xml\"";
    public static final String XOP_SOAP12_XML_TYPE_VALUE = "application/xop+xml;type=\"application/soap+xml\"";
    public static final String XML_CONTENT_TYPE_VALUE = "text/xml";
    private XMLSerializer _xmlSerializer;
    private static XMLOutputFactory staxOF = null;
    private Object messageInfo = null;
    private InternalSoapEncoder encoder = null;
    private boolean headerUsed = false;
    private boolean isBodyUsed = false;
    private List internalHeaders = null;
    private SOAPMessage soapMessage = null;
    private Object body = null;
    private byte[] cBody = null;
    private boolean isFI = false;
    Map mAttachments = new HashMap();
    MTOMCallbackImpl mtomCB = null;
    private int length;
    private ByteArrayOutputStream encryptedBody = null;

    public JAXWSMessage() {
        try {
            OutputFormat format = new OutputFormat();
            format.setOmitXMLDeclaration(true);
            this._xmlSerializer = new XMLSerializer(format);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public InternalSoapEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(InternalSoapEncoder encoder) {
        this.encoder = encoder;
    }

    public void setMessageInfo(Object msgInfo) {
        this.messageInfo = msgInfo;
    }

    public Object getMessageInfo() {
        return this.messageInfo;
    }

    public boolean isHeaderUsed() {
        return this.headerUsed;
    }

    public void setHeaderUsed(boolean isHeaderUsed) {
        this.headerUsed = isHeaderUsed;
    }

    public boolean isBodyUsed() {
        return this.isBodyUsed;
    }

    public void setBodyUsed(boolean isBodyUsed) {
        this.isBodyUsed = isBodyUsed;
    }

    public void setHeaders(List headers) {
        this.internalHeaders = headers;
    }

    public List getHeaders() {
        return this.internalHeaders;
    }

    public SOAPMessage getSoapMessage() {
        return this.soapMessage;
    }

    public void setSoapMessage(SOAPMessage soapMessage) throws SOAPException {
        this.soapMessage = soapMessage;
        this.initMTOMHandler();
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public byte[] getCanonicalizedBody() {
        return this.cBody;
    }

    public int getCBLength() {
        return this.length;
    }

    public void setCanonicalizedBody(byte[] data, int len) {
        this.cBody = data;
        this.length = len;
    }

    public void writeSOAPMessage(OutputStream baos) throws XMLStreamException, SOAPException, IOException {
        XMLStreamWriter writer = null;
        boolean _FI = false;
        writer = staxOF.createXMLStreamWriter(baos);
        writer.writeStartDocument();
        this._xmlSerializer.setOutputByteStream(baos);
        SOAPEnvelope env = this.getSoapMessage().getSOAPPart().getEnvelope();
        writer.writeStartElement(env.getPrefix(), TAG_ENVELOPE, env.getNamespaceURI());
        this.writeAttributes(env.getAttributes(), writer);
        writer.writeCharacters("");
        writer.writeStartElement(env.getPrefix(), TAG_HEADER, env.getNamespaceURI());
        SOAPHeader header = ((ExpressMessage)((Object)this.getSoapMessage())).getEMHeader();
        if (header != null) {
            this.writeAttributes(header.getAttributes(), writer);
            writer.writeCharacters("");
            writer.flush();
            Iterator hList = header.getChildElements();
            while (hList.hasNext()) {
                Node node = (Node)hList.next();
                if (node.getNodeType() != 1) continue;
                this._xmlSerializer.serialize((Element)node);
            }
        }
        writer.flush();
        if (!this.isHeaderUsed()) {
            this.writeJAXWSHeaders(writer);
            writer.flush();
        }
        writer.writeEndElement();
        writer.flush();
        if (!this.isBodyUsed()) {
            if (this.encryptedBody != null) {
                writer.writeStartElement(env.getPrefix(), TAG_BODY, env.getNamespaceURI());
                this.writeAttributes(((ExpressMessage)((Object)this.getSoapMessage())).getEMBody().getAttributes(), writer);
                writer.writeCharacters("");
                writer.flush();
                this.encryptedBody.writeTo(baos);
            } else if (this.getCanonicalizedBody() == null) {
                writer.writeStartElement(env.getPrefix(), TAG_BODY, env.getNamespaceURI());
                this.writeAttributes(((ExpressMessage)((Object)this.getSoapMessage())).getEMBody().getAttributes(), writer);
                writer.writeCharacters("");
                writer.flush();
                this.writeJAXWSBody(baos);
            } else {
                byte[] cb = this.getCanonicalizedBody();
                baos.write(cb, 0, this.length);
            }
        } else {
            SOAPBody body = env.getBody();
            if (body.getNodeType() == 1) {
                this._xmlSerializer.serialize(body);
            }
        }
        writer.flush();
        writer.writeEndDocument();
        writer.flush();
    }

    public void writeJAXWSHeaders(XMLStreamWriter writer) throws SOAPException {
        InternalSoapEncoder encoder = this.getEncoder();
        Object messageInfo = this.getMessageInfo();
        List headers = this.getHeaders();
        if (headers == null) {
            return;
        }
        for (int i = 0; i < headers.size(); ++i) {
            Object internalHeader = headers.get(i);
            encoder.write(internalHeader, messageInfo, writer, (MtomCallback)this.mtomCB);
        }
    }

    public void writeJAXWSBody(OutputStream stream) throws IOException, SOAPException {
        InternalSoapEncoder encoder = this.getEncoder();
        Object messageInfo = this.getMessageInfo();
        Object body = this.getBody();
        if (stream != null) {
            if (body != null) {
                encoder.write(body, messageInfo, stream, (MtomCallback)this.mtomCB);
            }
        } else {
            throw new IOException("Stream cannot be null");
        }
    }

    private void initMTOMHandler() throws SOAPException {
        if (this.mtomCB == null) {
            if (this.soapMessage == null) {
                throw new SOAPException("SOAPMessage cannot be null");
            }
            this.mtomCB = new MTOMCallbackImpl(this.mAttachments, this.soapMessage);
        }
    }

    public void writeJAXWSBody(XMLStreamWriter writer) {
        InternalSoapEncoder encoder = this.getEncoder();
        Object messageInfo = this.getMessageInfo();
        Object body = this.getBody();
        if (body == null) {
            return;
        }
        encoder.write(body, messageInfo, writer, (MtomCallback)this.mtomCB);
    }

    public void constructSOAPBody(Node body) throws XMLStreamException, IOException {
        XMLStreamWriter writer = staxOF.createXMLStreamWriter(new DOMResult(body));
        this.writeJAXWSBody(writer);
    }

    public void constructSOAPHeaders(Node header) throws XMLStreamException, SOAPException {
        XMLStreamWriter writer = staxOF.createXMLStreamWriter(new DOMResult(header));
        this.writeJAXWSHeaders(writer);
    }

    private void writeAttributes(NamedNodeMap attrs, XMLStreamWriter writer) throws XMLStreamException {
        if (attrs == null) {
            return;
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                writer.writeNamespace(attr.getLocalName(), attr.getValue());
                continue;
            }
            writer.writeAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
        }
    }

    private XMLOutputFactory getStAXWriterFactory() {
        return staxOF;
    }

    public ByteArrayOutputStream getEncryptedBody() {
        return this.encryptedBody;
    }

    public void setEncryptedBody(ByteArrayOutputStream encryptedBody) {
        this.encryptedBody = encryptedBody;
    }

    public static SOAPMessage constructSOAPMessage(SOAPMessage sm, SOAPMessageContext msgContext) throws SOAPException {
        try {
            Map attachments;
            Object mi = msgContext.getMessageInfo();
            JAXWSMessage.setMimeHeader(msgContext, sm);
            List headers = msgContext.getHeaders();
            Object body = msgContext.getBody();
            InternalSoapEncoder encoder = msgContext.getEncoder();
            Object messageInfo = msgContext.getMessageInfo();
            SOAPHeader header = sm.getSOAPHeader();
            XMLStreamWriter writer = null;
            HashMap mtomAtt = new HashMap();
            MTOMCallbackImpl mci = new MTOMCallbackImpl(mtomAtt, sm);
            if (headers != null) {
                writer = staxOF.createXMLStreamWriter(new DOMResult(header));
                for (int i = 0; i < headers.size(); ++i) {
                    Object internalHeader = headers.get(i);
                    encoder.write(internalHeader, messageInfo, writer, (MtomCallback)mci);
                }
            }
            if (body != null) {
                writer = staxOF.createXMLStreamWriter(new DOMResult(sm.getSOAPBody()));
                encoder.write(body, messageInfo, writer, (MtomCallback)mci);
            }
            if ((attachments = (Map)msgContext.get((Object)"javax.xml.ws.binding.attachments.outbound")) != null) {
                Set keys = attachments.keySet();
                for (String cid : keys) {
                    if (mtomAtt.keySet().contains(cid)) continue;
                    DataHandler dh = (DataHandler)attachments.get(cid);
                    AttachmentPart attachmentPart = sm.createAttachmentPart();
                    attachmentPart.setDataHandler(dh);
                    attachmentPart.setContentId(cid);
                    attachmentPart.setMimeHeader("Content-transfer-encoding", "binary");
                    sm.addAttachmentPart(attachmentPart);
                }
            }
            msgContext.setMessage(sm);
            return sm;
        }
        catch (Exception ex) {
            throw new SOAPException(ex);
        }
    }

    public XMLSerializer getXmlSerializer() {
        return this._xmlSerializer;
    }

    private static void setMimeHeader(SOAPMessageContext msgContext, SOAPMessage sm) {
        MimeHeaders mh = sm.getMimeHeaders();
        String fiValue = (String)msgContext.get((Object)"com.sun.xml.ws.client.ContentNegotiation");
        String soapVersion = msgContext.getBindingId();
        boolean MTOM_ON = false;
        if (soapVersion == "http://schemas.xmlsoap.org/wsdl/soap/http") {
            if ("optimistic" == fiValue) {
                mh.addHeader("Content-Type", FAST_INFOSET_TYPE_SOAP11);
                ((MessageImpl)sm).setIsFastInfoset(true);
                return;
            }
            if (msgContext.isMtomEnabled() || MTOM_ON) {
                mh.addHeader("Content-Type", XOP_SOAP11_XML_TYPE_VALUE);
                return;
            }
            mh.addHeader("Content-Type", XML_CONTENT_TYPE_VALUE);
            return;
        }
        if ("optimistic" == fiValue) {
            mh.addHeader("Content-Type", FAST_INFOSET_TYPE_SOAP12);
            return;
        }
        if (msgContext.isMtomEnabled() || MTOM_ON) {
            mh.addHeader("Content-Type", XOP_SOAP12_XML_TYPE_VALUE);
            return;
        }
        mh.addHeader("Content-Type", "application/soap+xml");
    }

    static {
        try {
            staxOF = XMLOutputFactory.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class MTOMAttachment {
        private String elementLocalName = null;
        private String namespace = null;
        private AttachmentPart attachment = null;

        MTOMAttachment() {
        }

        public String getElementLocalName() {
            return this.elementLocalName;
        }

        public void setElementLocalName(String elementLocalName) {
            this.elementLocalName = elementLocalName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public AttachmentPart getAttachment() {
            return this.attachment;
        }

        public void setAttachment(AttachmentPart attachment) {
            this.attachment = attachment;
        }
    }

    static class MTOMCallbackImpl
    implements MtomCallback {
        Map attachmentCont = null;
        SOAPMessage msg = null;

        MTOMCallbackImpl(Map map, SOAPMessage msg) {
            this.attachmentCont = map;
            this.msg = msg;
        }

        public void addedMtomAttachment(String contentId, DataHandler attachment, String elementTargetNamespace, String elementLocalName) {
            AttachmentPart attachmentPart = this.msg.createAttachmentPart();
            attachmentPart.setDataHandler(attachment);
            attachmentPart.setContentId(contentId);
            attachmentPart.setMimeHeader("Content-transfer-encoding", "binary");
            MTOMAttachment ma = new MTOMAttachment();
            ma.setAttachment(attachmentPart);
            ma.setNamespace(elementTargetNamespace);
            ma.setElementLocalName(elementLocalName);
            this.attachmentCont.put(contentId, ma);
            this.msg.addAttachmentPart(attachmentPart);
        }
    }
}

