/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.uddi.FuturesRequestManager;
import com.sun.xml.registry.uddi.JAXRCommand;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import java.util.Collection;
import java.util.Locale;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.QueryManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.RegistryObject;

public class QueryManagerImpl
implements QueryManager {
    RegistryServiceImpl service;
    UDDIMapper uddi;

    public QueryManagerImpl() {
        String string2 = Locale.getDefault().getCountry();
        if (string2 == null || string2 == "") {
            Locale.setDefault(Locale.US);
        }
        System.out.println("Default locale: " + Locale.getDefault().toString());
    }

    public QueryManagerImpl(RegistryServiceImpl registryServiceImpl) {
        this();
        this.service = registryServiceImpl;
        this.uddi = registryServiceImpl.getUDDIMapper();
    }

    @Override
    public BulkResponse getRegistryObjects(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public BulkResponse getRegistryObjects() throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl bulkResponseImpl = new BulkResponseImpl();
            bulkResponseImpl.setStatus(3);
            Utility.getInstance();
            bulkResponseImpl.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(bulkResponseImpl);
            FuturesRequestManager.invokeCommand(new JAXRCommand.GetRegistryObjectsCommand(this.service, bulkResponseImpl));
            return bulkResponseImpl;
        }
        return this.uddi.getRegistryObjects();
    }

    @Override
    public RegistryObject getRegistryObject(String string2) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public BulkResponse getRegistryObjects(String string2) throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl bulkResponseImpl = new BulkResponseImpl();
            bulkResponseImpl.setStatus(3);
            Utility.getInstance();
            bulkResponseImpl.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(bulkResponseImpl);
            FuturesRequestManager.invokeCommand(new JAXRCommand.GetRegistryObjectsByTypeCommand(this.service, bulkResponseImpl, string2));
            return bulkResponseImpl;
        }
        return this.uddi.getRegistryObjects(string2);
    }

    @Override
    public RegistryObject getRegistryObject(String string2, String string3) throws JAXRException {
        return this.uddi.getRegistryObject(string2, string3);
    }

    @Override
    public BulkResponse getRegistryObjects(Collection collection, String string2) throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl bulkResponseImpl = new BulkResponseImpl();
            bulkResponseImpl.setStatus(3);
            Utility.getInstance();
            bulkResponseImpl.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(bulkResponseImpl);
            FuturesRequestManager.invokeCommand(new JAXRCommand.GetRegistryObjectsByKeysCommand(this.service, bulkResponseImpl, collection, string2));
            return bulkResponseImpl;
        }
        return this.uddi.getRegistryObjects(collection, string2);
    }

    @Override
    public RegistryService getRegistryService() {
        return this.service;
    }
}

