/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.transaction.xa.Xid;

public class CoordinationXid
implements Xid {
    private static Map<String, Xid> coordId2Xid = new HashMap<String, Xid>();
    private static Map<Xid, String> xid2CoordId = new HashMap<Xid, String>();
    private final String coordId;
    private static Random random = new Random();
    private static final int FORMAT_ID = 200408;
    private final byte[] gtrId = new byte[16];
    private static final byte[] BRANCH_QUALIFIER = new byte[]{1};
    private String stringForm = null;

    public static Xid lookupOrCreate(String coordId) {
        Xid result = CoordinationXid.get(coordId);
        if (result == null) {
            result = new CoordinationXid(coordId);
            coordId2Xid.put(coordId, result);
            xid2CoordId.put(result, coordId);
        }
        return result;
    }

    public String getCoordinationId() {
        return this.coordId;
    }

    public static Xid get(String coordId) {
        return coordId2Xid.get(coordId);
    }

    private static Xid remove(String coordId) {
        return coordId2Xid.remove(coordId);
    }

    private static String remove(Xid coordId) {
        return xid2CoordId.remove(coordId);
    }

    public static void forget(String coordId) {
        Xid removed = CoordinationXid.remove(coordId);
        if (removed != null) {
            CoordinationXid.remove(removed);
        }
    }

    private CoordinationXid(String coordinationXid) {
        random.nextBytes(this.gtrId);
        this.coordId = coordinationXid;
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.gtrId.clone();
    }

    public byte[] getBranchQualifier() {
        return BRANCH_QUALIFIER;
    }

    public int getFormatId() {
        return 200408;
    }

    public String toString() {
        if (this.stringForm != null) {
            return this.stringForm;
        }
        char[] buff = new char[this.gtrId.length * 2 + 3];
        int pos = 0;
        int globalLen = this.gtrId.length;
        for (int i = 0; i < globalLen; ++i) {
            int currCharHigh = (this.gtrId[i] & 0xF0) >> 4;
            int currCharLow = this.gtrId[i] & 0xF;
            buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
            buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
        }
        buff[pos++] = 95;
        boolean currCharHigh = false;
        boolean currCharLow = false;
        buff[pos++] = 48;
        buff[pos++] = 48;
        this.stringForm = new String(buff);
        return this.stringForm;
    }
}

