/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.webservices.deployment.DeployedEndpointData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AMXMetadata(type="web-service-mon", group="monitoring")
@ManagedObject
@Description(value="Deployed Web Services")
public class WebServicesDeploymentMBean {
    private final Map<String, DeployedEndpointData> endpoints = new HashMap<String, DeployedEndpointData>();
    private final Map<Servlet109Endpoint, DeployedEndpointData> servletEndpoints = new HashMap<Servlet109Endpoint, DeployedEndpointData>();
    private final Map<EJB109Endpoint, DeployedEndpointData> ejbEndpoints = new HashMap<EJB109Endpoint, DeployedEndpointData>();

    public synchronized void deploy(@ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        Application app = endpoint.getBundleDescriptor().getApplication();
        String appName = app.getAppName();
        String moduleName = endpoint.getBundleDescriptor().getModuleName();
        String endpointName = endpoint.getEndpointName();
        String id = new Endpoint(appName, moduleName, endpointName).toString();
        String path = endpoint.getEndpointAddressPath();
        DeployedEndpointData data = this.endpoints.get(id);
        if (data == null) {
            data = new DeployedEndpointData(path, app, endpoint);
            this.endpoints.put(id, data);
        }
        if (endpoint.getWebComponentLink() != null) {
            Servlet109Endpoint se = new Servlet109Endpoint(appName, moduleName, endpoint.getWebComponentLink());
            if (!this.servletEndpoints.containsKey(se)) {
                this.servletEndpoints.put(se, data);
            }
        } else if (endpoint.getEjbLink() != null) {
            EJB109Endpoint ee = new EJB109Endpoint(appName, moduleName, endpoint.getEjbLink());
            if (!this.ejbEndpoints.containsKey(ee)) {
                this.ejbEndpoints.put(ee, data);
            }
        } else {
            throw new RuntimeException("Both servlet-link and ejb-link are null for appName=" + appName + " moduleName=" + moduleName + " endpointName=" + endpointName);
        }
    }

    public synchronized void undeploy(@ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        Application app = endpoint.getBundleDescriptor().getApplication();
        String appName = app.getAppName();
        String moduleName = endpoint.getBundleDescriptor().getModuleName();
        String endpointName = endpoint.getEndpointName();
        String id = new Endpoint(appName, moduleName, endpointName).toString();
        this.endpoints.remove(id);
        if (endpoint.getWebComponentLink() != null) {
            Servlet109Endpoint se = new Servlet109Endpoint(appName, moduleName, endpoint.getWebComponentLink());
            this.servletEndpoints.remove(se);
        } else if (endpoint.getEjbLink() != null) {
            EJB109Endpoint ee = new EJB109Endpoint(appName, moduleName, endpoint.getEjbLink());
            this.ejbEndpoints.remove(ee);
        } else {
            throw new RuntimeException("Both servlet-link and ejb-link are null for appName=" + appName + " moduleName=" + moduleName + " endpointName=" + endpointName);
        }
    }

    @ManagedAttribute
    @Description(value="Deployed Web Service Endpoints")
    public synchronized Map<String, DeployedEndpointData> getEndpoints() {
        return new HashMap<String, DeployedEndpointData>(this.endpoints);
    }

    @ManagedOperation
    public synchronized Map<String, String> getServlet109Endpoint(String appName, String moduleName, String servletLink) {
        Servlet109Endpoint endpoint = new Servlet109Endpoint(appName, moduleName, servletLink);
        DeployedEndpointData data = this.servletEndpoints.get(endpoint);
        return data == null ? Collections.emptyMap() : data.getStaticAsMap();
    }

    @ManagedOperation
    public synchronized Map<String, String> getEjb109Endpoint(String appName, String moduleName, String ejbLink) {
        EJB109Endpoint endpoint = new EJB109Endpoint(appName, moduleName, ejbLink);
        DeployedEndpointData data = this.ejbEndpoints.get(endpoint);
        return data == null ? Collections.emptyMap() : data.getStaticAsMap();
    }

    private static class EJB109Endpoint {
        final String appName;
        final String moduleName;
        final String ejbLink;

        EJB109Endpoint(String appName, String moduleName, String ejbLink) {
            this.appName = appName;
            this.moduleName = moduleName;
            this.ejbLink = ejbLink;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EJB109Endpoint) {
                EJB109Endpoint other = (EJB109Endpoint)obj;
                if (this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.ejbLink.equals(other.ejbLink)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.appName.hashCode() + this.moduleName.hashCode() + this.ejbLink.hashCode();
        }
    }

    private static class Servlet109Endpoint {
        final String appName;
        final String moduleName;
        final String servletLink;

        Servlet109Endpoint(String appName, String moduleName, String servletLink) {
            this.appName = appName;
            this.moduleName = moduleName;
            this.servletLink = servletLink;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Servlet109Endpoint) {
                Servlet109Endpoint other = (Servlet109Endpoint)obj;
                if (this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.servletLink.equals(other.servletLink)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.appName.hashCode() + this.moduleName.hashCode() + this.servletLink.hashCode();
        }
    }

    private static class Endpoint {
        final String appName;
        final String moduleName;
        final String endpointName;

        Endpoint(String appName, String moduleName, String endpointName) {
            this.appName = appName;
            this.moduleName = moduleName;
            this.endpointName = endpointName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint other = (Endpoint)obj;
                if (this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.endpointName.equals(other.endpointName)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.appName.hashCode() + this.moduleName.hashCode() + this.endpointName.hashCode();
        }

        public String toString() {
            return this.appName + "#" + this.moduleName + "#" + this.endpointName;
        }
    }
}

