/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.c14n;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.Canonicalizer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.internet.MimeUtility;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.soap.MimeHeader;

public class MimeHeaderCanonicalizer
extends Canonicalizer {
    private static final String _WS = " ";
    private static final String _SC = ";";
    private static final String _BS = "\\";
    private static final String _FS = "/";
    private static final String _EQ = "=";
    private static final String _CL = ":";
    private static final String _OC = "(";
    private static final String _CC = ")";
    private static final String _QT = "\"";
    private static final String _SQ = "'";
    private static final String _HT = "\t";
    private static final String _AX = "*";
    private static final String _PC = "%";
    private static final String _CRLF = "\r\n";

    public byte[] canonicalize(byte[] input) throws XWSSecurityException {
        return null;
    }

    public InputStream canonicalize(InputStream input, OutputStream outputStream) throws TransformException {
        throw new UnsupportedOperationException();
    }

    public byte[] _canonicalize(Iterator mimeHeaders) throws XWSSecurityException {
        String cType;
        String cLocation;
        String cId;
        String cDisposition;
        String _mh = "";
        ArrayList mimeHeaderList = new ArrayList();
        while (mimeHeaders.hasNext()) {
            mimeHeaderList.add(mimeHeaders.next());
        }
        String cDescription = this.getMatchingHeader(mimeHeaderList, "Content-Description");
        if (cDescription != null) {
            _mh = _mh + "Content-Description:";
            _mh = _mh + this.uncomment(this.rfc2047decode(this.unfold(cDescription)));
            _mh = _mh + _CRLF;
        }
        if ((cDisposition = this.getMatchingHeader(mimeHeaderList, "Content-Disposition")) != null) {
            _mh = _mh + "Content-Disposition:";
            _mh = _mh + this.canonicalizeHeaderLine(this.uncomment(this.unfold(cDisposition)), true);
            _mh = _mh + _CRLF;
        }
        if ((cId = this.getMatchingHeader(mimeHeaderList, "Content-ID")) != null) {
            _mh = _mh + "Content-ID:";
            _mh = _mh + this.unfoldWS(this.uncomment(this.unfold(cId))).trim();
            _mh = _mh + _CRLF;
        }
        if ((cLocation = this.getMatchingHeader(mimeHeaderList, "Content-Location")) != null) {
            _mh = _mh + "Content-Location:";
            _mh = _mh + this.unfoldWS(this.uncomment(this.unfold(cLocation))).trim();
            _mh = _mh + _CRLF;
        }
        cType = (cType = this.getMatchingHeader(mimeHeaderList, "Content-Type")) == null ? "text/plain; charset=us-ascii" : cType;
        _mh = _mh + "Content-Type:";
        _mh = _mh + this.canonicalizeHeaderLine(this.uncomment(this.unfold(cType)), true);
        _mh = _mh + _CRLF;
        _mh = _mh + _CRLF;
        byte[] b = null;
        try {
            b = _mh.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return b;
    }

    private String getMatchingHeader(List mimeHeaders, String key) throws XWSSecurityException {
        String header_line = null;
        try {
            for (int i = 0; i < mimeHeaders.size(); ++i) {
                MimeHeader mhr = (MimeHeader)mimeHeaders.get(i);
                if (!mhr.getName().equalsIgnoreCase(key)) continue;
                header_line = mhr.getValue();
                break;
            }
        }
        catch (Exception npe) {
            throw new XWSSecurityException("Failed to locate MIME Header, " + key);
        }
        return header_line;
    }

    private String unfold(String input) {
        if (input.charAt(0) == _QT.charAt(0) || input.charAt(input.length() - 1) == _QT.charAt(0)) {
            return input;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == _CRLF.charAt(0) && i != input.length() - 1 && input.charAt(i + 1) == _CRLF.charAt(1)) {
                ++i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String rfc2047decode(String input) throws XWSSecurityException {
        if (input.charAt(0) == _QT.charAt(0) || input.charAt(input.length() - 1) == _QT.charAt(0)) {
            return input;
        }
        String decodedText = null;
        try {
            decodedText = MimeUtility.decodeText((String)input);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return decodedText;
    }

    private String unfoldWS(String input) {
        if (input.charAt(0) == _QT.charAt(0) || input.charAt(input.length() - 1) == _QT.charAt(0)) {
            return input;
        }
        StringBuffer sb = new StringBuffer();
        block0: for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == _WS.charAt(0) || input.charAt(i) == _HT.charAt(0)) {
                sb.append(_WS.charAt(0));
                ++i;
                while (i != input.length() - 1) {
                    if (input.charAt(i) != _WS.charAt(0) && input.charAt(i) != _HT.charAt(0)) {
                        sb.append(input.charAt(i));
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            sb.append(input.charAt(i));
        }
        return sb.toString();
    }

    private String uncomment(String input) {
        int offset;
        if (input.charAt(0) == _QT.charAt(0) || input.charAt(input.length() - 1) == _QT.charAt(0)) {
            return input;
        }
        int oc = 0;
        while (oc < input.length() && (oc = input.indexOf(_OC)) != -1 && (offset = input.substring(oc).indexOf(_CC)) != -1) {
            int cc = oc + offset;
            String fs = oc != 0 ? input.substring(0, oc) : "";
            String bs = input.substring(cc + 1);
            input = offset == 1 ? fs + _WS + bs : (input.substring(oc + 1, cc).indexOf(_OC) == -1 ? fs + _WS + bs : fs + _OC + this.uncomment(input.substring(oc + 1, cc + 1)) + bs);
            ++oc;
        }
        return input;
    }

    private String canonicalizeHeaderLine(String input, boolean applyStep10SwaDraft13) throws XWSSecurityException {
        int _sc = input.indexOf(_SC);
        if (_sc <= 0 || _sc == input.length() - 1) {
            return input;
        }
        String _fs = input.substring(0, _sc).toLowerCase();
        if (applyStep10SwaDraft13) {
            _fs = this.quote(_fs, false);
        }
        String size = null;
        String type = null;
        String charset = null;
        String padding = null;
        String filename = null;
        String read_date = null;
        String creation_date = null;
        String modification_date = null;
        String decoded = null;
        try {
            decoded = this.rfc2184decode(input.substring(_sc + 1));
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        StringTokenizer strnzr = new StringTokenizer(decoded, _SC);
        while (strnzr.hasMoreElements()) {
            String param = strnzr.nextToken();
            String pname = param.substring(0, param.indexOf(_EQ));
            String value = param.substring(param.indexOf(_EQ) + 1);
            if (pname.equalsIgnoreCase("type")) {
                type = this.quote(value.toLowerCase(), true);
                continue;
            }
            if (pname.equalsIgnoreCase("padding")) {
                padding = this.quote(value.toLowerCase(), true);
                continue;
            }
            if (pname.equalsIgnoreCase("charset")) {
                charset = this.quote(value.toLowerCase(), true);
                continue;
            }
            if (pname.equalsIgnoreCase("filename")) {
                filename = this.quote(value.toLowerCase(), true);
                continue;
            }
            if (pname.equalsIgnoreCase("creation-date")) {
                creation_date = this.quote(value.toLowerCase(), true);
                continue;
            }
            if (pname.equalsIgnoreCase("modification-date")) {
                modification_date = this.quote(value.toLowerCase(), true);
                continue;
            }
            if (pname.equalsIgnoreCase("read-date")) {
                read_date = this.quote(value.toLowerCase(), true);
                continue;
            }
            if (!pname.equalsIgnoreCase("size")) continue;
            size = this.quote(value.toLowerCase(), true);
        }
        if (charset != null) {
            _fs = _fs + ";charset=" + charset;
        }
        if (creation_date != null) {
            _fs = _fs + ";creation-date=" + creation_date;
        }
        if (filename != null) {
            _fs = _fs + ";filename=" + filename;
        }
        if (modification_date != null) {
            _fs = _fs + ";modification-date=" + modification_date;
        }
        if (padding != null) {
            _fs = _fs + ";padding=" + padding;
        }
        if (read_date != null) {
            _fs = _fs + ";read-date=" + read_date;
        }
        if (size != null) {
            _fs = _fs + ";size=" + size;
        }
        if (type != null) {
            _fs = _fs + ";type=" + type;
        }
        return _fs;
    }

    private Vector makeParameterVector(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer nzr = new StringTokenizer(input, _SC);
        while (nzr.hasMoreTokens()) {
            v.add(nzr.nextToken());
        }
        return v;
    }

    private String _rfc2184decode(String input) throws Exception {
        StringTokenizer nzr = new StringTokenizer(input, _SQ);
        if (nzr.countTokens() != 3) {
            throw new XWSSecurityException("Malformed RFC2184 encoded parameter");
        }
        String charset = nzr.nextToken();
        String language = nzr.nextToken();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != _PC.charAt(0)) continue;
            input = input.substring(0, i) + this._decodeHexadecimal(input.substring(i + 1, i + 3), charset, language) + input.substring(i + 3);
        }
        return input;
    }

    private String _decodeHexadecimal(String input, String charset, String language) throws Exception {
        byte b = Byte.decode("0x" + input.toUpperCase());
        return new String(new byte[]{b}, MimeUtility.javaCharset((String)charset));
    }

    private String rfc2184decode(String input) throws Exception {
        int index = -1;
        String pname = "";
        String value = "";
        String decoded = "";
        Vector v = this.makeParameterVector(input);
        for (int i = 0; i < v.size(); ++i) {
            String token = (String)v.elementAt(i);
            int idx = token.indexOf(_EQ);
            String pn = token.substring(0, idx).trim();
            String pv = token.substring(idx + 1).trim();
            if (pn.endsWith(_AX)) {
                pn = pn.substring(0, pn.length() - 1);
                pv = this._rfc2184decode(pv);
                token = pn + _EQ + pv;
                v.setElementAt(token, i);
                --i;
                continue;
            }
            int ix = pn.indexOf(_AX);
            if (ix == -1) {
                if (!pname.equals("")) {
                    decoded = decoded + _SC + pname + _EQ + pv;
                }
                decoded = decoded + _SC + pn + _EQ + pv;
                pname = "";
                value = "";
                index = -1;
                continue;
            }
            String pn_i = pn.substring(0, ix).trim();
            int curr = new Integer(pn.substring(ix + 1).trim());
            if (pn_i.equalsIgnoreCase(pname)) {
                if (curr != index + 1) {
                    throw new XWSSecurityException("Malformed RFC2184 encoded parameter");
                }
                value = value + this.concatenate2184decoded(value, pv);
                ++index;
                continue;
            }
            if (curr == 0) {
                if (!pname.equals("")) {
                    decoded = decoded + _SC + pname + _EQ + value;
                }
                pname = pn_i;
                value = pv;
                ++index;
                continue;
            }
            throw new XWSSecurityException("Malformed RFC2184 encoded parameter");
        }
        if (!pname.equals("")) {
            decoded = decoded + _SC + pname + _EQ + value;
        }
        return decoded;
    }

    private String concatenate2184decoded(String v0, String v1) throws XWSSecurityException {
        boolean v1Quoted;
        boolean v0Quoted = v0.charAt(0) == _QT.charAt(0) && v0.charAt(v0.length() - 1) == _QT.charAt(0);
        boolean bl = v1Quoted = v1.charAt(0) == _QT.charAt(0) && v1.charAt(0) == _QT.charAt(0);
        if (v0Quoted != v1Quoted) {
            throw new XWSSecurityException("Malformed RFC2184 encoded parameter");
        }
        String value = null;
        value = v0Quoted ? v0.substring(0, v0.length() - 1) + v1.substring(1) : v0 + v1;
        return value;
    }

    private String quote(String input, boolean force) {
        input = input.charAt(0) == _QT.charAt(0) || input.charAt(input.length() - 1) == _QT.charAt(0) ? _QT + this.unquoteInner(input.substring(1, input.length() - 1)) + _QT : (force ? _QT + this.quoteInner(this.unfoldWS(input).trim()) + _QT : this.unfoldWS(input).trim());
        return input;
    }

    private String unquoteInner(String input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == _BS.charAt(0)) {
                char d;
                if (i == input.length() - 1) {
                    sb.append(c);
                    sb.append(c);
                    break;
                }
                if ((d = input.charAt(++i)) == _QT.charAt(0) || d == _BS.charAt(0)) {
                    sb.append(c);
                    sb.append(d);
                    continue;
                }
                sb.append(d);
                continue;
            }
            if (c == _QT.charAt(0)) {
                sb.append(_BS.charAt(0));
                sb.append(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String quoteInner(String input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == _BS.charAt(0) || c == _QT.charAt(0)) {
                sb.append(_BS.charAt(0));
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

