/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;

public class WsTxUtils {
    private static Logger logger = LogDomains.getLogger(WsTxUtils.class, (String)"javax.enterprise.webservices");

    public static String getDefaultVirtualServerHostAndPort(boolean secure) {
        String host = WsTxUtils.getHostName();
        String port = WsTxUtils.getPort(secure);
        if (host == null || port == null) {
            return null;
        }
        return host + ":" + port;
    }

    private static String getHostName() {
        return System.getProperty("com.sun.aas.hostName");
    }

    private static String getPort(boolean secure) {
        try {
            String[] networkListenerNames;
            String serverName = System.getProperty("com.sun.aas.instanceName");
            if (serverName == null) {
                ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
                if (serverContext != null) {
                    serverName = serverContext.getInstanceName();
                }
                if (serverName == null) {
                    serverName = "server";
                }
            }
            Config config = (Config)Globals.getDefaultHabitat().getComponent(Config.class, "default-instance-name");
            for (String listenerName : networkListenerNames = config.getHttpService().getVirtualServerByName(serverName).getNetworkListeners().split(",")) {
                NetworkListener listener;
                if (listenerName == null || listenerName.length() == 0 || secure != Boolean.valueOf((listener = config.getNetworkConfig().getNetworkListener(listenerName.trim())).findHttpProtocol().getSecurityEnabled())) continue;
                return listener.getPort();
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINEST, "Exception occurred retrieving port configuration for WSTX service", t);
        }
        return null;
    }
}

