/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.Addressing;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.api.EJBInvocation;
import org.glassfish.ejb.api.EjbEndpointFacade;
import org.glassfish.webservices.AdapterInvocationInfo;
import org.glassfish.webservices.Ejb3MessageDispatcher;
import org.glassfish.webservices.EjbInvokerImpl;
import org.glassfish.webservices.EjbMessageDispatcher;
import org.glassfish.webservices.InstanceResolverImpl;
import org.glassfish.webservices.JAXWSContainer;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.WsUtil;

public class EjbRuntimeEndpointInfo {
    protected Logger logger = LogDomains.getLogger(this.getClass(), (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();
    protected final WebServiceEndpoint endpoint;
    protected final EjbEndpointFacade container;
    protected final Object webServiceEndpointServant;
    private ServletAdapter adapter = null;
    private ServletAdapterList adapterList = null;
    private WebServiceContextImpl wsCtxt = null;
    private boolean handlersConfigured = false;
    protected EjbMessageDispatcher messageDispatcher = null;

    public EjbRuntimeEndpointInfo(WebServiceEndpoint webServiceEndpoint, EjbEndpointFacade ejbContainer, Object servant) {
        this.endpoint = webServiceEndpoint;
        this.container = ejbContainer;
        this.webServiceEndpointServant = servant;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getEndpointAddressUri() {
        return this.endpoint.getEndpointAddressUri();
    }

    public WebServiceContext getWebServiceContext() {
        return this.wsCtxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object prepareInvocation(boolean doPreInvoke) throws Exception {
        EjbRuntimeEndpointInfo ejbRuntimeEndpointInfo;
        ComponentInvocation inv = null;
        AdapterInvocationInfo adapterInvInfo = new AdapterInvocationInfo();
        if (this.adapter == null) {
            ejbRuntimeEndpointInfo = this;
            synchronized (ejbRuntimeEndpointInfo) {
                if (this.adapter == null) {
                    try {
                        EjbDescriptor ejbDesc = this.endpoint.getEjbComponentImpl();
                        for (ResourceReferenceDescriptor r : ejbDesc.getResourceReferenceDescriptors()) {
                            if (!r.isWebServiceContext()) continue;
                            Iterator iter = r.getInjectionTargets().iterator();
                            boolean matchingClassFound = false;
                            while (iter.hasNext()) {
                                InjectionTarget target = (InjectionTarget)iter.next();
                                if (!ejbDesc.getEjbClassName().equals(target.getClassName())) continue;
                                matchingClassFound = true;
                                break;
                            }
                            if (!matchingClassFound) continue;
                            try {
                                InitialContext ic = new InitialContext();
                                this.wsCtxt = (WebServiceContextImpl)ic.lookup("java:comp/env/" + r.getName());
                            }
                            catch (Throwable t) {
                                this.logger.fine("Error In EjbRuntimeEndpointInfo" + t.getCause());
                            }
                        }
                        if (this.wsCtxt == null) {
                            this.wsCtxt = new WebServiceContextImpl();
                        }
                    }
                    catch (Throwable t) {
                        this.logger.severe("Cannot initialize endpoint " + this.endpoint.getName() + " : error is : " + t.getMessage());
                        return null;
                    }
                }
            }
        }
        if (doPreInvoke) {
            inv = this.container.startInvocation();
            adapterInvInfo.setInv(inv);
        }
        if (!this.handlersConfigured && doPreInvoke) {
            ejbRuntimeEndpointInfo = this;
            synchronized (ejbRuntimeEndpointInfo) {
                if (!this.handlersConfigured) {
                    try {
                        String urlPattern;
                        WsUtil wsu = new WsUtil();
                        String implClassName = this.endpoint.getEjbComponentImpl().getEjbClassName();
                        Class<?> clazz = this.container.getEndpointClassLoader().loadClass(implClassName);
                        String givenBinding = this.endpoint.getProtocolBinding();
                        SDDocumentSource primaryWsdl = null;
                        Collection docs = null;
                        if (this.endpoint.getWebService().hasWsdlFile()) {
                            URL pkgedWsdl = clazz.getResource('/' + this.endpoint.getWebService().getWsdlFileUri());
                            if (pkgedWsdl == null) {
                                pkgedWsdl = this.endpoint.getWebService().getWsdlFileUrl();
                            }
                            if (pkgedWsdl != null) {
                                primaryWsdl = SDDocumentSource.create((URL)pkgedWsdl);
                                docs = wsu.getWsdlsAndSchemas(pkgedWsdl);
                            }
                        }
                        JAXWSContainer container = new JAXWSContainer(null, this.endpoint);
                        URL catalogURL = clazz.getResource('/' + this.endpoint.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
                        boolean mtomEnabled = wsu.getMtom(this.endpoint);
                        WSBinding binding = null;
                        ArrayList<Object> wsFeatures = new ArrayList<Object>();
                        if (mtomEnabled) {
                            int mtomThreshold = this.endpoint.getMtomThreshold() != null ? new Integer(this.endpoint.getMtomThreshold()) : 0;
                            MTOMFeature mtom = new MTOMFeature(true, mtomThreshold);
                            wsFeatures.add(mtom);
                        }
                        Addressing addressing = this.endpoint.getAddressing();
                        if (this.endpoint.getAddressing() != null) {
                            AddressingFeature addressingFeature = new AddressingFeature(addressing.isEnabled(), addressing.isRequired(), this.getResponse(addressing.getResponses()));
                            wsFeatures.add(addressingFeature);
                        }
                        binding = wsFeatures.size() > 0 ? BindingID.parse((String)givenBinding).createBinding(wsFeatures.toArray(new WebServiceFeature[0])) : BindingID.parse((String)givenBinding).createBinding();
                        wsu.configureJAXWSServiceHandlers(this.endpoint, this.endpoint.getProtocolBinding(), binding);
                        Invoker invoker = new InstanceResolverImpl(clazz).createInvoker();
                        WSEndpoint wsep = WSEndpoint.create(clazz, (boolean)false, (Invoker)new EjbInvokerImpl(clazz, invoker, this.webServiceEndpointServant, this.wsCtxt), (QName)this.endpoint.getServiceName(), (QName)this.endpoint.getWsdlPort(), (Container)container, (WSBinding)binding, (SDDocumentSource)primaryWsdl, (Collection)docs, (URL)catalogURL);
                        String uri = this.endpoint.getEndpointAddressUri();
                        String string = urlPattern = uri.startsWith("/") ? uri : "/" + uri;
                        if (this.adapterList == null) {
                            this.adapterList = new ServletAdapterList();
                        }
                        this.adapter = (ServletAdapter)this.adapterList.createAdapter(this.endpoint.getName(), urlPattern, wsep);
                        this.handlersConfigured = true;
                    }
                    catch (Throwable t) {
                        this.logger.log(Level.SEVERE, "Cannot initialize endpoint " + this.endpoint.getName() + " : error is : ", t);
                        this.adapter = null;
                    }
                }
            }
        }
        this.addWSContextInfo(this.wsCtxt);
        if (inv != null) {
            EJBInvocation ejbInv = (EJBInvocation)inv;
            ejbInv.setWebServiceContext((Object)this.wsCtxt);
        }
        adapterInvInfo.setAdapter(this.adapter);
        return adapterInvInfo;
    }

    private void addWSContextInfo(WebServiceContextImpl wsCtxt) {
        WebServiceContextImpl wsc = null;
        EjbDescriptor bundle = this.endpoint.getEjbComponentImpl();
        for (ResourceReferenceDescriptor r : bundle.getResourceReferenceDescriptors()) {
            if (!r.isWebServiceContext()) continue;
            for (InjectionTarget target : r.getInjectionTargets()) {
                try {
                    InitialContext ic = new InitialContext();
                    wsc = (WebServiceContextImpl)ic.lookup("java:comp/env/" + r.getName());
                }
                catch (Throwable t) {
                    this.logger.fine(this.rb.getString("exception.thrown") + t);
                }
                if (wsc == null) continue;
                wsc.setContextDelegate(wsCtxt.getContextDelegate());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRuntimeInfo(ServletAdapterList list) throws Exception {
        AdapterInvocationInfo aInfo = null;
        try {
            this.adapterList = list;
            aInfo = (AdapterInvocationInfo)this.prepareInvocation(true);
        }
        finally {
            if (aInfo != null) {
                this.releaseImplementor(aInfo.getInv());
            }
        }
    }

    public InvocationManager getInvocationManager() {
        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
        return wscImpl.getInvocationManager();
    }

    public void releaseImplementor(ComponentInvocation inv) {
        this.container.endInvocation(inv);
    }

    public EjbMessageDispatcher getMessageDispatcher() {
        if (this.messageDispatcher == null) {
            this.messageDispatcher = new Ejb3MessageDispatcher();
        }
        return this.messageDispatcher;
    }

    public EjbEndpointFacade getContainer() {
        return this.container;
    }

    private AddressingFeature.Responses getResponse(String s) {
        if (s != null) {
            return (AddressingFeature.Responses)AddressingFeature.Responses.valueOf(AddressingFeature.Responses.class, (String)s);
        }
        return AddressingFeature.Responses.ALL;
    }
}

