/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.api;

import com.sun.xml.ws.rx.rm.api.RmAssertionNamespace;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RmProtocolVersion {
    WSRM200502("http://schemas.xmlsoap.org/ws/2005/02/rm", RmAssertionNamespace.WSRMP_200502.toString(), "RMAssertion", "/LastMessage"),
    WSRM200702("http://docs.oasis-open.org/ws-rx/wsrm/200702", RmAssertionNamespace.WSRMP_200702.toString(), "RMAssertion", "/CloseSequence");

    public final String protocolNamespaceUri;
    public final String policyNamespaceUri;
    public final String ackRequestedAction;
    public final String createSequenceAction;
    public final String createSequenceResponseAction;
    public final String closeSequenceAction;
    public final String closeSequenceResponseAction;
    public final String sequenceAcknowledgementAction;
    public final String wsrmFaultAction;
    public final String terminateSequenceAction;
    public final String terminateSequenceResponseAction;
    public final QName rmAssertionName;
    public final QName sequenceTerminatedFaultCode;
    public final QName unknownSequenceFaultCode;
    public final QName invalidAcknowledgementFaultCode;
    public final QName messageNumberRolloverFaultCode;
    public final QName lastMessageNumberExceededFaultCode;
    public final QName createSequenceRefusedFaultCode;
    public final QName sequenceClosedFaultCode;
    public final QName wsrmRequiredFaultCode;

    private RmProtocolVersion(String protocolNamespaceUri, String policyNamespaceUri, String rmAssertionLocalName, String closeSequenceActionSuffix) {
        this.protocolNamespaceUri = protocolNamespaceUri;
        this.policyNamespaceUri = policyNamespaceUri;
        this.rmAssertionName = new QName(policyNamespaceUri, rmAssertionLocalName);
        this.ackRequestedAction = protocolNamespaceUri + "/AckRequested";
        this.createSequenceAction = protocolNamespaceUri + "/CreateSequence";
        this.createSequenceResponseAction = protocolNamespaceUri + "/CreateSequenceResponse";
        this.closeSequenceAction = protocolNamespaceUri + closeSequenceActionSuffix;
        this.closeSequenceResponseAction = protocolNamespaceUri + "/CloseSequenceResponse";
        this.sequenceAcknowledgementAction = protocolNamespaceUri + "/SequenceAcknowledgement";
        this.wsrmFaultAction = protocolNamespaceUri + "/fault";
        this.terminateSequenceAction = protocolNamespaceUri + "/TerminateSequence";
        this.terminateSequenceResponseAction = protocolNamespaceUri + "/TerminateSequenceResponse";
        this.sequenceTerminatedFaultCode = new QName(protocolNamespaceUri, "SequenceTerminated");
        this.unknownSequenceFaultCode = new QName(protocolNamespaceUri, "UnknownSequence");
        this.invalidAcknowledgementFaultCode = new QName(protocolNamespaceUri, "InvalidAcknowledgement");
        this.messageNumberRolloverFaultCode = new QName(protocolNamespaceUri, "MessageNumberRollover");
        this.lastMessageNumberExceededFaultCode = new QName(protocolNamespaceUri, "LastMessageNumberExceeded");
        this.createSequenceRefusedFaultCode = new QName(protocolNamespaceUri, "CreateSequenceRefused");
        this.sequenceClosedFaultCode = new QName(protocolNamespaceUri, "SequenceClosed");
        this.wsrmRequiredFaultCode = new QName(protocolNamespaceUri, "WSRMRequired");
    }

    public static RmProtocolVersion getDefault() {
        return WSRM200702;
    }

    public boolean isProtocolAction(String wsaAction) {
        return wsaAction != null && (this.isProtocolRequest(wsaAction) || this.isProtocolResponse(wsaAction) || this.isFault(wsaAction));
    }

    public boolean isProtocolRequest(String wsaAction) {
        return wsaAction != null && (this.ackRequestedAction.equals(wsaAction) || this.createSequenceAction.equals(wsaAction) || this.closeSequenceAction.equals(wsaAction) || this.terminateSequenceAction.equals(wsaAction));
    }

    public boolean isProtocolResponse(String wsaAction) {
        return wsaAction != null && (this.createSequenceResponseAction.equals(wsaAction) || this.closeSequenceResponseAction.equals(wsaAction) || this.sequenceAcknowledgementAction.equals(wsaAction) || this.terminateSequenceResponseAction.equals(wsaAction));
    }

    public boolean isFault(String wsaAction) {
        return this.wsrmFaultAction.equals(wsaAction);
    }
}

