/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.assembler.dev.HighAvailabilityProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.ReplicationManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.ha.store.api.BackingStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HighlyAvailableMap<K extends Serializable, V>
implements Map<K, V> {
    private final Map<K, V> localMap;
    private final ReplicationManager<K, V> replicationManager;

    public static <K extends Serializable, V extends Serializable> HighlyAvailableMap<K, V> newInstanceForBs(Map<K, V> wrappedMap, BackingStore<K, V> backingStore) {
        return new HighlyAvailableMap<K, V>(wrappedMap, new SimpleReplicationManager<K, V>(backingStore));
    }

    public static <K extends Serializable, V> HighlyAvailableMap<K, V> newInstance(Map<K, V> wrappedMap, ReplicationManager<K, V> replicationManager) {
        if (replicationManager == null) {
            replicationManager = new NoopReplicationManager();
        }
        return new HighlyAvailableMap<K, V>(wrappedMap, replicationManager);
    }

    private HighlyAvailableMap(Map<K, V> wrappedMap, ReplicationManager<K, V> replicationManager) {
        this.localMap = wrappedMap;
        this.replicationManager = replicationManager;
    }

    @Override
    public int size() {
        return this.localMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.localMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Serializable _key = (Serializable)key;
        if (this.localMap.containsKey(_key)) {
            return true;
        }
        return this.tryLoad(_key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.localMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        Serializable _key = (Serializable)key;
        V value = this.localMap.get(_key);
        if (value != null) {
            return value;
        }
        return this.tryLoad(_key);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.localMap.put(key, value);
        this.replicationManager.save(key, value, oldValue == null);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        Serializable _key = (Serializable)key;
        V oldValue = this.localMap.remove(_key);
        this.replicationManager.remove(_key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put((K)((Serializable)e.getKey()), e.getValue());
        }
    }

    private V tryLoad(K key) {
        V value = this.replicationManager.load(key);
        if (value != null) {
            this.localMap.put(key, value);
        }
        return value;
    }

    @Override
    public void clear() {
        this.localMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.localMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.localMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.localMap.entrySet();
    }

    public Map<K, V> getLocalMapCopy() {
        return new HashMap<K, V>(this.localMap);
    }

    public ReplicationManager<K, V> getReplicationManager() {
        return this.replicationManager;
    }

    public void close() {
        this.replicationManager.close();
    }

    public void destroy() {
        this.replicationManager.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SimpleReplicationManager<K extends Serializable, V extends Serializable>
    implements ReplicationManager<K, V> {
        private final BackingStore<K, V> backingStore;

        public SimpleReplicationManager(BackingStore<K, V> backingStore) {
            this.backingStore = backingStore;
        }

        @Override
        public V load(K key) {
            return HighAvailabilityProvider.INSTANCE.loadFrom(this.backingStore, key, (String)null);
        }

        @Override
        public String save(K key, V value, boolean isNew) {
            return HighAvailabilityProvider.INSTANCE.saveTo(this.backingStore, key, value, isNew);
        }

        @Override
        public void remove(K key) {
            HighAvailabilityProvider.INSTANCE.removeFrom(this.backingStore, key);
        }

        @Override
        public void close() {
            HighAvailabilityProvider.INSTANCE.close(this.backingStore);
        }

        @Override
        public void destroy() {
            HighAvailabilityProvider.INSTANCE.destroy(this.backingStore);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NoopReplicationManager<K extends Serializable, V>
    implements ReplicationManager<K, V> {
        private NoopReplicationManager() {
        }

        @Override
        public V load(K key) {
            return null;
        }

        @Override
        public String save(K key, V value, boolean isNew) {
            return "";
        }

        @Override
        public void remove(K key) {
        }

        @Override
        public void close() {
        }

        @Override
        public void destroy() {
        }
    }
}

