/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.api.Transactional;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;

public class WSATSynchronization
implements Synchronization {
    Xid m_xid;
    String m_status = "UNKNOWN";
    private static final String UNKNOWN = "UNKNOWN";
    boolean m_isRemovedFromMap = false;
    Transactional.Version m_version;
    EndpointReference m_epr;

    public WSATSynchronization(EndpointReference epr, Xid xid) {
        this(Transactional.Version.WSAT10, epr, xid);
    }

    public WSATSynchronization(Transactional.Version version, EndpointReference epr, Xid xid) {
        this.m_version = version;
        this.m_xid = xid;
        this.m_epr = epr;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        try {
            WSATHelper.getInstance().beforeCompletion(this.m_epr, this.m_xid, this);
            WSATSynchronization wSATSynchronization = this;
            synchronized (wSATSynchronization) {
                block13: {
                    if (!this.m_status.equals("Committed")) break block13;
                    return;
                }
                this.wait(WSATHelper.getInstance().getWaitForReplyTimeout());
            }
            if (!this.m_status.equals("Committed")) {
                this.setRollbackOnly();
            }
        }
        catch (InterruptedException e) {
            this.setRollbackOnly();
        }
        catch (Exception e) {
            this.setRollbackOnly();
        }
        finally {
            WSATHelper.getInstance().removeVolatileParticipant(this.m_xid);
            this.m_isRemovedFromMap = true;
        }
    }

    private void setRollbackOnly() {
        Object transaction = null;
        if (transaction != null) {
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    public void afterCompletion(int status) {
    }

    Xid getXid() {
        return this.m_xid;
    }

    public boolean equals(Object obj) {
        return obj instanceof WSATSynchronization && ((WSATSynchronization)obj).getXid().equals(this.m_xid);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.m_isRemovedFromMap) {
            WSATHelper.getInstance().removeVolatileParticipant(this.m_xid);
        }
    }
}

