/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common;

import com.sun.xml.ws.tx.at.common.TransactionImportWrapper;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.common.TxLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import javax.resource.spi.XATerminator;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;

public class TransactionImportManager
implements TransactionImportWrapper {
    private static final TxLogger logger = TxLogger.getATLogger(TransactionImportManager.class);
    private static final TransactionImportManager INSTANCE = new TransactionImportManager();
    private final TransactionManager javaeeTM;
    private final MethodInfo<?> recreate;
    private final MethodInfo<?> release;
    private final MethodInfo<XATerminator> getXATerminator;
    private final MethodInfo<Integer> getTransactionRemainingTimeout;

    public static TransactionImportManager getInstance() {
        return INSTANCE;
    }

    private TransactionImportManager() {
        this(TransactionManagerImpl.getInstance().getTransactionManager());
    }

    private TransactionImportManager(TransactionManager tm) {
        this.javaeeTM = tm;
        this.recreate = new MethodInfo<Void>("recreate", new Class[]{Xid.class, Long.TYPE}, Void.TYPE);
        this.release = new MethodInfo<Void>("release", new Class[]{Xid.class}, Void.TYPE);
        this.getXATerminator = new MethodInfo<XATerminator>("getXATerminator", new Class[0], XATerminator.class);
        this.getTransactionRemainingTimeout = new MethodInfo<Integer>("getTransactionRemainingTimeout", new Class[0], Integer.TYPE, Integer.class);
        MethodInfo[] requiredMethods = new MethodInfo[]{this.recreate, this.release, this.getXATerminator, this.getTransactionRemainingTimeout};
        int remainingMethodsToFind = requiredMethods.length;
        if (this.javaeeTM != null) {
            for (Method m : this.javaeeTM.getClass().getDeclaredMethods()) {
                for (MethodInfo mi : requiredMethods) {
                    if (!mi.isCompatibleWith(m)) continue;
                    mi.method = m;
                    --remainingMethodsToFind;
                }
                if (remainingMethodsToFind == 0) break;
            }
        }
        if (remainingMethodsToFind != 0) {
            StringBuilder sb = new StringBuilder("Missing required extension methods detected on '" + TransactionManager.class.getName() + "' implementation '" + this.javaeeTM.getClass().getName() + "':\n");
            for (MethodInfo mi : requiredMethods) {
                if (mi.method != null) continue;
                sb.append(mi.methodName).append("\n");
            }
        }
    }

    public void recreate(Xid xid, long timeout) {
        this.recreate.invoke(this.javaeeTM, xid, timeout);
    }

    public void release(Xid xid) {
        this.release.invoke(this.javaeeTM, xid);
    }

    public XATerminator getXATerminator() {
        return this.getXATerminator.invoke(this.javaeeTM, new Object[0]);
    }

    public int getTransactionRemainingTimeout() throws SystemException {
        int result;
        block2: {
            String METHOD = "getTransactionRemainingTimeout";
            result = 0;
            try {
                result = this.getTransactionRemainingTimeout.invoke(this.javaeeTM, new Object[0]);
            }
            catch (IllegalStateException ise) {
                if (!logger.isLogging(Level.FINEST)) break block2;
                logger.finest("getTransactionRemainingTimeout", "looking up remaining txn timeout, no current transaction", ise);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodInfo<T> {
        final String methodName;
        final Class<?>[] parameterTypes;
        final Class<?> returnType;
        final Class<T> returnTypeCaster;
        Method method;

        public MethodInfo(String methodName, Class<?>[] parameterTypes, Class<T> returnType) {
            this(methodName, parameterTypes, returnType, returnType);
        }

        public MethodInfo(String methodName, Class<?>[] parameterTypes, Class<?> returnType, Class<T> returnTypeCaster) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
            this.returnTypeCaster = returnTypeCaster;
        }

        public boolean isCompatibleWith(Method m) {
            if (!this.methodName.equals(m.getName())) {
                return false;
            }
            if (!Modifier.isPublic(m.getModifiers())) {
                return false;
            }
            if (!this.returnType.isAssignableFrom(m.getReturnType())) {
                return false;
            }
            Class<?>[] otherParamTypes = m.getParameterTypes();
            if (this.parameterTypes.length != otherParamTypes.length) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (this.parameterTypes[i].isAssignableFrom(otherParamTypes[i])) continue;
                return false;
            }
            return true;
        }

        public T invoke(TransactionManager tmInstance, Object ... args) {
            try {
                Object result = this.method.invoke((Object)tmInstance, args);
                return this.returnTypeCaster.cast(result);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

