/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.policy.spi_impl;

import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.ws.policy.subject.WsdlBindingSubject;
import com.sun.xml.ws.tx.at.api.Transactional;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import com.sun.xml.ws.tx.at.policy.AtPolicyCreator;
import com.sun.xml.ws.tx.at.policy.EjbTransactionType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtPolicyMapConfigurator
implements PolicyMapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(AtPolicyMapConfigurator.class);

    @Override
    public Collection<PolicySubject> update(PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        LinkedList<PolicySubject> subjects = new LinkedList<PolicySubject>();
        Class<?> seiClass = this.getDeclaringClass(model);
        if (seiClass == null) {
            return subjects;
        }
        EjbTransactionType defaultEjbTxnAttr = EjbTransactionType.NOT_DEFINED;
        Transactional defaultFeature = seiClass.getAnnotation(Transactional.class);
        for (JavaMethod javaMethod : model.getJavaMethods()) {
            Transactional effectiveFeature = this.getEffectiveFeature(javaMethod.getSEIMethod(), defaultFeature);
            if (effectiveFeature == null || !effectiveFeature.enabled()) continue;
            EjbTransactionType effectiveEjbTxType = defaultEjbTxnAttr.getEffectiveType(javaMethod.getSEIMethod());
            String policyId = model.getBoundPortTypeName().getLocalPart() + "_" + javaMethod.getOperationName() + "_WSAT_Policy";
            Policy policy = AtPolicyCreator.createPolicy(policyId, effectiveFeature.version().namespaceVersion, effectiveFeature.value(), effectiveEjbTxType);
            if (policy == null) continue;
            WsdlBindingSubject wsdlSubject = WsdlBindingSubject.createBindingOperationSubject(model.getBoundPortTypeName(), new QName(model.getTargetNamespace(), javaMethod.getOperationName()));
            PolicySubject generatedWsatPolicySubject = new PolicySubject((Object)wsdlSubject, policy);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(LocalizationMessages.WSAT_1002_ADD_AT_POLICY_ASSERTION(model.getPortName().toString(), javaMethod.getOperationName(), seiClass.getName(), javaMethod.getSEIMethod().getName(), effectiveFeature.value().toString(), effectiveEjbTxType.toString(), policy.toString()));
            }
            subjects.add(generatedWsatPolicySubject);
        }
        return subjects;
    }

    private Class<?> getDeclaringClass(@Nullable SEIModel model) {
        if (model == null || model.getJavaMethods().isEmpty()) {
            return null;
        }
        return model.getJavaMethods().iterator().next().getSEIMethod().getDeclaringClass();
    }

    private Transactional getEffectiveFeature(Method method, Transactional defaultFeature) {
        Transactional feature = method.getAnnotation(Transactional.class);
        if (feature != null) {
            return feature;
        }
        return defaultFeature;
    }
}

