/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.cli;

import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.webservices.WebServicesContainer;
import org.glassfish.webservices.deployment.DeployedEndpointData;
import org.glassfish.webservices.deployment.WebServicesDeploymentMBean;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="__list-webservices")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
public class ListWebServicesCommand
implements AdminCommand {
    @Inject
    private Habitat habitat;
    @Param(optional=true, alias="applicationname")
    String appName;
    @Param(optional=true)
    String moduleName;
    @Param(optional=true)
    String endpointName;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        WebServicesContainer container = (WebServicesContainer)this.habitat.getComponent(WebServicesContainer.class);
        if (container == null) {
            return;
        }
        WebServicesDeploymentMBean bean = container.getDeploymentBean();
        if (this.appName != null && this.moduleName != null && this.endpointName != null) {
            Map<String, Map<String, Map<String, DeployedEndpointData>>> endpoints = bean.getEndpoint(this.appName, this.moduleName, this.endpointName);
            this.fillEndpoints(report, endpoints);
        } else if (this.appName != null && this.moduleName != null) {
            Map<String, Map<String, Map<String, DeployedEndpointData>>> endpoints = bean.getEndpoints(this.appName, this.moduleName);
            this.fillEndpoints(report, endpoints);
        } else if (this.appName != null) {
            Map<String, Map<String, Map<String, DeployedEndpointData>>> endpoints = bean.getEndpoints(this.appName);
            this.fillEndpoints(report, endpoints);
        } else {
            Map<String, Map<String, Map<String, DeployedEndpointData>>> endpoints = bean.getEndpoints();
            this.fillEndpoints(report, endpoints);
        }
    }

    private void fillEndpoints(ActionReport report, Map<String, Map<String, Map<String, DeployedEndpointData>>> endpoints) {
        if (!endpoints.isEmpty()) {
            Properties extra = new Properties();
            extra.putAll(endpoints);
            report.setExtraProperties(extra);
            ActionReport.MessagePart top = report.getTopMessagePart();
            for (Map.Entry<String, Map<String, Map<String, DeployedEndpointData>>> app : endpoints.entrySet()) {
                ActionReport.MessagePart child = top.addChild();
                child.setMessage("application:" + app.getKey());
                for (Map.Entry<String, Map<String, DeployedEndpointData>> module : app.getValue().entrySet()) {
                    child = child.addChild();
                    child.setMessage("  module:" + module.getKey());
                    for (Map.Entry<String, DeployedEndpointData> endpoint : module.getValue().entrySet()) {
                        child = child.addChild();
                        child.setMessage("    endpoint:" + endpoint.getKey());
                        for (Map.Entry<String, String> endpointData : endpoint.getValue().getStaticAsMap().entrySet()) {
                            child = child.addChild();
                            child.setMessage("      " + endpointData.getKey() + ":" + endpointData.getValue());
                        }
                    }
                }
            }
        }
    }
}

