/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.TrustAssertion;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust13
extends PolicyAssertion
implements TrustAssertion,
SecurityAssertionValidator {
    Set<String> requiredProps;
    String version = "1.3";
    private boolean populated = false;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion;

    public Trust13() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY12NS;
    }

    public Trust13(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    public void addRequiredProperty(String requirement) {
        if (this.requiredProps == null) {
            this.requiredProps = new HashSet<String>();
        }
        this.requiredProps.add(requirement);
    }

    @Override
    public Set getRequiredProperties() {
        this.populate();
        return this.requiredProps;
    }

    @Override
    public String getType() {
        return this.version;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            if (policy == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isSupportClientChallenge(assertion, this.spVersion)) {
                    this.addRequiredProperty("MustSupportClientChallenge");
                    continue;
                }
                if (PolicyUtil.isSupportServerChallenge(assertion, this.spVersion)) {
                    this.addRequiredProperty("MustSupportServerChallenge");
                    continue;
                }
                if (PolicyUtil.isRequireClientEntropy(assertion, this.spVersion)) {
                    this.addRequiredProperty("RequireClientEntropy");
                    continue;
                }
                if (PolicyUtil.isRequireServerEntropy(assertion, this.spVersion)) {
                    this.addRequiredProperty("RequireServerEntropy");
                    continue;
                }
                if (PolicyUtil.isSupportIssuedTokens(assertion, this.spVersion)) {
                    this.addRequiredProperty("MustSupportIssuedTokens");
                    continue;
                }
                if (PolicyUtil.isRequestSecurityTokenCollection(assertion, this.spVersion)) {
                    this.addRequiredProperty("RequireRequestSecurityTokenCollection");
                    continue;
                }
                if (PolicyUtil.isAppliesTo(assertion, this.spVersion)) {
                    this.addRequiredProperty("RequireAppliesTo");
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "Trust13");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

