/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.client;

import com.sun.xml.ws.transport.http.client.HttpCookie;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieJar {
    private transient Map<String, List<HttpCookie>> cookieJar = new HashMap<String, List<HttpCookie>>();

    public synchronized void recordAnyCookies(URL url, Map<String, List<String>> resHeaders) {
        List<String> cookies = resHeaders.get("Set-Cookie");
        if (cookies != null) {
            for (String cookie : cookies) {
                this.recordCookie(url, cookie);
            }
        }
    }

    private void recordCookie(URL url, String cookieValue) {
        HttpCookie cookie = new HttpCookie(url, cookieValue);
        String[] twodot = new String[]{"com", "edu", "net", "org", "gov", "mil", "int"};
        String domain = cookie.getDomain();
        if (domain == null) {
            return;
        }
        domain = domain.toLowerCase();
        String host = url.getHost();
        boolean domainOK = (host = host.toLowerCase()).equals(domain);
        if (!domainOK && host.endsWith(domain)) {
            int dotsNeeded = 2;
            for (String aTwodot : twodot) {
                if (!domain.endsWith(aTwodot)) continue;
                dotsNeeded = 1;
            }
            int lastChar = domain.length();
            while (lastChar > 0 && dotsNeeded > 0) {
                lastChar = domain.lastIndexOf(46, lastChar - 1);
                --dotsNeeded;
            }
            if (lastChar > 0) {
                domainOK = true;
            }
        }
        if (domainOK) {
            this.recordCookie(cookie);
        }
    }

    private void recordCookie(HttpCookie cookie) {
        CookieJar.recordCookieToJar(cookie, this.cookieJar);
    }

    private static void recordCookieToJar(HttpCookie cookie, Map<String, List<HttpCookie>> jar) {
        String domain = cookie.getDomain().toLowerCase();
        List<HttpCookie> cookieList = jar.get(domain);
        if (cookieList == null) {
            cookieList = new Vector<HttpCookie>();
        }
        if (CookieJar.addOrReplaceCookie(cookieList, cookie)) {
            jar.put(domain, cookieList);
        }
    }

    private static boolean addOrReplaceCookie(List<HttpCookie> cookies, HttpCookie cookie) {
        int numCookies = cookies.size();
        String path = cookie.getPath();
        String name = cookie.getName();
        HttpCookie replaced = null;
        int replacedIndex = -1;
        for (int i = 0; i < numCookies; ++i) {
            String existingName;
            HttpCookie existingCookie = cookies.get(i);
            String existingPath = existingCookie.getPath();
            if (!path.equals(existingPath) || !name.equals(existingName = existingCookie.getName())) continue;
            replaced = existingCookie;
            replacedIndex = i;
            break;
        }
        if (replaced != null) {
            cookies.set(replacedIndex, cookie);
        } else {
            cookies.add(cookie);
        }
        return true;
    }

    public synchronized void applyRelevantCookies(URL url, Map<String, List<String>> reqHeaders) {
        int index;
        String host = url.getHost();
        this.applyCookiesForHost(host, url, reqHeaders);
        while ((index = host.indexOf(46, 1)) >= 0) {
            host = host.substring(index + 1);
            this.applyCookiesForHost(host, url, reqHeaders);
        }
    }

    private void applyCookiesForHost(String host, URL url, Map<String, List<String>> reqHeaders) {
        List<HttpCookie> cookieList = this.cookieJar.get(host = host.toLowerCase());
        if (cookieList == null) {
            return;
        }
        String path = url.getFile();
        int queryInd = path.indexOf(63);
        if (queryInd > 0) {
            path = path.substring(0, queryInd);
        }
        ArrayList<HttpCookie> cookiesToSend = new ArrayList<HttpCookie>(10);
        for (HttpCookie cookie : cookieList) {
            String cookiePath = cookie.getPath();
            if (!path.startsWith(cookiePath) || cookie.hasExpired()) continue;
            cookiesToSend.add(cookie);
        }
        if (cookiesToSend.size() > 1) {
            for (int i = 0; i < cookiesToSend.size() - 1; ++i) {
                HttpCookie headC = (HttpCookie)cookiesToSend.get(i);
                String head = headC.getPath();
                if (!head.endsWith("/")) {
                    head = head + "/";
                }
                for (int j = i + 1; j < cookiesToSend.size(); ++j) {
                    HttpCookie scanC = (HttpCookie)cookiesToSend.get(j);
                    String scan = scanC.getPath();
                    if (!scan.endsWith("/")) {
                        scan = scan + "/";
                    }
                    int headCount = 0;
                    int index = -1;
                    while ((index = head.indexOf(47, index + 1)) != -1) {
                        ++headCount;
                    }
                    index = -1;
                    int scanCount = 0;
                    while ((index = scan.indexOf(47, index + 1)) != -1) {
                        ++scanCount;
                    }
                    if (scanCount <= headCount) continue;
                    cookiesToSend.set(j, headC);
                    cookiesToSend.set(i, scanC);
                    headC = scanC;
                    head = scan;
                }
            }
        }
        String cookieStr = null;
        for (HttpCookie cookie : cookiesToSend) {
            if (cookieStr == null) {
                cookieStr = cookie.getNameValue();
                continue;
            }
            cookieStr = cookieStr + "; " + cookie.getNameValue();
        }
        if (cookieStr != null) {
            reqHeaders.put("Cookie", Collections.singletonList(cookieStr));
        }
    }
}

